/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.search;

import io.cucumber.eclipse.editor.ResourceHelper;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.plugins.CucumberCodeLocation;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.search.CucumberStepMatch;
import io.cucumber.eclipse.java.validation.GlueSteps;
import io.cucumber.eclipse.java.validation.JavaGlueJob;
import io.cucumber.eclipse.java.validation.JavaGlueStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;

public class CucumberJavaQueryParticipant
implements IQueryParticipant {
    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (!(querySpecification instanceof ElementQuerySpecification)) {
            return;
        }
        ElementQuerySpecification elementQuery = (ElementQuerySpecification)querySpecification;
        IJavaElement element = elementQuery.getElement();
        if (!(element instanceof IMethod)) {
            return;
        }
        IMethod method = (IMethod)element;
        try {
            if (!JDTUtil.hasCucumberAnnotation(method)) {
                return;
            }
        }
        catch (JavaModelException e) {
            ILog.get().warn("Could not read annotations for method: " + method.getElementName(), (Throwable)e);
        }
        JavaGlueStore glueStore = Activator.getJavaGlueStore();
        if (glueStore == null) {
            return;
        }
        IJavaSearchScope scope = querySpecification.getScope();
        Set<IJavaProject> relevantProjects = this.collectRelevantProjects(scope);
        if (relevantProjects.isEmpty()) {
            return;
        }
        monitor.beginTask("Searching Cucumber feature files", relevantProjects.size());
        try {
            for (IJavaProject javaProject : relevantProjects) {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Searching in project: " + javaProject.getElementName());
                Set<IFile> featureFiles = this.collectFeatureFiles(javaProject.getProject());
                if (featureFiles.isEmpty()) {
                    monitor.worked(1);
                    continue;
                }
                HashSet<GherkinEditorDocument> documents = new HashSet<GherkinEditorDocument>();
                for (IFile featureFile : featureFiles) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    GherkinEditorDocument editorDoc = GherkinEditorDocumentManager.get((IResource)featureFile, (boolean)false);
                    if (editorDoc == null) continue;
                    documents.add(editorDoc);
                }
                if (documents.isEmpty()) {
                    monitor.worked(1);
                    continue;
                }
                Collection<GherkinEditorDocument> unmatchedDocuments = this.searchInGlueStore(requestor, glueStore, javaProject, method, documents, monitor);
                if (!unmatchedDocuments.isEmpty()) {
                    this.searchInFeatureFiles(requestor, javaProject, method, unmatchedDocuments, monitor);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private Collection<GherkinEditorDocument> searchInGlueStore(ISearchRequestor requestor, JavaGlueStore glueStore, IJavaProject javaProject, IMethod method, Collection<GherkinEditorDocument> documents, IProgressMonitor monitor) {
        HashSet<GherkinEditorDocument> unmatchedDocuments = new HashSet<GherkinEditorDocument>();
        try {
            for (GherkinEditorDocument editorDoc : documents) {
                if (!monitor.isCanceled()) {
                    Collection<MatchedStep<?>> matchedSteps = glueStore.getMatchedSteps(editorDoc.getDocument());
                    if (matchedSteps == null || matchedSteps.isEmpty()) {
                        unmatchedDocuments.add(editorDoc);
                        continue;
                    }
                    this.checkMatchedSteps(requestor, javaProject, method, editorDoc, matchedSteps, monitor);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ILog.get().error("Error searching in glue store for project: " + javaProject.getElementName(), (Throwable)e);
        }
        return unmatchedDocuments;
    }

    private void searchInFeatureFiles(ISearchRequestor requestor, IJavaProject javaProject, IMethod method, Collection<GherkinEditorDocument> documents, IProgressMonitor monitor) {
        try {
            CucumberJavaPreferences preferences = CucumberJavaPreferences.of((IResource)javaProject.getProject());
            Map<GherkinEditorDocument, GlueSteps> glueStepsByDocument = JavaGlueJob.validateGlue(documents, javaProject, preferences, Collections.emptySet(), monitor);
            for (Map.Entry<GherkinEditorDocument, GlueSteps> entry : glueStepsByDocument.entrySet()) {
                if (!monitor.isCanceled()) {
                    GherkinEditorDocument editorDoc = entry.getKey();
                    GlueSteps glueSteps = entry.getValue();
                    Collection<MatchedStep<?>> matchedSteps = glueSteps.matchedSteps();
                    if (matchedSteps == null || matchedSteps.isEmpty()) continue;
                    this.checkMatchedSteps(requestor, javaProject, method, editorDoc, matchedSteps, monitor);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ILog.get().error("Error searching in feature files for project: " + javaProject.getElementName(), (Throwable)e);
        }
    }

    private void checkMatchedSteps(ISearchRequestor requestor, IJavaProject javaProject, IMethod method, GherkinEditorDocument editorDoc, Collection<MatchedStep<?>> matchedSteps, IProgressMonitor monitor) {
        block2: for (MatchedStep<?> matchedStep : matchedSteps) {
            if (monitor.isCanceled()) break;
            CucumberCodeLocation codeLocation = matchedStep.getCodeLocation();
            if (codeLocation == null) continue;
            try {
                IMethod[] resolvedMethods = JDTUtil.resolveMethod(javaProject, codeLocation, monitor);
                if (resolvedMethods == null) continue;
                IMethod[] iMethodArray = resolvedMethods;
                int n = resolvedMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod resolvedMethod = iMethodArray[n2];
                    if (method.equals(resolvedMethod)) {
                        int lineNumber = matchedStep.getLocation().getLine();
                        CucumberStepMatch match = new CucumberStepMatch(editorDoc.getResource(), lineNumber, matchedStep);
                        requestor.reportMatch((Match)match);
                        continue block2;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Set<IJavaProject> collectRelevantProjects(IJavaSearchScope scope) {
        IPath[] enclosingPaths;
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        IPath[] iPathArray = enclosingPaths = scope.enclosingProjectsAndJars();
        int n = enclosingPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IPath path = iPathArray[n2];
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 4 && (project = (IProject)resource).isOpen()) {
                try {
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        projects.add(javaProject);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return projects;
    }

    private Set<IFile> collectFeatureFiles(IProject project) {
        try {
            return ResourceHelper.getFeatureFilesInProject((IProject)project);
        }
        catch (CoreException e) {
            ILog.get().error("Error collecting feature files from project: " + project.getName(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public int estimateTicks(QuerySpecification specification) {
        return 200;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }
}

