/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.search;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;

public class CucumberStepMatch
extends Match {
    private final int lineNumber;
    private final MatchedStep<?> matchedStep;

    public CucumberStepMatch(IResource featureFile, int lineNumber, MatchedStep<?> matchedStep) {
        super((Object)featureFile, CucumberStepMatch.calculateOffset(featureFile, lineNumber), CucumberStepMatch.calculateLength(featureFile, lineNumber));
        this.lineNumber = lineNumber;
        this.matchedStep = matchedStep;
    }

    private static int calculateOffset(IResource resource, int lineNumber) {
        if (!(resource instanceof IFile)) {
            return 0;
        }
        try {
            GherkinEditorDocument editorDoc = GherkinEditorDocumentManager.get((IResource)resource, (boolean)false);
            if (editorDoc != null) {
                IDocument document = editorDoc.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber - 1);
                return lineInfo.getOffset();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static int calculateLength(IResource resource, int lineNumber) {
        if (!(resource instanceof IFile)) {
            return 0;
        }
        try {
            GherkinEditorDocument editorDoc = GherkinEditorDocumentManager.get((IResource)resource, (boolean)false);
            if (editorDoc != null) {
                IDocument document = editorDoc.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber - 1);
                return lineInfo.getLength();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public MatchedStep<?> getMatchedStep() {
        return this.matchedStep;
    }
}

