/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.steps;

import io.cucumber.eclipse.editor.EditorLogging;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CompilationUnitStepDefinitionsPreferencesFilter
implements Predicate<ICompilationUnit> {
    private String[] filters;

    public CompilationUnitStepDefinitionsPreferencesFilter(String[] filters) {
        this.filters = filters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean test(ICompilationUnit element) {
        try {
            IType[] types;
            IPackageDeclaration packageDeclaration = element.getPackageDeclarations()[0];
            String packageName = packageDeclaration.getElementName();
            if (packageName == null) {
                packageName = "";
            }
            ArrayList<CallSite> typesNames = new ArrayList<CallSite>();
            Object[] objectArray = types = element.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = objectArray[n2];
                typesNames.add((CallSite)((Object)(packageName + "." + type.getElementName())));
                ++n2;
            }
            objectArray = this.filters;
            n = this.filters.length;
            n2 = 0;
            while (n2 < n) {
                IType filter = objectArray[n2];
                if (typesNames.contains(filter)) return true;
                if (Pattern.matches((String)filter, packageName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (JavaModelException e) {
            EditorLogging.error((String)"Failed to check compilation unit for step definitions filter", (Throwable)e);
            return false;
        }
    }
}

