/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.steps;

import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.hyperlinks.IStepDefinitionOpener;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.plugins.CucumberCodeLocation;
import io.cucumber.eclipse.java.plugins.MatchedPickleStep;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.validation.JavaGlueStore;
import io.cucumber.messages.types.Step;
import io.cucumber.plugin.event.PickleStepTestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IStepDefinitionOpener.class})
public class JavaStepDefinitionOpener
implements IStepDefinitionOpener {
    private JavaGlueStore glueStore;

    @Activate
    public JavaStepDefinitionOpener(@Reference JavaGlueStore glueValidatorService) {
        this.glueStore = glueValidatorService;
    }

    public static void showMethod(IMethod[] methods, Shell shell) {
        if (methods == null || methods.length == 0) {
            return;
        }
        try {
            if (methods.length == 1) {
                JavaStepDefinitionOpener.open(methods[0]);
            } else {
                EditorLogging.error((String)("More than one method matches: " + Arrays.toString(methods)));
            }
        }
        catch (JavaModelException | PartInitException e) {
            EditorLogging.error((String)"Open target method failed", (Throwable)e);
        }
    }

    private static void open(IMethod method) throws PartInitException, JavaModelException {
        ICompilationUnit cu = method.getCompilationUnit();
        IEditorPart javaEditor = JavaUI.openInEditor((IJavaElement)cu);
        JavaUI.revealInEditor((IEditorPart)javaEditor, (IJavaElement)method);
    }

    public boolean openInEditor(ITextViewer textViewer, IResource resource, final Step step) throws CoreException {
        final IJavaProject project = JDTUtil.getJavaProject(resource);
        if (project == null) {
            return false;
        }
        final AtomicReference resolvedMethods = new AtomicReference();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final Display display = textViewer.getTextWidget().getDisplay();
        final IDocument document = textViewer.getDocument();
        BusyIndicator.showWhile((Display)display, () -> {
            final AtomicBoolean done = new AtomicBoolean();
            final AtomicReference<Job> jobRef = new AtomicReference<Job>();
            Listener escapeListener = new Listener(){

                public void handleEvent(Event event) {
                    Job job;
                    if (event.type == 1 && event.keyCode == 27 && (job = (Job)jobRef.get()) != null) {
                        job.cancel();
                        cancelled.set(true);
                        done.set(true);
                        display.wake();
                    }
                }
            };
            display.addFilter(1, escapeListener);
            Job job = Job.create((String)("Search for step '" + step.getText() + "' (press ESC to cancel)"), (ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        DocumentValidator.joinValidation((IProject)project.getProject());
                    }
                    catch (InterruptedException | OperationCanceledException e) {
                        cancelled.set(true);
                        display.wake();
                        return;
                    }
                    try {
                        Collection<MatchedStep<?>> steps = JavaStepDefinitionOpener.this.glueStore.getMatchedSteps(document);
                        StringBuilder sb = new StringBuilder();
                        sb.append("step '");
                        sb.append(step.getText());
                        sb.append("' line: ");
                        sb.append(step.getLocation().getLine());
                        sb.append("\r\nmatched steps are:\r\n");
                        for (MatchedStep<?> matched2 : steps) {
                            if (!(matched2 instanceof MatchedPickleStep)) continue;
                            MatchedPickleStep pickleStep = (MatchedPickleStep)matched2;
                            sb.append("pickleStep.getTestStep().getPattern='" + ((PickleStepTestStep)pickleStep.getTestStep()).getPattern() + " -> ' [" + String.valueOf(pickleStep.getCodeLocation()) + "]");
                            sb.append(" line: " + matched2.getLocation().getLine());
                            sb.append("  getTestStep().getStep().getText='" + ((PickleStepTestStep)pickleStep.getTestStep()).getStep().getText());
                            sb.append("'\r\n");
                        }
                        sb.append(" found -> ");
                        CucumberCodeLocation location = steps.stream().filter(matched -> step.getLocation().getLine() == (long)matched.getLocation().getLine()).filter(MatchedPickleStep.class::isInstance).map(MatchedPickleStep.class::cast).map(matched -> matched.getCodeLocation()).findFirst().orElse(null);
                        if (Tracing.DEBUG_STEPS_ENABLED) {
                            sb.append(location != null ? location.toString() : "null");
                            Tracing.get().trace("/debug/steps", sb.toString());
                        }
                        if (location != null) {
                            resolvedMethods.set(JDTUtil.resolveMethod(project, location, monitor));
                        }
                    }
                    catch (Throwable throwable) {
                        cancelled.set(cancelled.get() || monitor.isCanceled());
                        done.set(true);
                        display.wake();
                        throw throwable;
                    }
                    cancelled.set(cancelled.get() || monitor.isCanceled());
                    done.set(true);
                    display.wake();
                }
            });
            jobRef.set(job);
            job.schedule();
            try {
                block7: {
                    block6: {
                        if (!true) break block6;
                        if (done.get()) return;
                        if (display.isDisposed()) break block7;
                    }
                    do {
                        if (!display.readAndDispatch()) {
                            display.sleep();
                        }
                        if (done.get()) return;
                    } while (!display.isDisposed());
                }
                return;
            }
            finally {
                display.removeFilter(1, escapeListener);
            }
        });
        if (cancelled.get()) {
            return true;
        }
        IMethod[] method = (IMethod[])resolvedMethods.get();
        if (method != null) {
            JavaStepDefinitionOpener.showMethod(method, textViewer.getTextWidget().getShell());
        }
        return method != null && method.length > 0;
    }

    public boolean canOpen(IResource resource) throws CoreException {
        return JDTUtil.getJavaProject(resource) != null;
    }
}

