/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.steps;

import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.steps.IStepDefinitionsProvider;
import io.cucumber.eclipse.editor.steps.ParameterType;
import io.cucumber.eclipse.editor.steps.StepParameter;
import io.cucumber.eclipse.java.CucumberAnnotation;
import io.cucumber.eclipse.java.JDTUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public abstract class JavaStepDefinitionsProvider
implements IStepDefinitionsProvider {
    public static final Pattern ioCucumberAnnotationMatcher = Pattern.compile("io\\.cucumber\\.java\\.([a-z_]+)\\.(.*)$");

    protected static List<CucumberAnnotation> getAllAnnotationsInPackage(IJavaProject javaProject, String packageFrag, final String lang, IProgressMonitor monitor) throws CoreException, JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((String)packageFrag, (int)2, (int)0, (int)10);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject.getPackageFragments());
        final ArrayList<CucumberAnnotation> annotations = new ArrayList<CucumberAnnotation>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                try {
                    if (match.getAccuracy() == 0) {
                        IPackageFragment frag = (IPackageFragment)match.getElement();
                        IOrdinaryClassFile[] iOrdinaryClassFileArray = frag.getOrdinaryClassFiles();
                        int n = iOrdinaryClassFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IOrdinaryClassFile cls = iOrdinaryClassFileArray[n2];
                            IType t = cls.findPrimaryType();
                            if (t.isAnnotation()) {
                                annotations.add(new CucumberAnnotation(t.getElementName(), lang));
                            }
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        };
        SearchEngine engine = new SearchEngine();
        JavaStepDefinitionsProvider.jdtSearch(engine, pattern, scope, requestor, monitor);
        return annotations;
    }

    protected static void jdtSearch(SearchEngine engine, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (Throwable t) {
            EditorLogging.error((String)"JDT search failed - this may be a bug in the JDT plugin", (Throwable)t);
        }
    }

    protected static int getLineNumber(ICompilationUnit compUnit, ISourceReference annotation) throws JavaModelException {
        Document document = new Document(compUnit.getBuffer().getContents());
        try {
            return document.getLineOfOffset(annotation.getSourceRange().getOffset()) + 1;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    protected static String getAnnotationText(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair mvp = iMemberValuePairArray[n2];
            if (mvp.getValueKind() == 9) {
                return (String)mvp.getValue();
            }
            ++n2;
        }
        return "";
    }

    public boolean support(IResource resource) throws CoreException {
        if (resource instanceof IProject) {
            return JDTUtil.getJavaProject(resource) != null;
        }
        return false;
    }

    protected static StepParameter[] getParameter(IMethod method) throws JavaModelException {
        return JavaStepDefinitionsProvider.getParameterInternal(method, Runtime.getRuntime().availableProcessors());
    }

    private static StepParameter[] getParameterInternal(IMethod method, int retry) throws JavaModelException {
        ILocalVariable[] parameters = method.getParameters();
        StepParameter[] stepParameters = new StepParameter[parameters.length];
        int i = 0;
        while (i < stepParameters.length) {
            String[][] resolved;
            ILocalVariable parameterVariable = parameters[i];
            String name = parameterVariable.getTypeSignature();
            String simpleName = Signature.getSignatureSimpleName((String)name);
            String[] values = null;
            if (simpleName != null && (resolved = JDTUtil.resolveTypeWithRetry(method.getDeclaringType().getDeclaringType(), simpleName)) != null) {
                String qualifiedName = Signature.toQualifiedName((String[])resolved[0]);
                IType type = method.getJavaProject().findType(qualifiedName);
                if (type.isEnum()) {
                    IField[] fields = type.getFields();
                    ArrayList<String> valuesList = new ArrayList<String>();
                    IField[] iFieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        if (field.isEnumConstant()) {
                            valuesList.add(field.getElementName());
                        }
                        ++n2;
                    }
                    values = (String[])valuesList.toArray(String[]::new);
                }
            }
            stepParameters[i] = new StepParameter(parameterVariable.getElementName(), ParameterType.UNKNWON, values);
            ++i;
        }
        return stepParameters;
    }
}

