/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.validation;

import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import io.cucumber.eclipse.java.JDTUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.debug.DebugTrace;

class GlueCodeChangeListener
implements IElementChangedListener {
    private final Map<String, IProject> pendingChanges = new HashMap<String, IProject>();

    GlueCodeChangeListener() {
    }

    public void elementChanged(ElementChangedEvent event) {
        int eventType = event.getType();
        if (eventType == 4) {
            DebugTrace trace;
            if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                trace = Tracing.get();
                trace.trace("/debug/validation/glue", "POST_RECONCILE: Tracking structural changes");
            }
            this.trackStructuralChanges(event.getDelta());
            if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                trace = Tracing.get();
                trace.trace("/debug/validation/glue", "Currently tracking " + this.pendingChanges.size() + " files with changes");
            }
        } else if (eventType == 1) {
            if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                DebugTrace trace = Tracing.get();
                trace.trace("/debug/validation/glue", "POST_CHANGE: Processing saved changes");
            }
            Set<IProject> affectedProjects = this.processSavedChanges(event.getDelta());
            if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                DebugTrace trace = Tracing.get();
                trace.trace("/debug/validation/glue", "Found " + affectedProjects.size() + " affected projects");
                for (IProject project : affectedProjects) {
                    trace.trace("/debug/validation/glue", "  - Project: " + project.getName());
                }
            }
            for (IProject project : affectedProjects) {
                DocumentValidator.revalidateDocuments((IProject)project);
            }
        } else if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
            DebugTrace trace = Tracing.get();
            trace.trace("/debug/validation/glue", "Ignoring event type: " + this.getEventTypeName(eventType));
        }
    }

    private void trackStructuralChanges(IJavaElementDelta delta) {
        DebugTrace trace;
        IJavaElement element = delta.getElement();
        int kind = delta.getKind();
        if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
            trace = Tracing.get();
            trace.trace("/debug/validation/glue", "  Reconcile delta: " + element.getElementName() + " (type=" + this.getElementTypeName(element.getElementType()) + ", kind=" + this.getKindName(kind) + ", flags=" + this.getFlagsString(delta.getFlags()) + ")");
        }
        switch (element.getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    this.trackStructuralChanges(childDelta);
                    ++n2;
                }
                break;
            }
            case 5: {
                if (this.isStructuralChange(delta)) {
                    ICompilationUnit cu = (ICompilationUnit)element;
                    try {
                        if (JDTUtil.hasCucumberGlueAnnotation(cu, null)) {
                            IProject project = cu.getJavaProject().getProject();
                            if (project == null || !project.isAccessible()) break;
                            String key = cu.getHandleIdentifier();
                            this.pendingChanges.put(key, project);
                            if (!Tracing.DEBUG_VALIDATION_GLUE_ENABLED) break;
                            DebugTrace trace2 = Tracing.get();
                            trace2.trace("/debug/validation/glue", "    -> Tracked structural change in: " + cu.getElementName());
                            break;
                        }
                        if (!Tracing.DEBUG_VALIDATION_GLUE_ENABLED) break;
                        DebugTrace trace3 = Tracing.get();
                        trace3.trace("/debug/validation/glue", "    -> Structural change but no Cucumber annotations");
                    }
                    catch (JavaModelException e) {
                        if (!Tracing.DEBUG_VALIDATION_GLUE_ENABLED) break;
                        DebugTrace trace4 = Tracing.get();
                        trace4.trace("/debug/validation/glue", "    -> Error checking annotations", (Throwable)e);
                    }
                    break;
                }
                if (!Tracing.DEBUG_VALIDATION_GLUE_ENABLED) break;
                trace = Tracing.get();
                trace.trace("/debug/validation/glue", "    -> Not a structural change (ignored)");
                break;
            }
        }
    }

    private Set<IProject> processSavedChanges(IJavaElementDelta delta) {
        HashSet<IProject> affectedProjects = new HashSet<IProject>();
        this.collectSavedFiles(delta, affectedProjects);
        return affectedProjects;
    }

    private void collectSavedFiles(IJavaElementDelta delta, Set<IProject> affectedProjects) {
        IJavaElement element = delta.getElement();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
            DebugTrace trace = Tracing.get();
            trace.trace("/debug/validation/glue", "  Save delta: " + element.getElementName() + " (type=" + this.getElementTypeName(element.getElementType()) + ", kind=" + this.getKindName(kind) + ", flags=" + this.getFlagsString(flags) + ")");
        }
        switch (element.getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    this.collectSavedFiles(childDelta, affectedProjects);
                    ++n2;
                }
                break;
            }
            case 5: {
                IProject project;
                if ((flags & 0x40000) == 0) break;
                ICompilationUnit cu = (ICompilationUnit)element;
                String key = cu.getHandleIdentifier();
                if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                    DebugTrace trace = Tracing.get();
                    trace.trace("/debug/validation/glue", "    -> File saved: " + cu.getElementName());
                }
                if ((project = this.pendingChanges.remove(key)) != null) {
                    if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                        DebugTrace trace = Tracing.get();
                        trace.trace("/debug/validation/glue", "    -> Has tracked changes, adding project: " + project.getName());
                    }
                    affectedProjects.add(project);
                    break;
                }
                if (!Tracing.DEBUG_VALIDATION_GLUE_ENABLED) break;
                DebugTrace trace = Tracing.get();
                trace.trace("/debug/validation/glue", "    -> No tracked changes for this file");
                break;
            }
        }
    }

    private boolean isStructuralChange(IJavaElementDelta delta) {
        DebugTrace trace;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
            trace = Tracing.get();
            trace.trace("/debug/validation/glue", "      Checking if structural change...");
        }
        if (kind == 4) {
            if ((flags & 8) != 0) {
                if ((flags & 0x4000) != 0) {
                    boolean hasStructuralChildren = this.hasStructuralChildChanges(delta);
                    if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                        DebugTrace trace2 = Tracing.get();
                        if (hasStructuralChildren) {
                            trace2.trace("/debug/validation/glue", "      -> Structural: CHILDREN with structural modifications");
                        } else {
                            trace2.trace("/debug/validation/glue", "      -> Not structural: CHILDREN but only fine-grained");
                        }
                    }
                    return hasStructuralChildren;
                }
                if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                    trace = Tracing.get();
                    trace.trace("/debug/validation/glue", "      -> Structural: CHILDREN changed");
                }
                return true;
            }
            if ((flags & 2) != 0) {
                if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                    trace = Tracing.get();
                    trace.trace("/debug/validation/glue", "      -> Structural: MODIFIERS changed");
                }
                return true;
            }
            if ((flags & 0x800) != 0) {
                if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                    trace = Tracing.get();
                    trace.trace("/debug/validation/glue", "      -> Structural: SUPER_TYPES changed");
                }
                return true;
            }
            if ((flags & 1) != 0 && (flags & 0x4000) == 0) {
                if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
                    trace = Tracing.get();
                    trace.trace("/debug/validation/glue", "      -> Structural: CONTENT changed (not fine-grained)");
                }
                return true;
            }
        }
        if (Tracing.DEBUG_VALIDATION_GLUE_ENABLED) {
            trace = Tracing.get();
            trace.trace("/debug/validation/glue", "      -> Not structural");
        }
        return false;
    }

    private boolean hasStructuralChildChanges(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            int childKind = child.getKind();
            int childFlags = child.getFlags();
            if (childKind == 1 || childKind == 2) {
                return true;
            }
            if ((childFlags & 0x400000) != 0) {
                return true;
            }
            if ((childFlags & 2) != 0) {
                return true;
            }
            if (this.hasStructuralChildChanges(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getEventTypeName(int eventType) {
        switch (eventType) {
            case 1: {
                return "POST_CHANGE";
            }
            case 4: {
                return "POST_RECONCILE";
            }
        }
        return "UNKNOWN(" + eventType + ")";
    }

    private String getElementTypeName(int elementType) {
        switch (elementType) {
            case 1: {
                return "JAVA_MODEL";
            }
            case 2: {
                return "JAVA_PROJECT";
            }
            case 3: {
                return "PACKAGE_FRAGMENT_ROOT";
            }
            case 4: {
                return "PACKAGE_FRAGMENT";
            }
            case 5: {
                return "COMPILATION_UNIT";
            }
            case 7: {
                return "TYPE";
            }
            case 9: {
                return "METHOD";
            }
            case 8: {
                return "FIELD";
            }
        }
        return "UNKNOWN(" + elementType + ")";
    }

    private String getKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ADDED";
            }
            case 2: {
                return "REMOVED";
            }
            case 4: {
                return "CHANGED";
            }
        }
        return "UNKNOWN(" + kind + ")";
    }

    private String getFlagsString(int flags) {
        if (flags == 0) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("CONTENT ");
        }
        if ((flags & 2) != 0) {
            sb.append("MODIFIERS ");
        }
        if ((flags & 8) != 0) {
            sb.append("CHILDREN ");
        }
        if ((flags & 0x10) != 0) {
            sb.append("MOVED_FROM ");
        }
        if ((flags & 0x20) != 0) {
            sb.append("MOVED_TO ");
        }
        if ((flags & 0x40) != 0) {
            sb.append("ADDED_TO_CLASSPATH ");
        }
        if ((flags & 0x80) != 0) {
            sb.append("REMOVED_FROM_CLASSPATH ");
        }
        if ((flags & 0x100) != 0) {
            sb.append("REORDER ");
        }
        if ((flags & 0x200) != 0) {
            sb.append("OPENED ");
        }
        if ((flags & 0x400) != 0) {
            sb.append("CLOSED ");
        }
        if ((flags & 0x800) != 0) {
            sb.append("SUPER_TYPES ");
        }
        if ((flags & 0x1000) != 0) {
            sb.append("SOURCEATTACHED ");
        }
        if ((flags & 0x2000) != 0) {
            sb.append("SOURCEDETACHED ");
        }
        if ((flags & 0x4000) != 0) {
            sb.append("FINE_GRAINED ");
        }
        if ((flags & 0x8000) != 0) {
            sb.append("ARCHIVE_CONTENT_CHANGED ");
        }
        if ((flags & 0x10000) != 0) {
            sb.append("PRIMARY_WORKING_COPY ");
        }
        if ((flags & 0x20000) != 0) {
            sb.append("CLASSPATH_CHANGED ");
        }
        if ((flags & 0x40000) != 0) {
            sb.append("PRIMARY_RESOURCE ");
        }
        if ((flags & 0x80000) != 0) {
            sb.append("AST_AFFECTED ");
        }
        if ((flags & 0x100000) != 0) {
            sb.append("CATEGORIES ");
        }
        if ((flags & 0x400000) != 0) {
            sb.append("ANNOTATIONS ");
        }
        if ((flags & 0x200000) != 0) {
            sb.append("RESOLVED_CLASSPATH_CHANGED ");
        }
        return sb.toString().trim();
    }
}

