/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.validation;

import io.cucumber.core.eventbus.IncrementingUuidGenerator;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.exception.CompositeCucumberException;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.eclipse.java.plugins.CucumberMatchedStepsPlugin;
import io.cucumber.eclipse.java.plugins.CucumberMissingStepsPlugin;
import io.cucumber.eclipse.java.plugins.CucumberStepDefinition;
import io.cucumber.eclipse.java.plugins.CucumberStepParserPlugin;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.runtime.CucumberRuntime;
import io.cucumber.eclipse.java.validation.GlueSteps;
import io.cucumber.plugin.Plugin;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.debug.DebugTrace;

public final class JavaGlueJob {
    private JavaGlueJob() {
    }

    public static Map<GherkinEditorDocument, GlueSteps> validateGlue(Collection<GherkinEditorDocument> editorDocuments, IJavaProject javaProject, CucumberJavaPreferences projectPreferences, Set<String> validationPlugins, IProgressMonitor monitor) {
        HashMap<GherkinEditorDocument, GlueSteps> resultsByDocument = new HashMap<GherkinEditorDocument, GlueSteps>();
        if (editorDocuments.isEmpty()) {
            return resultsByDocument;
        }
        long start = System.currentTimeMillis();
        DebugTrace debug = Tracing.get();
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (CucumberRuntime rt = CucumberRuntime.create(javaProject);){
                rt.setGenerator((UuidGenerator)new IncrementingUuidGenerator());
                RuntimeOptionsBuilder runtimeOptions = rt.getRuntimeOptions();
                runtimeOptions.setDryRun();
                HashMap<URI, GherkinEditorDocument> documentsByUri = new HashMap<URI, GherkinEditorDocument>();
                for (GherkinEditorDocument editorDocument : editorDocuments) {
                    if (monitor.isCanceled()) break;
                    IResource resource = editorDocument.getResource();
                    monitor.subTask(resource.getName());
                    debug.traceEntry("/perf/steps", (Object)resource);
                    try {
                        Optional<Feature> feature = rt.addFeature(editorDocument);
                        if (!feature.isPresent()) continue;
                        URI featureUri = feature.get().getUri();
                        documentsByUri.put(featureUri, editorDocument);
                    }
                    catch (FeatureParserException feature) {
                        // empty catch block
                    }
                }
                if (documentsByUri.isEmpty()) {
                    return resultsByDocument;
                }
                JavaGlueJob.addGlueOptions(runtimeOptions, projectPreferences);
                CucumberMissingStepsPlugin missingStepsPlugin = new CucumberMissingStepsPlugin();
                CucumberStepParserPlugin stepParserPlugin = new CucumberStepParserPlugin();
                CucumberMatchedStepsPlugin matchedStepsPlugin = new CucumberMatchedStepsPlugin();
                rt.addPlugin(stepParserPlugin);
                rt.addPlugin(matchedStepsPlugin);
                rt.addPlugin(missingStepsPlugin);
                HashMap<String, Plugin> validationPluginInstances = new HashMap<String, Plugin>();
                for (String pluginClass : validationPlugins) {
                    Plugin classpathPlugin = rt.addPluginFromClasspath(pluginClass);
                    if (classpathPlugin == null) continue;
                    validationPluginInstances.put(pluginClass, classpathPlugin);
                }
                try {
                    rt.run(monitor);
                    Collection<CucumberStepDefinition> steps = stepParserPlugin.getStepList();
                    for (Map.Entry entry : documentsByUri.entrySet()) {
                        if (monitor.isCanceled()) break;
                        URI uri = (URI)entry.getKey();
                        GherkinEditorDocument document = (GherkinEditorDocument)entry.getValue();
                        IResource resource = document.getResource();
                        Collection<MatchedStep<?>> matchedSteps = matchedStepsPlugin.getMatchedStepsForFeature(uri);
                        Map<Integer, Collection<String>> snippets = missingStepsPlugin.getSnippetsForFeature(uri);
                        HashMap<Integer, String> validationErrors = new HashMap<Integer, String>();
                        for (Plugin plugin : validationPluginInstances.values()) {
                            JavaGlueJob.addErrors(plugin, validationErrors);
                        }
                        MarkerFactory.validationErrorOnStepDefinition((IResource)resource, validationErrors, (boolean)false);
                        MarkerFactory.missingSteps((IResource)resource, snippets, (String)"io.cucumber.eclipse.java", (boolean)false);
                        debug.traceExit("/perf/steps", (Object)(matchedSteps.size() + " step(s) /  " + steps.size() + " step(s)  matched, " + snippets.size() + " snippet(s) where suggested"));
                        resultsByDocument.put(document, new GlueSteps(List.copyOf(steps), List.copyOf(matchedSteps)));
                    }
                    debug.trace("/perf/steps", "Total validation time for " + documentsByUri.size() + " document(s): " + (System.currentTimeMillis() - start) + "ms");
                }
                catch (Throwable e) {
                    JavaGlueJob.handleGlueValidationError(e, documentsByUri.values());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            EditorLogging.error((String)"Failed to create Cucumber runtime", (Throwable)e);
        }
        return resultsByDocument;
    }

    private static void handleGlueValidationError(Throwable e, Collection<GherkinEditorDocument> documents) {
        if (e instanceof CucumberExpressionException) {
            CucumberExpressionException ee = (CucumberExpressionException)e;
            JavaGlueJob.handleExpressionException(documents, ee);
        } else if (e instanceof CucumberException) {
            CucumberException cucumber = (CucumberException)e;
            JavaGlueJob.handleCucumberException(documents, cucumber);
        } else {
            JavaGlueJob.handleGenericError(documents, e);
        }
    }

    private static void handleExpressionException(Collection<GherkinEditorDocument> documents, CucumberExpressionException exception) {
        String message = exception.getMessage();
        for (GherkinEditorDocument document : documents) {
            MarkerFactory.glueValidationError((IResource)document.getResource(), (String)message, (String)"glue_validation_error");
        }
    }

    private static void handleCucumberException(Collection<GherkinEditorDocument> documents, CucumberException cucumber) {
        if (cucumber instanceof CompositeCucumberException) {
            Throwable[] suppressed;
            CompositeCucumberException composite = (CompositeCucumberException)cucumber;
            Throwable[] throwableArray = suppressed = composite.getSuppressed();
            int n = suppressed.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable throwable = throwableArray[n2];
                JavaGlueJob.handleGlueValidationError(throwable, documents);
                ++n2;
            }
            return;
        }
        String message = cucumber.getMessage();
        for (GherkinEditorDocument document : documents) {
            MarkerFactory.glueValidationError((IResource)document.getResource(), (String)message, (String)"glue_validation_error");
        }
    }

    private static void handleGenericError(Collection<GherkinEditorDocument> documents, Throwable e) {
        EditorLogging.error((String)"Validate Glue-Code failed", (Throwable)e);
        for (GherkinEditorDocument document : documents) {
            MarkerFactory.glueValidationError((IResource)document.getResource(), (String)"Failed to validate step definitions. Check that your project is properly configured and dependencies are available. See error log for details.", (String)"glue_validation_error");
        }
    }

    static Set<String> extractValidationPlugins(GherkinEditorDocument editorDocument, CucumberJavaPreferences projectPreferences) {
        String[] lines;
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        IDocument doc = editorDocument.getDocument();
        String documentContent = doc.get();
        String[] stringArray = lines = documentContent.split("\\r?\\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] split;
            String line = stringArray[n2];
            String trimmed = line.trim();
            if (trimmed.startsWith("#") && (split = trimmed.split("validation-plugin:", 2)).length == 2) {
                plugins.add(split[1].trim());
            }
            ++n2;
        }
        projectPreferences.plugins().forEach(plugins::add);
        return plugins;
    }

    private static void addErrors(Plugin plugin, Map<Integer, String> validationErrors) {
        try {
            Method method = plugin.getClass().getMethod("getValidationErrors", new Class[0]);
            Object invoke = method.invoke((Object)plugin, new Object[0]);
            if (invoke instanceof Map) {
                Map map = (Map)invoke;
                validationErrors.putAll(map);
            }
        }
        catch (Exception e) {
            EditorLogging.error((String)("Failed to get validation errors from plugin: " + plugin.getClass().getName()), (Throwable)e);
        }
    }

    private static void addGlueOptions(RuntimeOptionsBuilder runtimeOptions, CucumberJavaPreferences projectPreferences) {
        projectPreferences.glueFilter().forEach(gluePath -> {
            if ((gluePath = gluePath.trim()).endsWith("*")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            if (gluePath.endsWith("/")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            if (gluePath.endsWith(".")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            try {
                runtimeOptions.addGlue(GluePath.parse((String)gluePath));
            }
            catch (RuntimeException e) {
                EditorLogging.error((String)("Failed to parse glue path: " + gluePath), (Throwable)e);
            }
        });
    }
}

