/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.validation;

import io.cucumber.eclipse.editor.EditorReconciler;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.document.IGherkinDocumentListener;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import io.cucumber.eclipse.editor.validation.IGlueValidator;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.plugins.CucumberStepDefinition;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.properties.CucumberJavaBackendProperties;
import io.cucumber.eclipse.java.validation.GlueCodeChangeListener;
import io.cucumber.eclipse.java.validation.GlueSteps;
import io.cucumber.eclipse.java.validation.JavaGlueJob;
import io.cucumber.eclipse.java.validation.JavaGlueStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IGlueValidator.class, JavaGlueStore.class})
public class JavaGlueValidatorService
implements IGlueValidator,
JavaGlueStore,
IGherkinDocumentListener {
    private final Map<IEclipsePreferences, IEclipsePreferences.IPreferenceChangeListener> preferenceChangeListeners = new HashMap<IEclipsePreferences, IEclipsePreferences.IPreferenceChangeListener>();
    private final Map<IDocument, GlueSteps> glueMap = new ConcurrentHashMap<IDocument, GlueSteps>();
    private GlueCodeChangeListener glueCodeChangeListener;

    public boolean canValidate(IResource resource) throws CoreException {
        if (resource == null) {
            return false;
        }
        IJavaProject javaProject = JDTUtil.getJavaProject(resource);
        return javaProject != null && javaProject.exists();
    }

    public void validate(Collection<GherkinEditorDocument> editorDocuments, IProgressMonitor monitor) throws CoreException {
        HashMap<IJavaProject, List> documentsByProject = new HashMap<IJavaProject, List>();
        for (GherkinEditorDocument gherkinEditorDocument : editorDocuments) {
            if (monitor.isCanceled()) break;
            IResource resource = gherkinEditorDocument.getResource();
            if (resource == null) continue;
            MarkerFactory.clearGlueValidationError((IResource)resource, (String)"glue_validation_error");
            this.listenForChanges(resource);
            IJavaProject javaProject = JDTUtil.getJavaProject(resource);
            if (javaProject == null || !javaProject.exists()) continue;
            documentsByProject.computeIfAbsent(javaProject, k -> new ArrayList()).add(gherkinEditorDocument);
        }
        block1: for (Map.Entry entry : documentsByProject.entrySet()) {
            Set plugins;
            if (monitor.isCanceled()) break;
            IJavaProject javaProject = (IJavaProject)entry.getKey();
            List documents = (List)entry.getValue();
            CucumberJavaPreferences projectPreferences = CucumberJavaPreferences.of((IResource)javaProject.getProject());
            HashMap<Set, List> documentsByPlugins = new HashMap<Set, List>();
            for (GherkinEditorDocument gherkinEditorDocument : documents) {
                plugins = JavaGlueJob.extractValidationPlugins(gherkinEditorDocument, projectPreferences);
                documentsByPlugins.computeIfAbsent(plugins, k -> new ArrayList()).add(gherkinEditorDocument);
            }
            for (Map.Entry entry2 : documentsByPlugins.entrySet()) {
                if (monitor.isCanceled()) continue block1;
                plugins = (Set)entry2.getKey();
                List docsForPlugins = (List)entry2.getValue();
                Map<GherkinEditorDocument, GlueSteps> results = JavaGlueJob.validateGlue(docsForPlugins, javaProject, projectPreferences, plugins, monitor);
                for (Map.Entry<GherkinEditorDocument, GlueSteps> result : results.entrySet()) {
                    GherkinEditorDocument document = result.getKey();
                    GlueSteps glueSteps = result.getValue();
                    if (glueSteps == null) continue;
                    this.glueMap.put(document.getDocument(), glueSteps);
                    EditorReconciler.reconcileFeatureEditor((IDocument)document.getDocument());
                }
            }
        }
    }

    private synchronized void listenForChanges(IResource resource) {
        CucumberJavaBackendProperties properties = CucumberJavaBackendProperties.of(resource);
        IEclipsePreferences projectNode = properties.node();
        if (projectNode != null && !this.preferenceChangeListeners.containsKey(projectNode)) {
            IEclipsePreferences.IPreferenceChangeListener preferenceListener = event -> DocumentValidator.revalidateDocuments((IProject)resource.getProject());
            projectNode.addPreferenceChangeListener(preferenceListener);
            this.preferenceChangeListeners.put(projectNode, preferenceListener);
        }
        if (this.glueCodeChangeListener == null) {
            this.glueCodeChangeListener = new GlueCodeChangeListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.glueCodeChangeListener);
        }
    }

    @Override
    public Collection<CucumberStepDefinition> getAvailableSteps(IDocument document) {
        GlueSteps glueSteps = this.glueMap.get(document);
        if (glueSteps == null) {
            return List.of();
        }
        return glueSteps.availableSteps();
    }

    @Override
    public Collection<MatchedStep<?>> getMatchedSteps(IDocument document) {
        GlueSteps glueSteps = this.glueMap.get(document);
        if (glueSteps == null) {
            return List.of();
        }
        return glueSteps.matchedSteps();
    }

    @Activate
    void register() {
        GherkinEditorDocumentManager.addDocumentListener((IGherkinDocumentListener)this);
    }

    @Deactivate
    synchronized void shutdown() {
        GherkinEditorDocumentManager.removeDocumentListener((IGherkinDocumentListener)this);
        this.preferenceChangeListeners.forEach(IEclipsePreferences::removePreferenceChangeListener);
        if (this.glueCodeChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.glueCodeChangeListener);
        }
    }

    public void documentCreated(IDocument document) {
    }

    public void documentChanged(IDocument document) {
    }

    public void documentDisposed(IDocument document) {
        this.glueMap.remove(document);
    }
}

