/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.application;

import com.kms.katalon.application.ApplicationStarter;
import com.kms.katalon.console.application.ConsoleMain;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleApplicationStarter
implements ApplicationStarter {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStarter.class);
    @Inject
    private ConsoleMain consoleMain;
    private Thread shutdownHookThread;

    private void init() {
        this.shutdownHookThread = new Thread(() -> this.consoleMain.stopConsoleProcess());
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        EventBusSingleton.getInstance().setEventBus(EventBus.builder().installDefaultEventBus());
        int trackingTime = TrackingManager.getInstance().getTrackingTime();
        ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
        Boolean smartWaitEnabled = executionStore != null ? Boolean.valueOf(executionStore.isSmartWaitEnabled()) : null;
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (boolean)false, (String)"console", (Boolean)smartWaitEnabled), trackingTime, trackingTime, TimeUnit.SECONDS);
    }

    public int start(String[] arguments) {
        System.setProperty("eclipse.exitdata", "");
        int exitCode = 0;
        try {
            this.init();
            exitCode = this.consoleMain.launch(arguments);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e, (String)ConsoleMessageConstants.ERR_CONSOLE_MODE);
            exitCode = 2;
        }
        logger.info("KRE exit code: " + exitCode);
        return exitCode;
    }

    public void stop() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }
}

