/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.google.common.collect.Iterables;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ProcessUtil;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.license.models.ConsoleLicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.model.RetryOptions;
import com.kms.katalon.network.core.services.IRetryService;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import dev.failsafe.event.EventListener;
import dev.failsafe.function.CheckedRunnable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ActivationHandler {
    private final String DEFAULT_LICENSE_FOLDER = "license";
    private final String DEFAULT_LICENSE_EXTENSION = "lic";
    public final String MACHINE_ID_BYPASS = "katalon-special-license";
    private static final String RETRIES_EXCEEDED_MSG = "Failed to activate with Katalon Runtime Engine license after %s minutes.";
    private static final String ACTIVATION_ATTEMPT_FAILED_MSG = "Failed to activate with Katalon Runtime Engine license. Retrying in %s minutes ...";
    private static final String RETRY_ACTIVATION_BEGIN_MSG = "Retrying Katalon Runtime Engine license activation (attempt %s)";
    public final String DEFAULT_REASON = ApplicationMessageConstants.LICENSE_INVALID;
    private int validOfflineLicenseNumber;
    private String testOpsErrorMessage = "";
    private String testCloudErrorMessage = "";
    @Inject
    private IDiscoveryController discoveryController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IRetryService retryService;

    private String getLicenseServerUrl() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{ArgumentOptionsHandler.getInstance().getAdminServerUrl(), "https://testops.katalon.io"});
    }

    private Long getOrganizationId() {
        String organizationId = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{ArgumentOptionsHandler.getInstance().getOrganizationId()});
        try {
            return Long.valueOf(organizationId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Set<Session> findValidEngineOfflineLicenseCodes() {
        HashSet<Session> validActivationCodes = new HashSet<Session>();
        try {
            File licenseFolder = new File(ApplicationInfo.userDirLocation(), "license");
            LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_FIND_VAILD_OFFLINE_LICENSE_IN_FOLDER, licenseFolder.getAbsolutePath()));
            if (licenseFolder.exists() && licenseFolder.isDirectory()) {
                Files.walk(Paths.get(licenseFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.getExtension((String)p.toFile().getAbsolutePath()).equals("lic")).forEach(p -> {
                    try {
                        File licenseFile = p.toFile();
                        LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_START_CHECK_LICENSE, licenseFile.getName()));
                        Session session = this.sessionController.activateOffline(licenseFile);
                        boolean canUseKRE = this.featureController.canUse(ProductFeature.CLI);
                        if (session != null && canUseKRE && session.getLicense().isOffline()) {
                            LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_LICENSE_FILE_VAILD, licenseFile.getName()));
                            validActivationCodes.add(session);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        this.validOfflineLicenseNumber = validActivationCodes.size();
        return validActivationCodes;
    }

    private int activateOffline() throws Exception {
        LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_START_ACTIVATE_OFFLINE);
        StringBuilder errorMessage = new StringBuilder();
        boolean isActivated = this.activateOfflineForEngine(errorMessage);
        String error = errorMessage.toString();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            LogUtil.printErrorLine((String)(error + "\n"));
        }
        int validOfflineLicenseSessionNumber = this.validOfflineLicenseNumber;
        if (!isActivated && validOfflineLicenseSessionNumber != 0) {
            LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_FAIL_OFFLINE);
        }
        return isActivated ? 200 : -1;
    }

    public boolean activateOfflineForEngine(StringBuilder errorMessage) throws Exception {
        Set<Session> validActivationSessions;
        block5: {
            int validOfflineLicenseSessionNumber;
            block4: {
                try {
                    validActivationSessions = this.findValidEngineOfflineLicenseCodes();
                    LogUtil.logInfo((String)("The number of valid offline licenses: " + validActivationSessions.size()));
                    validOfflineLicenseSessionNumber = validActivationSessions.size();
                    if (validOfflineLicenseSessionNumber != 0) break block4;
                    return false;
                }
                catch (Exception error) {
                    LogUtil.printAndLogError((Throwable)error, (String)ApplicationMessageConstants.ACTIVATION_OFFLINE_FAIL);
                    return false;
                }
            }
            int runningSession = ProcessUtil.countKatalonRunningSession();
            LogUtil.logInfo((String)("The number of Runtime Engine running sessions: " + runningSession));
            if (validOfflineLicenseSessionNumber >= runningSession) break block5;
            errorMessage.append("License quota exceeded");
            return false;
        }
        Session session = (Session)Iterables.getLast(validActivationSessions);
        return Objects.nonNull(session);
    }

    public int activate() throws Throwable {
        ConsoleLicenseType licenseType;
        String apiKey = ArgumentOptionsHandler.getInstance().getApiKeyValue();
        ApiKey.set((String)apiKey);
        int code = this.activateOffline();
        Object object = licenseType = code == 200 ? ConsoleLicenseType.KRE_LICENSE : null;
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            if (code != 200) {
                throw new InvalidConsoleArgumentException(ExecutionMessageConstants.ACTIVATE_FAIL_NO_OFFLINE_LICENSE_AND_MISSING_API_KEY);
            }
            ConsoleLicenseService.getInstance().setLicenseType(licenseType);
            return code;
        }
        String serverUrl = this.getLicenseServerUrl();
        Long organizationId = this.getOrganizationId();
        this.tryActivationSafely(serverUrl, apiKey, organizationId);
        if (this.sessionController.isActivated()) {
            licenseType = ConsoleLicenseType.KRE_LICENSE;
        }
        ConsoleLicenseService.getInstance().setLicenseType(licenseType);
        return code;
    }

    private void tryActivationSafely(String serverUrl, String apiKey, Long organizationId) throws Throwable {
        try {
            this.tryActivation(serverUrl, apiKey, organizationId);
        }
        catch (Exception exception) {
            LogUtil.logInfo((String)"Failed to activate with API key");
        }
    }

    public void printLicenseInfo() {
        ConsoleLicenseType licenseType = ConsoleLicenseService.getInstance().getLicenseType();
        if (licenseType != null) {
            switch (licenseType) {
                case ALL: {
                    this.logActivate(true, true);
                    break;
                }
                case KRE_LICENSE: {
                    this.logActivate(true, false);
                    break;
                }
                case TESTCLOUD_LICENSE: {
                    this.logActivate(false, true);
                    break;
                }
            }
        } else {
            this.logActivate(false, false);
        }
    }

    private RetryOptions<?> buildLicenseRetryOptions(ArgumentOptionsHandler instance) throws IllegalStateException {
        EventListener failedAttemptListener = event -> LogUtil.logInfo((String)String.format(ACTIVATION_ATTEMPT_FAILED_MSG, instance.getLicenseRetryInterval().toMinutes()));
        EventListener retryExceededListener = event -> LogUtil.logInfo((String)String.format(RETRIES_EXCEEDED_MSG, event.getElapsedTime().toMinutes()));
        EventListener retryListener = event -> LogUtil.logInfo((String)String.format(RETRY_ACTIVATION_BEGIN_MSG, event.getAttemptCount()));
        return new RetryOptions.Builder().enableRetry(instance.isEnableLicenseRetry()).retryMaxDuration(instance.getLicenseRetryMaxDuration()).retryInterval(instance.getLicenseRetryInterval()).retryMaxJitter(instance.getLicenseRetryMaxJitter()).onFailedAttemptListener(failedAttemptListener).onRetriesExceededListener(retryExceededListener).onRetryListener(retryListener).build();
    }

    public void endScheduleCheckLicense() {
        this.sessionController.endScheduleCheckingLicense();
    }

    public void deactivate() throws SessionException {
        this.sessionController.logout();
    }

    private void tryActivation(String serverUrl, String apiKey, Long organizationId) throws Throwable {
        this.discoveryController.discover(serverUrl);
        CheckedRunnable activation = () -> {
            try {
                if (!this.sessionController.isActivated()) {
                    this.sessionController.activateWithApiKey(apiKey, organizationId);
                } else {
                    this.sessionController.authenticateWithApiKey(apiKey, organizationId);
                }
            }
            catch (SessionException e) {
                LogUtil.logError((Throwable)e, (String)"Failed to activate with API key");
                throw e;
            }
        };
        RetryOptions<?> retryOptions = this.buildLicenseRetryOptions(ArgumentOptionsHandler.getInstance());
        this.retryService.invoke(SessionException.class, activation, retryOptions);
    }

    private void logActivate(boolean KRESuccess, boolean TCSuccess) {
        this.logActivateWithKRE(KRESuccess);
        this.logActivateWithTestCloud(TCSuccess);
    }

    private void logActivateWithKRE(boolean success) {
        if (success) {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_SUCCESS, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME));
        } else {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_FAILED, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME, this.testOpsErrorMessage));
        }
    }

    private void logActivateWithTestCloud(boolean success) {
        if (success) {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_SUCCESS, GlobalMessageConstants.TESTCLOUD_NAME));
        } else {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_FAILED, GlobalMessageConstants.TESTCLOUD_NAME, this.testCloudErrorMessage));
        }
    }
}

