/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.strategy;

import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.controller.IExecutionController;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExecutionEventConfiguration;
import com.katalon.execution.dto.request.GlobalVariablesConfiguration;
import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.kre.KRELogPrinter;
import com.katalon.execution.temporary.FeatureFlags;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.console.handlers.PluginHandler;
import com.kms.katalon.console.strategy.AbstractConsoleModeStrategy;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.ConsoleExecutor;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.model.exception.MultipleActivationException;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.util.ExecutorUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Creatable
public class ExecutionModeStrategy
extends AbstractConsoleModeStrategy {
    private volatile boolean isLicenseCheckingRunning = false;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionModeStrategy.class);
    @Inject
    private IExecutionController executionController;
    @Inject
    private IExecutionManager executionManager;

    private int performPreExecutionTasks(ConsoleLauncherEntity consoleLauncherEntity) throws Throwable {
        this.prepareApplicationConfiguration(consoleLauncherEntity);
        int proxyCode = this.checkAndConfigureProxy(consoleLauncherEntity);
        if (proxyCode != 200) {
            return proxyCode;
        }
        return super.performInitializationTasks(consoleLauncherEntity);
    }

    @Override
    protected void prepareApplicationConfiguration(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        ArgumentOptionsHandler.getInstance().prepareApplicationConfiguration(consoleLauncherEntity.getApplicationConfigOptions());
    }

    private Long parseOrganizationId(String organizationId) throws InvalidConsoleArgumentException {
        Long orgIdValue = null;
        try {
            if (organizationId != null) {
                orgIdValue = Long.valueOf(organizationId);
            }
            return orgIdValue;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConsoleArgumentException(String.format(StringConstants.MNG_PRT_ORGANIZATION_ID_IS_INVALID, new Object[0]));
        }
    }

    private void printStatus() {
        int consoleWidth = 80;
        LogUtil.printOutputLine((String)LauncherManager.getInstance().getStatus(consoleWidth));
    }

    @Override
    public int execute(ConsoleLauncherEntity consoleLauncherEntity) throws Throwable {
        int preTaskResult = this.performPreExecutionTasks(consoleLauncherEntity);
        if (preTaskResult != 200) {
            return preTaskResult;
        }
        ProjectEntity project = this.performProjectInitialization(consoleLauncherEntity);
        consoleLauncherEntity.acceptConsoleOptionList(new OverridingParametersConsoleOptionContributor(project).getConsoleOptionList());
        if (ConsoleLicenseService.getInstance().getLicenseType() != null) {
            PluginHandler.loadPluginsToConsole(consoleLauncherEntity, this.context);
        }
        PluginHandler.checkPluginLicense(ApiKey.get(), this.parseOrganizationId(ArgumentOptionsHandler.getInstance().getOrganizationId()));
        KeywordController.getInstance().parseAllCustomKeywordsWithoutRefreshing(project);
        if (consoleLauncherEntity.getOptions().has("appiumDirectory")) {
            RunConfiguration.getInstance().setAppiumDirectoryDefinedWithArgument(String.valueOf(consoleLauncherEntity.getOptions().valueOf("appiumDirectory")));
        }
        if (this.sessionController != null && this.sessionController.getSession() != null && this.sessionController.getSession().getLicense() != null && !this.sessionController.getSession().getLicense().isOffline()) {
            this.startScheduleCheckingLicense();
        }
        int exitCode = 0;
        if (FeatureFlags.isNewExecutionFlowEnabled()) {
            exitCode = this.executeV2(project, consoleLauncherEntity);
        } else {
            consoleLauncherEntity.getConsoleExecutor().execute(project, consoleLauncherEntity.getOptions());
            this.waitForExecutionToFinish(consoleLauncherEntity.getOptions());
            List consoleLaunchers = LauncherManager.getInstance().getSortedLaunchers();
            exitCode = ((ILauncher)consoleLaunchers.get(consoleLaunchers.size() - 1)).getResult().getReturnCode();
        }
        LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.RE_EXECUTE_COMPLETED, exitCode));
        this.endScheduleCheckingLicense(null);
        return exitCode;
    }

    private int executeV2(ProjectEntity project, ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        int exitCode;
        block15: {
            ConsoleExecutor consoleExecutor = consoleLauncherEntity.getConsoleExecutor();
            OptionSet options = consoleLauncherEntity.getOptions();
            LauncherOptionParser launcherOptionParser = consoleExecutor.buildLauncherOptionParser(project, options);
            LauncherOptionParser.ConsoleExecutionRequest consoleExecutionRequest = launcherOptionParser.verifyAndBuildConsoleExecutionRequest(project, LauncherManager.getInstance());
            TestExecutionRequest testExecutionRequest = null;
            testExecutionRequest = consoleExecutionRequest.entity instanceof TestSuiteEntity ? this.convertToTestSuiteExecutionRequest(consoleExecutionRequest, project) : this.convertToTestSuiteCollectionExecutionRequest(consoleExecutionRequest, project);
            IExecutionController.ExecutionJobFuture jobFuture = this.executionController.executeAsync(testExecutionRequest);
            int showProgressInterval = this.determineShowProgressIntervalInSeconds(options);
            logger.info("Will print execution status every {} second(s)", (Object)showProgressInterval);
            ScheduledExecutorService printStatusExecutor = null;
            AtomicReference printStatusExecutorRef = new AtomicReference();
            exitCode = 0;
            try {
                try {
                    printStatusExecutor = Executors.newScheduledThreadPool(1);
                    printStatusExecutorRef.set(printStatusExecutor.scheduleAtFixedRate(() -> {
                        if (jobFuture.job().getTestExecutionPlan().isPresent()) {
                            EntityExecution execution = ((TestExecutionPlan)jobFuture.job().getTestExecutionPlan().get()).getExecution();
                            KRELogPrinter.printExecutionProgress((EntityExecution)execution);
                            if (execution.getExecutionJobStatus().isFinal()) {
                                ((ScheduledFuture)printStatusExecutorRef.get()).cancel(false);
                            }
                        }
                    }, 0L, showProgressInterval, TimeUnit.SECONDS));
                    jobFuture.future().get();
                    if (jobFuture.job().getExitCode().isPresent()) {
                        exitCode = (Integer)jobFuture.job().getExitCode().get();
                        break block15;
                    }
                    logger.warn("Cannot get exit code from execution job, default to ERROR");
                    exitCode = 2;
                }
                catch (Exception ex) {
                    logger.error("Execution failed with error: " + ex.getMessage(), (Throwable)ex);
                    exitCode = 2;
                    if (printStatusExecutorRef.get() != null) {
                        ((ScheduledFuture)printStatusExecutorRef.get()).cancel(false);
                    }
                    if (printStatusExecutor == null) break block15;
                    try {
                        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)printStatusExecutor);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to shutdown executor service", (Throwable)e);
                    }
                }
            }
            finally {
                if (printStatusExecutorRef.get() != null) {
                    ((ScheduledFuture)printStatusExecutorRef.get()).cancel(false);
                }
                if (printStatusExecutor != null) {
                    try {
                        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)printStatusExecutor);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to shutdown executor service", (Throwable)e);
                    }
                }
            }
        }
        return exitCode;
    }

    private TestExecutionRequest convertToTestSuiteExecutionRequest(LauncherOptionParser.ConsoleExecutionRequest consoleExecutionRequest, ProjectEntity project) throws InvalidConsoleArgumentException, ExecutionException {
        ICapabilitySetting capabilitySetting = null;
        try {
            Pair pair = this.executionManager.resolveDriverSetting(consoleExecutionRequest.browserType);
            capabilitySetting = (ICapabilitySetting)pair.getLeft();
        }
        catch (UnsupportedDriverTypeException unsupportedDriverTypeException) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_BROWSER_X, consoleExecutionRequest.browserType));
        }
        String profileName = consoleExecutionRequest.executionProfileName;
        if (StringUtils.isBlank((CharSequence)profileName)) {
            profileName = "default";
        }
        ExecutionProfileEntity executionProfile = null;
        try {
            executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project);
        }
        catch (ControllerException controllerException) {}
        if (executionProfile == null) {
            throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
        }
        DriverConfiguration driverConfiguration = this.executionManager.createDriverConfigurationFromLegacyConfig(consoleExecutionRequest.legacyFlowConfig);
        GlobalVariablesConfiguration globalVariablesConfiguration = new GlobalVariablesConfiguration();
        globalVariablesConfiguration.setGlobalVariables(consoleExecutionRequest.globalVariables);
        globalVariablesConfiguration.setProtectedGlobalVariables(consoleExecutionRequest.protectedGlobalVariables);
        KREOverridingConfiguration kreOverridingConfiguration = new KREOverridingConfiguration();
        kreOverridingConfiguration.setEmailConfig(consoleExecutionRequest.emailConfig);
        kreOverridingConfiguration.setReportLocationSetting(consoleExecutionRequest.reportLocationSetting);
        kreOverridingConfiguration.setGlobalVariablesConfiguration(globalVariablesConfiguration);
        kreOverridingConfiguration.setWebServiceSettings(consoleExecutionRequest.webServiceSettings);
        kreOverridingConfiguration.setRerunSetting(consoleExecutionRequest.rerunSetting);
        kreOverridingConfiguration.setMaxFailedTests(consoleExecutionRequest.maxFailedTests > 0 ? Optional.of(consoleExecutionRequest.maxFailedTests) : Optional.empty());
        kreOverridingConfiguration.setTestSuiteQuery(consoleExecutionRequest.testSuiteQuery);
        kreOverridingConfiguration.setAdditionalInfo(consoleExecutionRequest.additionalInfo);
        kreOverridingConfiguration.setEnableProfiling(consoleExecutionRequest.enableProfiling);
        if (consoleExecutionRequest.executionUUID != null && !consoleExecutionRequest.executionUUID.isEmpty()) {
            kreOverridingConfiguration.setExecutionUUID(Optional.of(consoleExecutionRequest.executionUUID));
        }
        TestExecutionRequest executionRequest = TestExecutionRequest.builder().entity(consoleExecutionRequest.entity).capability(capabilitySetting).launchMode(LaunchMode.RUN).runningMode(RunningMode.CONSOLE).executionProfile(executionProfile).driverConfiguration(driverConfiguration).kreOverridingConfiguration(kreOverridingConfiguration).eventConfiguration(ExecutionEventConfiguration.executionConfig((RunningMode)RunningMode.CONSOLE)).build();
        return executionRequest;
    }

    private TestExecutionRequest convertToTestSuiteCollectionExecutionRequest(LauncherOptionParser.ConsoleExecutionRequest consoleExecutionRequest, ProjectEntity project) throws InvalidConsoleArgumentException, ExecutionException {
        int delay;
        String profileName;
        KREOverridingConfiguration kreOverridingConfiguration = new KREOverridingConfiguration();
        kreOverridingConfiguration.setWebServiceSettings(consoleExecutionRequest.webServiceSettings);
        kreOverridingConfiguration.setRerunSetting(consoleExecutionRequest.rerunSetting);
        kreOverridingConfiguration.setMaxFailedTests(consoleExecutionRequest.maxFailedTests > 0 ? Optional.of(consoleExecutionRequest.maxFailedTests) : Optional.empty());
        if (consoleExecutionRequest.browserType != null) {
            try {
                this.executionManager.resolveDriverSetting(consoleExecutionRequest.browserType);
            }
            catch (UnsupportedDriverTypeException unsupportedDriverTypeException) {
                throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_BROWSER_X, consoleExecutionRequest.browserType));
            }
        }
        if (!StringUtils.isBlank((CharSequence)(profileName = consoleExecutionRequest.executionProfileName))) {
            ExecutionProfileEntity executionProfile = null;
            try {
                executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project);
            }
            catch (ControllerException controllerException) {}
            if (executionProfile == null) {
                throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
            }
            kreOverridingConfiguration.setExecutionProfile(executionProfile);
        }
        GlobalVariablesConfiguration globalVariablesConfiguration = new GlobalVariablesConfiguration();
        globalVariablesConfiguration.setGlobalVariables(consoleExecutionRequest.globalVariables);
        globalVariablesConfiguration.setProtectedGlobalVariables(consoleExecutionRequest.protectedGlobalVariables);
        kreOverridingConfiguration.setEmailConfig(consoleExecutionRequest.emailConfig);
        kreOverridingConfiguration.setReportLocationSetting(consoleExecutionRequest.reportLocationSetting);
        kreOverridingConfiguration.setGlobalVariablesConfiguration(globalVariablesConfiguration);
        kreOverridingConfiguration.setTestSuiteColQuery(consoleExecutionRequest.testSuiteColQuery);
        kreOverridingConfiguration.setAdditionalInfo(consoleExecutionRequest.additionalInfo);
        kreOverridingConfiguration.setEnableProfiling(consoleExecutionRequest.enableProfiling);
        if (consoleExecutionRequest.executionUUID != null && !consoleExecutionRequest.executionUUID.isEmpty()) {
            kreOverridingConfiguration.setExecutionUUID(Optional.of(consoleExecutionRequest.executionUUID));
        }
        if (consoleExecutionRequest.delayBetweenInstances.isPresent() && consoleExecutionRequest.delayBetweenInstances.get() != null && (delay = ((Integer)consoleExecutionRequest.delayBetweenInstances.get()).intValue()) >= 0 && delay <= 999) {
            kreOverridingConfiguration.setDelayBetweenInstances(consoleExecutionRequest.delayBetweenInstances);
        }
        TestExecutionRequest executionRequest = TestExecutionRequest.builder().entity(consoleExecutionRequest.entity).launchMode(LaunchMode.RUN).runningMode(RunningMode.CONSOLE).eventConfiguration(ExecutionEventConfiguration.executionConfig((RunningMode)RunningMode.CONSOLE)).kreOverridingConfiguration(kreOverridingConfiguration).build();
        return executionRequest;
    }

    private void waitForExecutionToFinish(OptionSet options) {
        int progressDelay = this.determineShowProgressIntervalInSeconds(options);
        this.waitForExecutionToFinish(progressDelay);
    }

    private void waitForExecutionToFinish(int showProgressDelay) {
        int progressDelayTimeInMiliseconds = (showProgressDelay < 0 ? 15 : showProgressDelay) * 1000;
        do {
            this.printStatus();
            try {
                Thread.sleep(progressDelayTimeInMiliseconds);
            }
            catch (InterruptedException interruptedException) {}
        } while (LauncherManager.getInstance().isAnyLauncherRunning());
        this.printStatus();
    }

    private int determineShowProgressIntervalInSeconds(OptionSet options) {
        int progressDelay = 15;
        if (options.has("statusDelay")) {
            String progressDelayString = String.valueOf(options.valueOf("statusDelay"));
            try {
                progressDelay = Integer.valueOf(progressDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_PARSE_X_FOR_Y_TO_INTEGER, progressDelayString, "statusDelay"));
            }
        }
        return progressDelay < 0 ? 15 : progressDelay;
    }

    private void startScheduleCheckingLicense() {
        try {
            this.sessionController.startScheduleCheckingLicense(this::handleLicenseExpiration, this::handleLicenseError);
            this.isLicenseCheckingRunning = true;
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)("Cannot start checking license task: " + e.getMessage()));
        }
    }

    private void handleLicenseExpiration() {
        SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.LICENSE_EXPIRED, ApplicationMessageConstants.LICENSE_EXPIRED);
        this.endScheduleCheckingLicense(schedule);
    }

    private void handleLicenseError() {
        try {
            this.sessionController.reactivation();
        }
        catch (SessionException e) {
            Throwable cause = e.getCause();
            String errorMessage = cause instanceof MultipleActivationException ? cause.getMessage() : e.getMessage();
            String message = MessageFormat.format("{0} - {1}", ApplicationMessageConstants.LICENSE_ERROR_RENEW, errorMessage);
            SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.LICENSE_ERROR, message);
            this.endScheduleCheckingLicense(schedule);
        }
        catch (Exception e) {
            String message = MessageFormat.format("{0} - {1}", ApplicationMessageConstants.LICENSE_ERROR_RENEW, e.getMessage());
            SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.LICENSE_ERROR, message);
            this.endScheduleCheckingLicense(schedule);
        }
    }

    private void endScheduleCheckingLicense(SessionExpireSchedule scheduleError) {
        if (scheduleError != null) {
            LogUtil.printErrorLine((String)scheduleError.getMessage());
        }
        if (this.isLicenseCheckingRunning) {
            this.sessionController.endScheduleCheckingLicense();
            this.isLicenseCheckingRunning = false;
        }
    }
}

