/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.tracking.service;

import com.katalon.tracking.constant.TrackingEventEnum;
import com.katalon.tracking.domain.model.Account;
import com.katalon.tracking.domain.model.Application;
import com.katalon.tracking.domain.model.Host;
import com.katalon.tracking.domain.model.KatalonStudioContext;
import com.katalon.tracking.domain.model.KatalonTrackingDto;
import com.katalon.tracking.domain.model.License;
import com.katalon.tracking.domain.model.Os;
import com.katalon.tracking.domain.model.Session;
import com.katalon.tracking.domain.model.TrackingProperties;
import com.katalon.tracking.domain.model.TrackingRequest;
import com.katalon.tracking.service.ITrackingService;
import com.katalon.tracking.util.JsonMapper;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.session.core.model.KatalonPackage;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class KatalonTrackingService
implements ITrackingService {
    private static final Logger logger = LoggerFactory.getLogger(KatalonTrackingService.class);
    public static String TRACKING_PRODUCT_USAGE_PATH = "/api/product/usage";
    public static String TRACKING_ACTIVATION_PATH = "/api/activation-tracking";
    private static String PROP_KEY_KATALON_USAGE_TRACKING_DISABLED = "katalon.telemetryDisabled";
    @Inject
    private IFeatureController featureController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IDiscoveryService discoveryService;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;

    public boolean canSubmitUsageTrackingData() {
        boolean canConfigUsageTracking = this.featureController.canUse(ProductFeature.CONFIGURE_USAGE_TRACKING);
        if (!canConfigUsageTracking) {
            return true;
        }
        if (Boolean.valueOf(System.getProperty(PROP_KEY_KATALON_USAGE_TRACKING_DISABLED)).booleanValue()) {
            return false;
        }
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        return prefStore.contains("general.autoCheckAllowUsage_Tracking") ? prefStore.getBoolean("general.autoCheckAllowUsage_Tracking") : true;
    }

    public void trackUsage(TrackingRequest trackingRequest) {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.TRACKING);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return;
        }
        if (!this.canSubmitUsageTrackingData()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            KatalonTrackingDto katalonTrackingDto = KatalonTrackingDto.builder().event((String)Optional.ofNullable(trackingRequest.getEvent()).map(TrackingEventEnum::getEventName).orElse(null)).userId(this.getUserId()).properties(TrackingProperties.builder().action(trackingRequest.getAction()).ksContext(this.getKatalonStudioContext()).featureContext(trackingRequest.getFeatureContext()).trackingData(trackingRequest.getTrackingData()).timestamp(System.currentTimeMillis()).build()).build();
            try {
                URI baseUri = new URI(baseUrl);
                URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(TRACKING_PRODUCT_USAGE_PATH);
                URI uri = uriBuilder.build();
                HashMap headers = new HashMap();
                ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
                HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
                this.httpClient.jsonPost(uri, JsonMapper.toJson(katalonTrackingDto), httpOptions);
            }
            catch (Exception e) {
                logger.error("Exception occurred while tracking Katalon Studio usage", (Throwable)e);
            }
        }).orTimeout(30L, TimeUnit.SECONDS).exceptionally(ex -> {
            logger.debug("Tracking request timed out", ex);
            return null;
        });
    }

    private KatalonStudioContext getKatalonStudioContext() {
        com.kms.katalon.session.core.model.Session session = this.sessionController.getSession();
        String katalonPackage = Optional.ofNullable(session.getKatalonPackage()).map(KatalonPackage::getValue).orElse(null);
        String edition = Optional.ofNullable(session.getKatalonEdition()).map(KatalonEdition::getName).orElse(null);
        String licenseType = Optional.ofNullable(session.getLicense()).map(com.kms.katalon.session.core.model.License::getLicenseType).map(Enum::toString).map(StringUtils::lowerCase).orElse(null);
        String accountId = Optional.ofNullable(session.getAccount()).map(com.kms.katalon.session.core.model.Account::getId).map(String::valueOf).orElse(null);
        String organizationId = Optional.ofNullable(session.getOrganization()).map(Organization::getId).map(String::valueOf).orElse(null);
        String katVersion = session.getKatVersion();
        String version = this.getVersion(katVersion);
        String build = this.getBuild(katVersion);
        return KatalonStudioContext.builder().os(Os.builder().name(session.getOs()).arch(session.getOsArch()).version(session.getOsVersion()).archType(session.getOsType()).build()).host(Host.builder().name(session.getHostname()).machineId(session.getMachineId()).userKey(session.getUserKey()).build()).application(Application.builder().katalonPackage(katalonPackage).edition(edition).archType(session.getKatType()).version(version).build(build).build()).account(Account.builder().id(accountId).build()).organization(com.katalon.tracking.domain.model.Organization.builder().id(organizationId).build()).license(License.builder().type(licenseType).build()).session(Session.builder().id(session.getSessionId()).build()).build();
    }

    private String getUserId() {
        com.kms.katalon.session.core.model.Session session = this.sessionController.getSession();
        return (String)StringUtils.defaultIfBlank((CharSequence)KatalonTrackingService.getEmail(session), (CharSequence)"");
    }

    private static String getEmail(com.kms.katalon.session.core.model.Session session) {
        KatOneJwtToken jwtToken;
        UserInfo userInfo = session.getUserInfo();
        if (Objects.nonNull(userInfo)) {
            return userInfo.getEmail();
        }
        AuthenticationToken token = session.getKatOneToken();
        if (Objects.nonNull(token) && Objects.nonNull(jwtToken = KatOneJwtToken.parseToken((String)token.getAccessToken()))) {
            return jwtToken.getEmail();
        }
        return "";
    }

    private String getBuild(String katVersion) {
        Pattern p = Pattern.compile("(\\d+\\.\\d+\\.\\d+)\\s+build\\s+(\\$\\{buildNumber\\}|\\d+)");
        Matcher m = p.matcher(katVersion);
        if (m.find()) {
            return m.group(1) + "-" + m.group(2);
        }
        return "";
    }

    private String getVersion(String katVersion) {
        Pattern p = Pattern.compile("(\\d+\\.\\d+\\.\\d+)");
        Matcher m = p.matcher(katVersion);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

