/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureTestSuiteRef;
import com.kms.katalon.integration.azure.model.AzureTestSuitesRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class AzureIntegrationUtil {
    public static boolean isIntegrationEnabled(String projectDir) {
        AzureSettingStore store = AzureSettingStore.getStore(projectDir);
        return store.isIntegrationEnabled();
    }

    public static IntegratedEntity getIntegratedEntity(IntegratedFileEntity fileEntity) {
        return fileEntity.getIntegratedEntity(GlobalStringConstants.AZURE_DEVOPS_NAME);
    }

    public static boolean isPositiveInteger(String number) {
        if (number == null) {
            return false;
        }
        try {
            int parsedNumber = Integer.parseInt(number);
            return parsedNumber >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static List<AzureTestSuiteRef> getTestSuiteRefs(AzureCredential credential, Set<Integer> testPlanIds, int testCaseId) throws AzureApiException {
        AzureTestSuitesRef allTestSuites = AzureIntegrationRequest.getTestSuitesByTestCaseId(credential, testCaseId);
        List<AzureTestSuiteRef> testSuites = Arrays.stream(allTestSuites.getValue()).filter(suite -> testPlanIds.contains(suite.getTestPlan().getId())).toList();
        if (testSuites.isEmpty()) {
            return new ArrayList<AzureTestSuiteRef>();
        }
        return testSuites;
    }
}

