/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureStatus;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.setting.AzureAttachmentSendingType;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.util.CryptoUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class AzureSettingStore
extends BundleSettingStore {
    private static final String DEFAULT_TEST_RUN_NAME = "Run by Katalon Studio";
    private static final int DEFAULT_DEFINITION_ID = -1;
    @Inject
    private IFeatureController featureController;

    public AzureSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.integration.azure", true);
    }

    public static AzureSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return AzureSettingStore.getStore(projectEntity.getFolderLocation());
    }

    public static AzureSettingStore getStore(String projectDir) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{projectDir})) {
            return null;
        }
        AzureSettingStore instance = new AzureSettingStore(projectDir);
        BundleContext bundleContext = FrameworkUtil.getBundle(IEclipseContext.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)((Object)instance), (IEclipseContext)context);
        return instance;
    }

    public boolean isIntegrationEnabled() {
        block3: {
            try {
                boolean isAllowedUsingAzureFeature = this.featureController.canUse(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION);
                if (isAllowedUsingAzureFeature) break block3;
                LogUtil.printAndLogError(null, (String)StringConstants.MSG_ERROR_DOT_NOT_HAVE_LICENSE);
                return false;
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
                return false;
            }
        }
        return this.getBoolean("enableIntegration", false);
    }

    public void setIntegration(boolean isIntegrationEnabled) throws IOException {
        this.setProperty("enableIntegration", isIntegrationEnabled);
    }

    public boolean isEncryptionEnabled() {
        try {
            return this.getBoolean("enableAuthenticationEncryption", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void setEncryption(boolean isEncryptionEnabled) throws IOException {
        this.setProperty("enableAuthenticationEncryption", isEncryptionEnabled);
    }

    public String getServerUrl() {
        try {
            return this.getString("serverUrl", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public void setServerUrl(String serverUrl, boolean shouldEncrypt) throws IOException {
        this.setProperty("serverUrl", serverUrl);
    }

    public String getToken(boolean isEncoded) {
        String rawData;
        block4: {
            rawData = this.getString("token", "");
            if (!isEncoded) {
                return rawData;
            }
            if (!StringUtils.isEmpty((CharSequence)rawData)) break block4;
            return "";
        }
        try {
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)rawData));
        }
        catch (IOException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public void setToken(String token, boolean shouldEncode) throws IOException, GeneralSecurityException {
        if (token.trim().isEmpty()) {
            return;
        }
        String savedToken = shouldEncode ? CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)token)) : token;
        this.setProperty("token", savedToken);
    }

    public AzureProjectRef getIntegratedProject() {
        String projectJsonString = "";
        try {
            projectJsonString = this.getString("integratedProject", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)projectJsonString)) {
            return null;
        }
        return (AzureProjectRef)JsonUtil.fromJson((String)projectJsonString, AzureProjectRef.class);
    }

    public void setAzureProjectRef(AzureProjectRef project) throws IOException {
        if (project == null) {
            this.setProperty("integratedProject", "");
            return;
        }
        String projectJsonString = JsonUtil.toJson((Object)project);
        this.setProperty("integratedProject", projectJsonString);
    }

    public void setFetchedAzureProjectList(AzureProjectRef[] projects) throws IOException {
        if (projects == null || projects.length <= 0) {
            return;
        }
        this.setProperty("fetchedProjectList", JsonUtil.toJson((Object)projects));
    }

    public AzureProjectRef[] getFetchedAzureProjectList() {
        String rawFetchedProjectList = "";
        try {
            rawFetchedProjectList = this.getString("fetchedProjectList", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)rawFetchedProjectList)) {
            return new AzureProjectRef[0];
        }
        TypeToken<AzureProjectRef[]> typeToken = new TypeToken<AzureProjectRef[]>(){};
        return (AzureProjectRef[])JsonUtil.fromJson((String)rawFetchedProjectList, (Type)typeToken.getType());
    }

    public void setFetchedAzureTestPlanList(AzureTestPlanRef[] testPlans) throws IOException {
        if (testPlans == null) {
            this.setProperty("fetchedTestPlanList", JsonUtil.toJson((Object)new AzureProjectRef[0]));
            return;
        }
        this.setProperty("fetchedTestPlanList", JsonUtil.toJson((Object)testPlans));
    }

    public AzureTestPlanRef[] getFetchedAzureTestPlanList() {
        String rawFetchedTestPlanList = "";
        try {
            rawFetchedTestPlanList = this.getString("fetchedTestPlanList", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)rawFetchedTestPlanList)) {
            return new AzureTestPlanRef[0];
        }
        TypeToken<AzureTestPlanRef[]> typeToken = new TypeToken<AzureTestPlanRef[]>(){};
        return (AzureTestPlanRef[])JsonUtil.fromJson((String)rawFetchedTestPlanList, (Type)typeToken.getType());
    }

    public List<ExecutionStatusMapping> getExecutionStatusMappings() {
        String executionStatusMappingsJson = "";
        try {
            executionStatusMappingsJson = this.getString("executionStatusMappings", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return this.getDefaultExecutionStatusMappings();
        }
        if (StringUtils.isEmpty((CharSequence)executionStatusMappingsJson)) {
            return this.getDefaultExecutionStatusMappings();
        }
        TypeToken<List<ExecutionStatusMapping>> typeToken = new TypeToken<List<ExecutionStatusMapping>>(){};
        List executionStatusMapping = (List)JsonUtil.fromJson((String)executionStatusMappingsJson, (Type)typeToken.getType());
        if (executionStatusMapping == null || executionStatusMapping.size() <= 0) {
            return this.getDefaultExecutionStatusMappings();
        }
        return executionStatusMapping;
    }

    public void setExecutionStatusMappings(List<ExecutionStatusMapping> mappings) throws IOException {
        if (mappings == null || mappings.size() <= 0) {
            this.setProperty("executionStatusMappings", "");
            return;
        }
        this.setProperty("executionStatusMappings", JsonUtil.toJson(mappings));
    }

    public List<ExecutionStatusMapping> getDefaultExecutionStatusMappings() {
        ArrayList<ExecutionStatusMapping> mappings = new ArrayList<ExecutionStatusMapping>();
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.PASSED.toString(), AzureStatus.PASSED.toString()));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.FAILED.toString(), AzureStatus.FAILED.toString()));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.INCOMPLETE.toString(), AzureStatus.ABORTED.toString()));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.ERROR.toString(), AzureStatus.ERROR.toString()));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.SKIPPED.toString(), AzureStatus.NOT_EXECUTED.toString()));
        return mappings;
    }

    public List<TestConfigurationMapping> getTestConfigurationMappings() {
        String executionStatusMappingsJson = "";
        try {
            executionStatusMappingsJson = this.getString("testConfigurationMappings", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return this.getDefaultTestConfigurationMappings();
        }
        if (StringUtils.isEmpty((CharSequence)executionStatusMappingsJson)) {
            return this.getDefaultTestConfigurationMappings();
        }
        TypeToken<List<TestConfigurationMapping>> typeToken = new TypeToken<List<TestConfigurationMapping>>(){};
        List testConfigMappings = (List)JsonUtil.fromJson((String)executionStatusMappingsJson, (Type)typeToken.getType());
        if (testConfigMappings == null || testConfigMappings.size() <= 0) {
            return this.getDefaultTestConfigurationMappings();
        }
        return testConfigMappings;
    }

    public void setTestConfigurationMappings(List<TestConfigurationMapping> mappings) throws IOException {
        if (mappings == null || mappings.size() <= 0) {
            return;
        }
        this.setProperty("testConfigurationMappings", JsonUtil.toJson(mappings));
    }

    public List<TestConfigurationMapping> getDefaultTestConfigurationMappings() {
        ArrayList<TestConfigurationMapping> mappings = new ArrayList<TestConfigurationMapping>();
        mappings.add(new TestConfigurationMapping("--Any--", "--Any--", null, 0));
        return mappings;
    }

    public AzureCredential getCredential() {
        AzureCredential credential = new AzureCredential();
        credential.setServerUrl(this.getServerUrl());
        credential.setToken(this.getToken(this.isEncryptionEnabled()));
        return credential;
    }

    @Deprecated
    private AzureTestPlanRef getAzureTestPlan() {
        String testPlanJsonString = "";
        try {
            testPlanJsonString = this.getString("submitOptions.testPlan", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)testPlanJsonString)) {
            return null;
        }
        return (AzureTestPlanRef)JsonUtil.fromJson((String)testPlanJsonString, AzureTestPlanRef.class);
    }

    @Deprecated
    private void setAzureTestPlanRef(AzureTestPlanRef testPlan) throws IOException {
        if (testPlan == null) {
            this.setProperty("submitOptions.testPlan", "");
            return;
        }
        String projectJsonString = JsonUtil.toJson((Object)testPlan);
        this.setProperty("submitOptions.testPlan", projectJsonString);
    }

    public AzureTestPlanRef[] getAzureTestPlans() {
        String jsonString = "";
        try {
            jsonString = this.getString("submitOptions.testPlans", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            AzureTestPlanRef legacyTestPlan = this.getAzureTestPlan();
            if (legacyTestPlan != null) {
                return new AzureTestPlanRef[]{legacyTestPlan};
            }
            return new AzureTestPlanRef[0];
        }
        return (AzureTestPlanRef[])JsonUtil.fromJson((String)jsonString, AzureTestPlanRef[].class);
    }

    public void setAzureTestPlanRefs(AzureTestPlanRef[] testPlans) throws IOException {
        if (testPlans == null) {
            this.setProperty("submitOptions.testPlans", "");
            return;
        }
        String jsonString = JsonUtil.toJson((Object)testPlans);
        this.setProperty("submitOptions.testPlans", jsonString);
    }

    public boolean isAutoSubmitTestRunEnabled() {
        try {
            return this.getBoolean("submitOptions.autoSubmitTestRun", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return true;
        }
    }

    public void setAutoSubmitTestRun(boolean autoSubmitTestRun) throws IOException {
        this.setProperty("submitOptions.autoSubmitTestRun", autoSubmitTestRun);
    }

    public boolean isSubmitMultipleTestPointsEnabled() {
        try {
            return this.getBoolean("submitOptions.enableSubmitMultiTestPoints", false);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return true;
        }
    }

    public void setSubmitMultipleTestPoints(boolean submitMultipleTestPointsEnabled) throws IOException {
        this.setProperty("submitOptions.enableSubmitMultiTestPoints", submitMultipleTestPointsEnabled);
    }

    public boolean isOverrideExistingAutomationFieldsEnabled() {
        try {
            return this.getBoolean("submitOptions.enableOverrideExistingAutomationFields", false);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void setOverrideExistingAutomationFields(boolean overrideExistingAutomationFields) throws IOException {
        this.setProperty("submitOptions.enableOverrideExistingAutomationFields", overrideExistingAutomationFields);
    }

    public String getTestRunName() {
        try {
            return this.getString("submitOptions.testRunName", this.getDefaultTestRunName());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public String getDefaultTestRunName() {
        return DEFAULT_TEST_RUN_NAME;
    }

    public void setTestRunName(String testRunName) throws IOException {
        if (testRunName == null) {
            this.setProperty("submitOptions.testRunName", "");
        } else {
            this.setProperty("submitOptions.testRunName", testRunName);
        }
    }

    public boolean isIncludeAttachmentEnabled() {
        try {
            return this.getBoolean("submitOptions.enableIncludeAttachment", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return true;
        }
    }

    public void setIncludeAttachmentEnabled(boolean includeAttachmentEnabled) throws IOException {
        this.setProperty("submitOptions.enableIncludeAttachment", includeAttachmentEnabled);
    }

    public AzureAttachmentSendingType getAttachmentSendingType() {
        String sendingTypeString;
        try {
            sendingTypeString = this.getString("submitOptions.attachmentSendingType", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            sendingTypeString = "";
        }
        if (StringUtils.isEmpty((CharSequence)sendingTypeString)) {
            return AzureAttachmentSendingType.SEND_IF_FAILS;
        }
        return AzureAttachmentSendingType.valueOf(sendingTypeString);
    }

    public void setAttachmentSendingType(AzureAttachmentSendingType sendingType) throws IOException {
        this.setProperty("submitOptions.attachmentSendingType", sendingType.name());
    }

    public List<ReportFormatType> getAttachmentFileTypes() {
        String reportFormatJsonString;
        try {
            reportFormatJsonString = this.getString("submitOptions.attachFileTypes", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            reportFormatJsonString = "";
        }
        if (StringUtils.isEmpty((CharSequence)reportFormatJsonString)) {
            return new ArrayList<ReportFormatType>();
        }
        TypeToken<List<ReportFormatType>> typeToken = new TypeToken<List<ReportFormatType>>(){};
        return (List)JsonUtil.fromJson((String)reportFormatJsonString, (Type)typeToken.getType());
    }

    public void setAttachmentFileTypes(List<ReportFormatType> attachmentFileTypes) throws IOException {
        if (attachmentFileTypes == null || attachmentFileTypes.size() <= 0) {
            return;
        }
        this.setProperty("submitOptions.attachFileTypes", JsonUtil.toJson(attachmentFileTypes));
    }

    public int getBuildDefinitionId() {
        try {
            int oldBuildDefinitionId = this.getInt("submitOptions.definitionId", -1);
            return this.getInt("submitOptions.buildDefinitionId", oldBuildDefinitionId);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return -1;
        }
    }

    public void setBuildDefinitionId(int buildDefinitionId) throws IOException {
        if (buildDefinitionId < 0) {
            this.setProperty("submitOptions.buildDefinitionId", -1);
        } else {
            this.setProperty("submitOptions.buildDefinitionId", buildDefinitionId);
        }
    }

    public int getReleaseDefinitionId() {
        try {
            return this.getInt("submitOptions.releaseDefinitionId", -1);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return -1;
        }
    }

    public void setReleaseDefinitionId(int releaseDefinitionId) throws IOException {
        if (releaseDefinitionId < 0) {
            this.setProperty("submitOptions.releaseDefinitionId", -1);
        } else {
            this.setProperty("submitOptions.releaseDefinitionId", releaseDefinitionId);
        }
    }
}

