/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium;

import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.utils.StorageType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class Storage {
    private IndependentBrowser browser;
    private final boolean isLocalStorage;

    public Storage(IndependentBrowser browser, StorageType st) {
        this.browser = browser;
        this.isLocalStorage = StorageType.LOCAL.equals((Object)st);
    }

    private static String extractOrigin(String fullUrl) {
        URI uri = null;
        try {
            uri = new URI(fullUrl);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            return String.valueOf(scheme) + "://" + host;
        }
        return String.valueOf(scheme) + "://" + host + ":" + port;
    }

    public CompletableFuture<String> getItem(String key) {
        ArrayList<Map.Entry<String, Object>> params = new ArrayList<Map.Entry<String, Object>>();
        params.add(new AbstractMap.SimpleEntry<String, Map<String, Object>>("storageId", this.getStorageId()));
        params.add(new AbstractMap.SimpleEntry<String, String>("key", key));
        return this.browser.sendDevToolsMessage("DOMStorage.getDOMStorageItems", params, "entries").thenApply(response -> {
            if (response instanceof List) {
                List entries = (List)response;
                for (List entry : entries) {
                    if (!((String)entry.get(0)).equals(key)) continue;
                    return (String)entry.get(1);
                }
            }
            return null;
        });
    }

    private Map<String, Object> getStorageId() {
        HashMap<String, Object> storageId = new HashMap<String, Object>();
        storageId.put("securityOrigin", Storage.extractOrigin(this.browser.getUrl()));
        storageId.put("isLocalStorage", this.isLocalStorage);
        return storageId;
    }

    public CompletableFuture<Void> setItem(String key, String value) {
        ArrayList<Map.Entry<String, Object>> params = new ArrayList<Map.Entry<String, Object>>();
        params.add(new AbstractMap.SimpleEntry<String, Map<String, Object>>("storageId", this.getStorageId()));
        params.add(new AbstractMap.SimpleEntry<String, String>("value", value));
        params.add(new AbstractMap.SimpleEntry<String, String>("key", key));
        return this.browser.sendDevToolsMessage("DOMStorage.setDOMStorageItem", params, "").thenApply(response -> null);
    }

    public void remove(String key) {
        ArrayList<Map.Entry<String, Object>> params = new ArrayList<Map.Entry<String, Object>>();
        params.add(new AbstractMap.SimpleEntry<String, Map<String, Object>>("storageId", this.getStorageId()));
        params.add(new AbstractMap.SimpleEntry<String, String>("key", key));
        this.browser.sendDevToolsMessage("DOMStorage.removeDOMStorageItem", params, "");
    }

    public void clear() {
        ArrayList<Map.Entry<String, Object>> params = new ArrayList<Map.Entry<String, Object>>();
        params.add(new AbstractMap.SimpleEntry<String, Map<String, Object>>("storageId", this.getStorageId()));
        this.browser.sendDevToolsMessage("DOMStorage.clear", params, "");
    }
}

