/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.github.cliftonlabs.json_simple.JsonObject;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import org.cef.browser.CefRequestContext;

public class Net {
    private static Net net = null;
    private String proxyConfig = "";

    public static void config() {
        if (net == null) {
            net = new Net();
        }
        net.setInBrowser();
    }

    private void setInBrowser() {
        if (Boolean.getBoolean("java.net.useSystemProxies")) {
            this.setPreference("SYSTEM", "");
            return;
        }
        String preference = System.getProperty("chromium.proxy_pac_script", "");
        if (!preference.isEmpty()) {
            this.setPreference("pac_script", preference);
            return;
        }
        ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
        String[] stringArray = new String[]{"http", "https", "socks"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (Boolean.getBoolean(String.valueOf(scheme) + ".proxySet")) {
                String netHost = System.getProperty(String.valueOf(scheme) + ".proxyHost", "");
                String netPort = System.getProperty(String.valueOf(scheme) + ".proxyPort", "");
                if (!netHost.isEmpty() && !netPort.isEmpty()) {
                    NetConfig netConfig = new NetConfig(String.valueOf(scheme) + ":", String.valueOf(netHost) + ":" + netPort, System.getProperty(String.valueOf(scheme) + ".nonProxyHosts", ""));
                    netConfigs.add(netConfig);
                }
            }
            ++n2;
        }
        if (!netConfigs.isEmpty()) {
            String pacFileContent = this.createPacFileContent(netConfigs);
            String base64PacFile = this.base64Encode(pacFileContent);
            this.setPreference("pac_script", "data:application/x-javascript-config;base64," + base64PacFile);
        } else if ("false".equals(System.getProperty("java.net.useSystemProxies", ""))) {
            this.setPreference("direct", "");
        }
    }

    private void setPreference(String mode, String preference) {
        CefRequestContext cefRequestContext = CefRequestContext.getGlobalContext();
        if ((this.proxyConfig.isEmpty() || !this.proxyConfig.equals(String.valueOf(mode) + preference)) && cefRequestContext != null) {
            JsonObject dictionary = new JsonObject();
            dictionary.put("mode", mode);
            if ("pac_script".equals(mode)) {
                dictionary.put("pac_url", preference);
            }
            cefRequestContext.setPreference("proxy", dictionary.toJson());
            this.proxyConfig = String.valueOf(mode) + preference;
        }
    }

    private String base64Encode(String value) {
        try {
            return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String createPacFileContent(ArrayList<NetConfig> netConfigs) {
        String stringFile = "function FindProxyForURL(url, host) {\n";
        for (NetConfig netConfig : netConfigs) {
            String scheme = netConfig.scheme;
            String bypassList = netConfig.nonProxyHosts;
            String handleBypassList = "";
            if (!bypassList.isEmpty()) {
                handleBypassList = "        for (let address of \"" + bypassList + "\".split(\"|\")) {\n" + "            if (url.substring(" + (scheme.length() + 2) + ").startsWith(address)) {\n" + "                return \"DIRECT\";\n" + "            }\n" + "        }\n";
            }
            String schemeCondition = "socks:".equals(scheme) ? "    if (url.substring(0,4) ===  \"http\") {\n" : "    if (url.substring(0," + scheme.length() + ") ===  \"" + scheme + "\") {\n";
            stringFile = String.valueOf(stringFile) + schemeCondition + handleBypassList + "        return \"PROXY " + netConfig.address + "\";\n" + "    }\n";
        }
        stringFile = String.valueOf(stringFile) + "}";
        return stringFile;
    }

    private class NetConfig {
        String scheme;
        String address;
        String nonProxyHosts;

        NetConfig(String scheme, String address, String nonProxyHosts) {
            this.scheme = scheme;
            this.address = address;
            this.nonProxyHosts = nonProxyHosts;
        }
    }
}

