/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserFactory;
import org.cef.browser.CefRequestContext;

public class CefClientSwing
extends CefClient {
    private volatile CefBrowser focusedBrowser_ = null;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (CefClientSwing.this.focusedBrowser_ != null) {
                Component browserUI = (Component)CefClientSwing.this.focusedBrowser_.getUIComponent();
                Object oldUI = evt.getOldValue();
                if (CefClientSwing.this.isPartOf(oldUI, browserUI)) {
                    CefClientSwing.this.focusedBrowser_.setFocus(false);
                    CefClientSwing.this.focusedBrowser_ = null;
                }
            }
        }
    };

    CefClientSwing() throws UnsatisfiedLinkError {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.propertyChangeListener);
    }

    private boolean isPartOf(Object obj, Component browserUI) {
        if (obj == browserUI) {
            return true;
        }
        if (obj instanceof Container) {
            Component[] childs;
            Component[] componentArray = childs = ((Container)obj).getComponents();
            if (childs.length != 0) {
                Component child = componentArray[0];
                return this.isPartOf(child, browserUI);
            }
        }
        return false;
    }

    @Override
    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent, CefRequestContext context, CefBrowserSettings settings) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        return CefBrowserFactory.create(this, url, isOffscreenRendered, isTransparent, context, settings);
    }

    @Override
    public void onTakeFocus(CefBrowser browser, boolean next) {
        super.onTakeFocus(browser, next);
        Component component = (Component)browser.getUIComponent();
        Container parent = component.getParent();
        if (parent != null) {
            FocusTraversalPolicy policy = null;
            while (parent != null) {
                policy = parent.getFocusTraversalPolicy();
                if (policy != null) break;
                parent = parent.getParent();
            }
            if (policy != null) {
                Component nextComp;
                Component component2 = nextComp = next ? policy.getComponentAfter(parent, (Component)browser.getUIComponent()) : policy.getComponentBefore(parent, (Component)browser.getUIComponent());
                if (nextComp == null) {
                    policy.getDefaultComponent(parent).requestFocus();
                } else {
                    nextComp.requestFocus();
                }
            }
        }
        this.focusedBrowser_ = null;
    }

    @Override
    public void onGotFocus(CefBrowser browser) {
        super.onGotFocus(browser);
        this.focusedBrowser_ = browser;
    }

    @Override
    public void onBeforeClose(CefBrowser browser) {
        super.onBeforeClose(browser);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.propertyChangeListener);
    }
}

