/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.context.internal;

import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.ExecutionListenerEventHandler;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.core.event.TestingEvent;
import com.kms.katalon.core.helper.screenrecorder.CDTVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoConfiguration;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderBuilder;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;
import com.kms.katalon.core.helper.screenrecorder.VideoSubtitleWriter;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.setting.VideoRecorderSettings;
import com.kms.katalon.core.util.VideoRecorderUtil;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.TestOpsUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.openqa.selenium.WebDriver;

public class VideoRecorderService
implements ExecutionListenerEventHandler {
    private static final String VIDEO_KEYWORD_NAME = "Video";
    private static final String VIDEOS_FOLDER_NAME = "videos";
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private String reportFolder;
    private VideoRecorderSettings videoRecorderSettings;
    private long actionStartTime = 0L;
    private VideoRecorder videoRecorder;
    private VideoSubtitleWriter screenRecorderSubWriter;
    private int prevStepIndex = 0;
    private String prevStepName;
    private String prevStepDescription;
    private InternalTestCaseContext lastestTestCaseContext;

    public VideoRecorderService(String reportFolder, VideoRecorderSettings videoRecorderSettings) {
        this.reportFolder = reportFolder;
        this.videoRecorderSettings = videoRecorderSettings;
        EventBusSingleton.getInstance().getEventBus().register((Object)this);
    }

    private boolean shouldRecord() {
        return this.isEnableScreenRecorder() || this.isEnableBrowserRecorder();
    }

    private boolean isEnableScreenRecorder() {
        return this.videoRecorderSettings.isEnable() && !this.videoRecorderSettings.isUseBrowserRecorder();
    }

    private boolean isEnableBrowserRecorder() {
        return this.videoRecorderSettings.isEnable() && this.videoRecorderSettings.isUseBrowserRecorder();
    }

    private boolean isEnableRecorder() {
        return this.videoRecorderSettings.isEnable();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onTestingEvent(TestingEvent event) {
        switch (event.getType()) {
            case BROWSER_OPENED: 
            case URL_NAVIGATED: {
                if (!this.isEnableBrowserRecorder() || this.lastestTestCaseContext == null) break;
                this.startRecorder((WebDriver)event.getData());
                break;
            }
        }
    }

    @Override
    public void handleListenerEvent(ExecutionListenerEvent listenerEvent, Object[] testContext) {
        if (!this.shouldRecord()) {
            return;
        }
        switch (listenerEvent) {
            case BEFORE_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                this.startRecorder(null);
                break;
            }
            case AFTER_TEST_CASE: {
                this.lastestTestCaseContext = (InternalTestCaseContext)testContext[0];
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                try {
                    this.flushSubTitles();
                    if (!this.isEnableRecorder()) break;
                    this.stopRecording();
                }
                catch (VideoRecorderException error) {
                    this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
                }
                break;
            }
            case BEFORE_TEST_STEP: {
                if (!this.isMainTestCase() || this.isSkippedTestCase()) {
                    return;
                }
                this.safeWriteSub((Integer)testContext[0], (String)testContext[1], (String)testContext[2]);
                break;
            }
            case AFTER_TEST_STEP: {
                break;
            }
        }
    }

    private void startRecorder(WebDriver webDriver) {
        try {
            if (this.isOnBlankPage(webDriver)) {
                return;
            }
            boolean browserRecording = this.isEnableBrowserRecorder();
            String videoFileName = this.genVideoFileName();
            String folderPath = this.getVideoFolder();
            VideoConfiguration videoConfiguration = this.videoRecorderSettings.toVideoConfiguration();
            VideoRecorder newRecorder = VideoRecorderBuilder.get().setVideoConfig(videoConfiguration).setOutputDirLocation(folderPath).setOutputVideoName(videoFileName).create();
            if (!browserRecording) {
                this.videoRecorder = newRecorder;
                this.startVideoSubWriter(folderPath, videoFileName);
                this.videoRecorder.start();
            } else {
                boolean isNewTestCase;
                boolean bl = isNewTestCase = this.videoRecorder == null || !StringUtils.equals((String)this.videoRecorder.getCurrentVideoLocation(), (String)newRecorder.getCurrentVideoLocation());
                if (webDriver == null && this.videoRecorder != null && this.videoRecorder.getDelegate() instanceof CDTVideoRecorder) {
                    webDriver = ((CDTVideoRecorder)this.videoRecorder.getDelegate()).getDriver();
                }
                if (isNewTestCase) {
                    this.videoRecorder = newRecorder;
                    ((CDTVideoRecorder)this.videoRecorder.getDelegate()).setDriver(webDriver);
                    this.videoRecorder.start();
                    this.startVideoSubWriter(folderPath, videoFileName);
                } else {
                    ((CDTVideoRecorder)this.videoRecorder.getDelegate()).setDriver(webDriver);
                    this.videoRecorder.resume();
                }
            }
        }
        catch (VideoRecorderException error) {
            this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
        }
    }

    private boolean isOnBlankPage(WebDriver webDriver) {
        return webDriver != null && webDriver.getCurrentUrl() != null && webDriver.getCurrentUrl().equals("about:blank");
    }

    private String genVideoFileName() throws VideoRecorderException {
        int minimumNeeded;
        String videoFolderName = this.getVideoFolder();
        int maxOSPathLength = 255;
        if (videoFolderName.length() > maxOSPathLength) {
            throw new VideoRecorderException(String.format("Video folder path length exceeds max length %d, for: %s", maxOSPathLength, videoFolderName));
        }
        int testCaseIndex = this.lastestTestCaseContext.getTestCaseIndex();
        String testCaseName = VideoRecorderUtil.getTestCaseNameFromFullPath(this.lastestTestCaseContext.getTestCaseName());
        testCaseName = VideoRecorderUtil.cleanTestCaseName(testCaseName);
        int retryIdx = this.lastestTestCaseContext.getRetryIndex();
        String suffix = VideoRecorderUtil.getScreenRecordingNameSuffix(testCaseIndex + 1, retryIdx);
        int suffixLength = suffix.length();
        int remaining = maxOSPathLength - videoFolderName.length();
        if (remaining < (minimumNeeded = suffixLength + Math.min(25, testCaseName.length()))) {
            throw new VideoRecorderException(String.format("The combine path + filename exceeding %d characters.", maxOSPathLength));
        }
        return this.truncate(25);
    }

    private String truncate(int maxTCNameLength) throws VideoRecorderException {
        return VideoRecorderUtil.getScreenRecordingNameWithFormat(this.lastestTestCaseContext, maxTCNameLength);
    }

    private void startVideoSubWriter(String videoFolderName, String videoFileName) {
        this.screenRecorderSubWriter = new VideoSubtitleWriter(new File(videoFolderName, videoFileName).getAbsolutePath());
    }

    private void flushSubTitles() {
        this.safeWriteSub(0, null, null);
    }

    private void safeWriteSub(int stepIndex, String stepDescription, String stepName) {
        try {
            this.writeSub(stepIndex, stepDescription, stepName);
        }
        catch (IOException error) {
            this.logger.logError(ExceptionsUtil.getStackTraceForThrowable(error));
        }
    }

    private void writeSub(int stepIndex, String stepDescription, String stepName) throws IOException {
        String description = StringUtils.defaultIfEmpty((String)this.prevStepDescription, (String)this.prevStepName);
        if (StringUtils.isNotBlank((String)description) && this.screenRecorderSubWriter != null) {
            long subStartTime = Math.max(this.actionStartTime - this.getStartTime(), 0L);
            long subEndTime = Math.max(System.currentTimeMillis() - this.getStartTime(), 0L);
            if (this.getStartTime() == 0L) {
                subStartTime = 0L;
                subEndTime = 0L;
            }
            this.screenRecorderSubWriter.writeSub(subStartTime, subEndTime, String.format("%d. %s", this.prevStepIndex + 1, description));
        }
        this.prevStepIndex = stepIndex;
        this.prevStepName = stepName;
        this.prevStepDescription = stepDescription;
        this.actionStartTime = System.currentTimeMillis();
    }

    private void stopRecording() throws VideoRecorderException {
        boolean browserRecording = this.isEnableBrowserRecorder();
        if (this.videoRecorder == null || !this.videoRecorder.isStarted()) {
            return;
        }
        this.videoRecorder.stop();
        if (browserRecording) {
            if (this.isTestCaseSkipped() || this.isTestCasePassed() && !this.videoRecorderSettings.isRecordAllTestCases()) {
                this.videoRecorder.delete();
                if (this.screenRecorderSubWriter != null) {
                    this.screenRecorderSubWriter.delete();
                }
            } else {
                String videoLocation = this.videoRecorder.getCurrentVideoLocation();
                this.logVideoRecordingStep(videoLocation);
            }
        } else if (this.isTestCaseSkipped() || this.isTestCasePassed() && !this.videoRecorderSettings.isRecordAllTestCases()) {
            this.videoRecorder.delete();
            if (this.screenRecorderSubWriter != null) {
                this.screenRecorderSubWriter.delete();
            }
        } else {
            String videoLocation = this.videoRecorder.getCurrentVideoLocation();
            this.logVideoRecordingStep(videoLocation);
        }
    }

    private long getStartTime() {
        if (this.isEnableBrowserRecorder()) {
            return this.videoRecorder.getStartTime();
        }
        if (this.isEnableScreenRecorder()) {
            return this.videoRecorder.getStartTime();
        }
        return 0L;
    }

    private boolean isSkippedTestCase() {
        return this.lastestTestCaseContext != null && this.lastestTestCaseContext.isSkipped();
    }

    private boolean isMainTestCase() {
        return this.lastestTestCaseContext != null && this.lastestTestCaseContext.isMainTestCase();
    }

    private boolean isTestCaseFailed() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.FAILED;
    }

    private boolean isTestCasePassed() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.PASSED;
    }

    private boolean isTestCaseSkipped() {
        String testCaseStatus = this.lastestTestCaseContext.getTestCaseStatus();
        return TestStatus.TestStatusValue.valueOf(testCaseStatus) == TestStatus.TestStatusValue.SKIPPED;
    }

    private void logVideoRecordingStep(String videoLocation) {
        if (StringUtils.isBlank((String)videoLocation)) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("video-attachment", TestOpsUtil.getRelativePathForLog(videoLocation));
        String message = MessageFormat.format(CoreMessageConstants.EXEC_LOG_VIDEO_RECORDING_COMPLETED, this.lastestTestCaseContext.getTestCaseId());
        this.logger.startKeyword(VIDEO_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
        this.logger.logInfo(message, attributes);
        this.logger.endKeyword(VIDEO_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
    }

    private String getVideoFolder() {
        String rawPath = FilenameUtils.concat((String)this.reportFolder, (String)VIDEOS_FOLDER_NAME);
        return FilenameUtils.separatorsToSystem((String)rawPath);
    }
}

