/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.cucumber;

import com.kms.katalon.core.cucumber.CucumberSettings;
import com.kms.katalon.core.cucumber.ICucumberPreferences;
import com.kms.katalon.core.setting.BundleSettingStore;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class CucumberPreferences
extends BundleSettingStore
implements ICucumberPreferences {
    private static final String BUNDLE_ID = "com.katalon.cucumber";
    private static final String GLUES_KEY = "gluePackages";
    private static final String VALIDATE_PROJECT_KEY = "validateProject";
    private static final String GLUES_SEPARATOR = ",";

    public static CucumberPreferences forProject(String projectDir) {
        Path path = Paths.get(projectDir, new String[0]);
        if (path.toString().endsWith(".prj")) {
            path = path.getParent();
        }
        CucumberPreferences preferences = new CucumberPreferences(path.toString());
        BundleContext bundleContext = FrameworkUtil.getBundle(CucumberPreferences.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)preferences, (IEclipseContext)context);
        return preferences;
    }

    public CucumberPreferences(String projectDir) {
        super(projectDir, BUNDLE_ID, false);
    }

    @Override
    public CucumberSettings loadSettings() throws IOException {
        String gluesString = this.getString(GLUES_KEY, "");
        List<String> glues = Stream.of(StringUtils.split((String)gluesString, (String)GLUES_SEPARATOR)).filter(StringUtils::isNotBlank).toList();
        boolean validateProject = this.getBoolean(VALIDATE_PROJECT_KEY, false);
        CucumberSettings settings = new CucumberSettings();
        settings.setGluePackages(glues);
        settings.setValidateProject(validateProject);
        return settings;
    }

    @Override
    public void saveSettings(CucumberSettings settings) throws IOException {
        this.setProperty(GLUES_KEY, StringUtils.join(settings.getGluePackages(), (String)GLUES_SEPARATOR));
        this.setProperty(VALIDATE_PROJECT_KEY, settings.isValidateProject());
    }
}

