/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.enums.mobile;

import com.kms.katalon.core.enums.mobile.MobilePlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum LocatorStrategy {
    ATTRIBUTES("Attributes"),
    ACCESSIBILITY("Accessibility ID"),
    CLASS_NAME("Class Name"),
    ID("ID"),
    NAME("Name"),
    XPATH("XPATH"),
    IMAGE("Image"),
    ANDROID_VIEWTAG("Android View Tag"),
    ANDROID_UI_AUTOMATOR("Android UI Automator"),
    IOS_PREDICATE_STRING("iOS Predicate String"),
    IOS_CLASS_CHAIN("iOS Class Chain"),
    CUSTOM("Custom");

    private final String name;

    private LocatorStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static List<LocatorStrategy> getLocatorStrategies() {
        return new ArrayList<LocatorStrategy>(Arrays.asList(LocatorStrategy.values()));
    }

    public static String[] getStrategyNames() {
        ArrayList<String> strategies = new ArrayList<String>();
        LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
        int n = locatorStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocatorStrategy str = locatorStrategyArray[n2];
            strategies.add(str.getName());
            ++n2;
        }
        return strategies.toArray(new String[0]);
    }

    public static List<LocatorStrategy> getLocatorStrategies(MobilePlatform platform) {
        if (MobilePlatform.ANDROID.equals((Object)platform)) {
            return LocatorStrategy.getLocatorStrategies().stream().filter(s -> !IOS_CLASS_CHAIN.equals(s) && !IOS_PREDICATE_STRING.equals(s)).collect(Collectors.toList());
        }
        if (MobilePlatform.IOS.equals((Object)platform)) {
            return LocatorStrategy.getLocatorStrategies().stream().filter(s -> !ANDROID_UI_AUTOMATOR.equals(s) && !ANDROID_VIEWTAG.equals(s)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static LocatorStrategy valueOfStrategy(String strategy) {
        if (StringUtils.isEmpty((CharSequence)strategy)) {
            return null;
        }
        LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
        int n = locatorStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocatorStrategy str = locatorStrategyArray[n2];
            if (StringUtils.equalsIgnoreCase((CharSequence)str.getName(), (CharSequence)strategy)) {
                return str;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Strategy: " + strategy + " not found");
    }
}

