/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.core.event.TestingEvent;
import com.kms.katalon.core.execution.TestExecutionStringUtil;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testcase.BrokenTestCaseSummary;
import com.kms.katalon.core.util.internal.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v143.page.Page;

public class ChromeSnapshotHelper {
    protected final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private WebDriver driver;

    public ChromeSnapshotHelper() {
        EventBusSingleton.getInstance().getEventBus().register((Object)this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onTestingEvent(TestingEvent event) {
        switch (event.getType()) {
            case BROWSER_OPENED: {
                if (!this.isEnableTimeCapsule()) break;
                this.driver = (WebDriver)event.getData();
                break;
            }
        }
    }

    private boolean isEnableTimeCapsule() {
        return RunConfiguration.shouldApplyTimeCapsule();
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    /*
     * WARNING - void declaration
     */
    public String captureSnapshot(String testArtifactFolderPath, String testName) {
        void hasDevTools;
        WebDriver webDriver;
        String pathToMHTML = this.generateMHTMLPath(testArtifactFolderPath, testName);
        if (this.driver == null || !((webDriver = this.driver) instanceof HasDevTools)) {
            return null;
        }
        HasDevTools hasDevTools2 = (HasDevTools)webDriver;
        DevTools devTools = hasDevTools.getDevTools();
        devTools.createSession();
        devTools.send(Page.enable(Optional.empty()));
        devTools.send(Page.captureSnapshot(Optional.empty()));
        String dataOfMHTML = (String)devTools.send(Page.captureSnapshot(Optional.empty()));
        this.writeFile(pathToMHTML, dataOfMHTML);
        String mhtmlPathRelativeToProjectFolder = this.getPathRelativeToProjectFolder(pathToMHTML);
        this.logger.logInfo("Time Capsule is available at " + mhtmlPathRelativeToProjectFolder);
        return pathToMHTML;
    }

    private String generateMHTMLPath(String folderToStoreMhtml, String testName) {
        String unoffensiveTestCaseName = TestExecutionStringUtil.getUnoffensiveTestCaseName(testName);
        return folderToStoreMhtml + File.separator + unoffensiveTestCaseName + "." + BrokenTestCaseSummary.Constants.MHTML_EXTENSION;
    }

    private void writeFile(String fileName, String data) {
        try {
            File file = new File(fileName);
            file.createNewFile();
            FileUtils.writeStringToFile((File)file, (String)data);
        }
        catch (IOException | NullPointerException exception) {
            this.logger.logWarning(exception.getMessage());
        }
    }

    private String getPathRelativeToProjectFolder(String absolutePath) {
        String base = RunConfiguration.getProjectDir();
        return PathUtil.absoluteToRelativePath(absolutePath, base);
    }
}

