/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LogRecordHelper {
    private LogRecordHelper() {
    }

    public static int getLogRecordIndex(ILogRecord logRecord) {
        return LogRecordHelper.getOrder(logRecord);
    }

    public static List<ILogRecord> reduceRawLogRecords(TestSuiteLogRecord testSuiteRecord, ILogRecord[] logRecords) {
        ArrayList<ILogRecord> testCases = new ArrayList<ILogRecord>();
        int i = 0;
        while (i < logRecords.length) {
            ILogRecord logRecordI = logRecords[i];
            if (logRecordI instanceof TestCaseGroupLogRecord) {
                testCases.add(logRecordI);
            } else {
                boolean isRetryResult;
                ILogRecord prevTestCase = testCases.size() > 0 ? (ILogRecord)testCases.get(testCases.size() - 1) : null;
                boolean bl = isRetryResult = LogRecordHelper.getRetryCount(logRecordI) > 0;
                if (prevTestCase != null && isRetryResult) {
                    prevTestCase.addChildRecord(logRecordI);
                } else {
                    int groupIndex = testCases.size();
                    testCases.add(new TestCaseGroupLogRecord(testSuiteRecord, logRecordI, groupIndex));
                }
            }
            ++i;
        }
        return testCases;
    }

    private static int getOrder(ILogRecord logRecord) {
        if (logRecord instanceof TestCaseGroupLogRecord) {
            return ((TestCaseGroupLogRecord)logRecord).getIndexInReport();
        }
        if (logRecord instanceof TestCaseLogRecord) {
            return LogRecordHelper.getOrder(logRecord.getParentLogRecord());
        }
        return -1;
    }

    public static int getRetryCount(ILogRecord logRecord) {
        return LogRecordHelper.getIntProperty(logRecord, "currentRetryCount");
    }

    public static long getLongProperty(ILogRecord logRecord, String property) {
        String value = LogRecordHelper.getProperty(logRecord, property);
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : 0L;
    }

    public static int getIntProperty(ILogRecord logRecord, String property) {
        String value = LogRecordHelper.getProperty(logRecord, property);
        return StringUtils.isNotBlank((CharSequence)value) ? Integer.valueOf(value) : 0;
    }

    public static String getProperty(ILogRecord logRecord, String property) {
        Map<String, String> props = LogRecordHelper.getProperties(logRecord);
        if (props == null) {
            return null;
        }
        return props.getOrDefault(property, null);
    }

    public static void setProperty(ILogRecord logRecord, String property, Object value) {
        Map<String, String> props = LogRecordHelper.getProperties(logRecord);
        if (props == null) {
            return;
        }
        props.put(property, String.valueOf(value));
    }

    public static Map<String, String> getProperties(ILogRecord logRecord) {
        if (!(logRecord instanceof AbstractLogRecord)) {
            return null;
        }
        return ((AbstractLogRecord)logRecord).getProperties();
    }
}

