/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenrecorder;

import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.helper.screenrecorder.AbstractVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoConfiguration;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v143.page.Page;
import org.openqa.selenium.devtools.v143.page.model.ScreencastFrame;

public class CDTVideoRecorder
extends AbstractVideoRecorder {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private static final String FRAME_DURATIONS_FILE = "durations.txt";
    private static final String FRAME_NAME_PATTERN = "frame-%d.jpg";
    private static final String VIDEO_NAME_PATTERN = "{0}{1}";
    private String outputDirLocation;
    private String outputVideoName;
    private String framesFolder;
    private WebDriver driver;
    private DevTools devTools;
    double startTimestamp = 0.0;
    double lastFrameTimestamp = 0.0;
    long numFrames = 0L;
    Point videoSize = new Point(0, 0);
    Process ffmpegProcess;
    File inputFile;

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public CDTVideoRecorder(String outputDirLocation, String outputVideoName, VideoConfiguration videoConfig) {
        this.outputDirLocation = outputDirLocation;
        this.outputVideoName = outputVideoName;
        this.videoConfig = videoConfig;
    }

    @Override
    public void start() throws VideoRecorderException {
        if (this.isStarted()) {
            return;
        }
        WebDriver webDriver = this.driver = this.isAlive(this.driver) ? this.driver : this.findActiveDriver();
        if (this.driver == null) {
            this.logger.logWarning(CoreMessageConstants.MSG_ERR_NO_DRIVER_FOUND);
            return;
        }
        if (!ConsoleCommandExecutor.test("ffmpeg")) {
            this.logger.logWarning(MessageFormat.format(CoreMessageConstants.MSG_ERR_FFMPEG_NOT_INSTALLED, DocumentationMessageConstants.BROWSER_BASED_RECORDER));
            return;
        }
        this.startCDTRecording();
        this.started = true;
    }

    @Override
    public void resume() throws VideoRecorderException {
        this.start();
    }

    private WebDriver findActiveDriver() {
        Object[] drivers;
        Object[] objectArray = drivers = RunConfiguration.getStoredDrivers();
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            Object driverI = objectArray[n2];
            if (driverI instanceof WebDriver && this.isAlive((WebDriver)driverI)) {
                return (WebDriver)driverI;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void startCDTRecording() {
        void hasDevTools;
        WebDriver webDriver;
        if (this.driver == null || !((webDriver = this.driver) instanceof HasDevTools)) {
            return;
        }
        HasDevTools hasDevTools2 = (HasDevTools)webDriver;
        DevTools dt = hasDevTools.getDevTools();
        dt.createSession();
        this.devTools = dt;
        this.devTools.send(Page.enable(Optional.empty()));
        this.devTools.addListener(Page.screencastFrame(), frame -> this.handleScreencastFrame((ScreencastFrame)frame));
        this.devTools.send(Page.startScreencast(Optional.of(Page.StartScreencastFormat.JPEG), Optional.of(100), Optional.empty(), Optional.empty(), Optional.of(1)));
    }

    private void handleScreencastFrame(ScreencastFrame frame) {
        this.devTools.send(Page.screencastFrameAck((Integer)frame.getSessionId()));
        ++this.numFrames;
        Double frameTimestamp = frame.getMetadata().getTimestamp().map(t -> t.toJson().doubleValue()).orElse(0.0);
        if (this.startTimestamp == 0.0) {
            this.startTimestamp = frameTimestamp;
            this.startTime = System.currentTimeMillis();
            this.inputFile = new File(this.getFramesFolder(), FRAME_DURATIONS_FILE);
        }
        if (this.lastFrameTimestamp == 0.0) {
            this.lastFrameTimestamp = frameTimestamp;
        }
        this.dumpFrameTime(frameTimestamp);
        this.videoSize = new Point(Math.max(this.videoSize.x, frame.getMetadata().getDeviceWidth().intValue()), Math.max(this.videoSize.y, frame.getMetadata().getDeviceHeight().intValue()));
        try {
            try {
                CDTVideoRecorder.storeFrame(this.getFramePath(this.numFrames), frame.getData());
                this.storeFrameDuration(frameTimestamp, this.numFrames);
            }
            catch (VideoRecorderException | IOException error) {
                this.logger.logError(ExceptionUtils.getFullStackTrace((Throwable)error));
                this.lastFrameTimestamp = frameTimestamp;
            }
        }
        finally {
            this.lastFrameTimestamp = frameTimestamp;
        }
    }

    @Override
    public void stop() throws VideoRecorderException {
        this.stopScreencast();
        this.saveRecording();
        this.removeTempData();
        this.started = false;
    }

    private void stopScreencast() {
        if (this.devTools != null && this.isStarted()) {
            try {
                if (this.isAlive(this.driver)) {
                    this.devTools.send(Page.stopScreencast());
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isAlive(WebDriver driver) {
        try {
            driver.getTitle();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void saveRecording() throws VideoRecorderException {
        if (this.devTools != null && this.isStarted()) {
            try {
                File frameFolder;
                File videoFolder = new File(this.getVideoFolder());
                if (!videoFolder.exists()) {
                    videoFolder.mkdirs();
                }
                if (!(frameFolder = new File(this.getFramesFolder())).exists()) {
                    frameFolder.mkdirs();
                }
                int evenWidth = this.videoSize.x % 2 == 0 ? this.videoSize.x : this.videoSize.x + 1;
                int eventHeight = this.videoSize.y % 2 == 0 ? this.videoSize.y : this.videoSize.y + 1;
                String ffmpegCommandPattern = "ffmpeg -y -f concat -i \"{0}\" -vf \"scale={1,number,#}:{2,number,#}\" {3} {4} -pix_fmt yuv420p \"{5}\"";
                String ffmpegCommand = MessageFormat.format(ffmpegCommandPattern, FRAME_DURATIONS_FILE, evenWidth, eventHeight, this.getVideoCodec(), this.getVideoQuality(), this.getVideoPath());
                ConsoleCommandExecutor.execSync(ffmpegCommand, frameFolder.getPath());
            }
            catch (Exception error) {
                throw new VideoRecorderException(error);
            }
        }
    }

    private void removeTempData() {
        try {
            FileUtils.deleteDirectory((File)new File(this.getFramesFolder()));
        }
        catch (IOException iOException) {}
    }

    @Override
    public void reload() throws VideoRecorderException {
        if (this.isStarted()) {
            this.stop();
        }
        this.resetVariables();
        this.start();
    }

    private void resetVariables() {
        this.devTools = null;
        this.startTimestamp = 0.0;
        this.lastFrameTimestamp = 0.0;
        this.numFrames = 0L;
        this.videoSize = new Point(0, 0);
    }

    @Override
    public void delete() {
        File videoFile = new File(this.getVideoPath());
        if (videoFile.exists()) {
            FileUtils.deleteQuietly((File)videoFile);
        }
    }

    public static void storeFrame(String fileName, String base64Data) throws VideoRecorderException {
        try {
            File file = new File(fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(Base64.getDecoder().decode(base64Data));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException error) {
            throw new VideoRecorderException(error);
        }
    }

    private void storeFrameDuration(double frameTimestamp, long frameNumber) throws IOException {
        double frameDuration = frameTimestamp - this.lastFrameTimestamp;
        if (frameDuration > 0.0) {
            Locale currentLocale = Locale.getDefault();
            Locale.setDefault(Locale.US);
            String durationLine = MessageFormat.format("duration {0,number,#.###}\n", frameDuration);
            FileUtils.write((File)this.inputFile, (CharSequence)durationLine, (boolean)true);
            Locale.setDefault(currentLocale);
        }
        String frameLine = MessageFormat.format("file ''{0}''\n", this.getFrameName(frameNumber));
        FileUtils.write((File)this.inputFile, (CharSequence)frameLine, (boolean)true);
    }

    private void dumpFrameTime(double frameTimestamp) {
        double dif = frameTimestamp - this.lastFrameTimestamp;
        String frameTimeInfo = MessageFormat.format("Frame {0} ({1}ms)", this.numFrames, dif * 1000.0);
        this.logger.logDebug(frameTimeInfo);
    }

    @Override
    public String getCurrentVideoLocation() {
        return this.getVideoPath();
    }

    private String getVideoName() {
        VideoFileFormat videoFormat = this.videoConfig.getVideoFormat();
        return MessageFormat.format(VIDEO_NAME_PATTERN, this.outputVideoName, videoFormat.getExtension());
    }

    public String getOutputVideoName() {
        return this.outputVideoName;
    }

    public void setOutputVideoName(String outputVideoName) {
        this.outputVideoName = outputVideoName;
    }

    private String getVideoFolder() {
        return this.outputDirLocation;
    }

    private String getVideoPath() {
        return FilenameUtils.concat((String)this.getVideoFolder(), (String)this.getVideoName());
    }

    private String getFramesFolder() {
        if (StringUtils.isBlank((CharSequence)this.framesFolder)) {
            this.framesFolder = FilenameUtils.concat((String)VIDEO_TEMP_LOCATION, (String)("frames-" + new Date().getTime()));
        }
        return this.framesFolder;
    }

    private String getFrameName(long frameNumber) {
        return String.format(FRAME_NAME_PATTERN, frameNumber);
    }

    private String getFramePath(long frameNumber) {
        String frameName = this.getFrameName(frameNumber);
        return Paths.get(this.getFramesFolder(), frameName).toString();
    }

    private String getVideoCodec() {
        VideoFileFormat videoFormat = this.videoConfig.getVideoFormat();
        switch (videoFormat) {
            case WEBM: {
                return "-c:v libvpx-vp9";
            }
            case AVI: {
                return "-c:v libxvid";
            }
        }
        return "-c:v libx264";
    }

    private String getVideoQuality() {
        HashMap<VideoQuality, Map<VideoFileFormat, String>> qualityFormatMap = new HashMap<VideoQuality, Map<VideoFileFormat, String>>();
        qualityFormatMap.put(VideoQuality.LOW, Map.of(VideoFileFormat.WEBM, "-crf 40", VideoFileFormat.AVI, "-q:v 20"));
        qualityFormatMap.put(VideoQuality.MEDIUM, Map.of(VideoFileFormat.WEBM, "-crf 30", VideoFileFormat.AVI, "-q:v 5"));
        qualityFormatMap.put(VideoQuality.HIGH, Map.of(VideoFileFormat.WEBM, "-crf 20", VideoFileFormat.AVI, "-q:v 2"));
        Map<VideoQuality, String> defaultSettings = Map.of(VideoQuality.LOW, "-crf 28", VideoQuality.MEDIUM, "-crf 23", VideoQuality.HIGH, "-crf 18");
        VideoQuality videoQuality = this.videoConfig.getVideoQuality();
        VideoFileFormat videoFormat = this.videoConfig.getVideoFormat();
        return ((Map)qualityFormatMap.getOrDefault((Object)videoQuality, new HashMap())).getOrDefault((Object)videoFormat, defaultSettings.get((Object)videoQuality));
    }
}

