/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.keyword.internal;

import java.util.HashMap;
import java.util.Map;

public class KeywordExecutionContext {
    private static final String TESTNG_PLATFORM_NAME = "testng";
    private static final String CUCUMBER_PLATFORM_NAME = "cucumber";
    private static final Map<String, String> PLATFORM_NAME_MAP = new HashMap<String, String>();
    private static String runningKeyword;
    private static String runningPlatform;
    private static boolean hasHealedSomeObjects;
    private static boolean isUsingApplitools;
    private static Map<String, Boolean> keywordsUsage;
    private static Map<String, Integer> executedKeywords;

    static {
        PLATFORM_NAME_MAP.put("builtin", "builtin");
        PLATFORM_NAME_MAP.put("web", "web_ui");
        PLATFORM_NAME_MAP.put("mobile", "mobile");
        PLATFORM_NAME_MAP.put("windows", "windows");
        PLATFORM_NAME_MAP.put("webservice", "web_service");
        hasHealedSomeObjects = false;
        keywordsUsage = new HashMap<String, Boolean>();
        KeywordExecutionContext.markKeywordsUsage("builtin", false);
        KeywordExecutionContext.markKeywordsUsage("web", false);
        KeywordExecutionContext.markKeywordsUsage("mobile", false);
        KeywordExecutionContext.markKeywordsUsage("windows", false);
        KeywordExecutionContext.markKeywordsUsage("webservice", false);
        KeywordExecutionContext.markKeywordsUsage(TESTNG_PLATFORM_NAME, false);
        KeywordExecutionContext.markKeywordsUsage(CUCUMBER_PLATFORM_NAME, false);
        executedKeywords = new HashMap<String, Integer>();
    }

    public static void saveRunningKeywordAndPlatform(String runningPlatform, String runningKeyword) {
        KeywordExecutionContext.runningPlatform = runningPlatform;
        KeywordExecutionContext.runningKeyword = runningKeyword;
    }

    public static String getRunningKeyword() {
        return runningKeyword;
    }

    public static void setRunningKeyword(String runningKeyword) {
        KeywordExecutionContext.runningKeyword = runningKeyword;
    }

    public static String getRunningPlatform() {
        return runningPlatform;
    }

    public static void setRunningPlatform(String runningPlatform) {
        KeywordExecutionContext.runningPlatform = runningPlatform;
    }

    public static boolean isRunningWebUI() {
        return runningPlatform.equals("web");
    }

    public static boolean isRunningMobile() {
        return runningPlatform.equals("mobile");
    }

    public static boolean hasHealedSomeObjects() {
        return hasHealedSomeObjects;
    }

    public static void setHasHealedSomeObjects(boolean hasHealedSomeObjects) {
        KeywordExecutionContext.hasHealedSomeObjects = hasHealedSomeObjects;
    }

    public static void resetKeywordsUsage() {
        PLATFORM_NAME_MAP.forEach((platform, hasUsage) -> KeywordExecutionContext.markKeywordsUsage(platform, false));
        KeywordExecutionContext.resetExecutedKeywords();
    }

    public static void markKeywordsUsage(String platform) {
        KeywordExecutionContext.markKeywordsUsage(platform, true);
    }

    public static void markKeywordsUsage(String platform, boolean hasUsed) {
        String truePlatform = PLATFORM_NAME_MAP.containsKey(platform) ? PLATFORM_NAME_MAP.get(platform) : platform;
        keywordsUsage.put(truePlatform, hasUsed);
    }

    public static Map<String, Boolean> getKeywordsUsage() {
        return keywordsUsage;
    }

    public static void setUsingApplitools(boolean isUsingApplitools) {
        KeywordExecutionContext.isUsingApplitools = isUsingApplitools;
    }

    public static boolean isUsingApplitools() {
        return isUsingApplitools;
    }

    public static void resetUsingApplitools() {
        isUsingApplitools = false;
    }

    public static void resetExecutedKeywords() {
        executedKeywords.clear();
    }

    public static Map<String, Integer> getExecutedKeywords() {
        return new HashMap<String, Integer>(executedKeywords);
    }

    public static void addExecutedKeyword(String keywordName) {
        executedKeywords.put(keywordName, executedKeywords.getOrDefault(keywordName, 0) + 1);
    }

    public static Map<String, String> getPlatformName() {
        Map<String, String> platform = PLATFORM_NAME_MAP;
        platform.put(TESTNG_PLATFORM_NAME, TESTNG_PLATFORM_NAME);
        platform.put(CUCUMBER_PLATFORM_NAME, CUCUMBER_PLATFORM_NAME);
        return platform;
    }
}

