/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.google.common.base.Optional;
import com.kms.katalon.core.annotation.SetUp;
import com.kms.katalon.core.annotation.SetupTestCase;
import com.kms.katalon.core.annotation.TearDown;
import com.kms.katalon.core.annotation.TearDownIfError;
import com.kms.katalon.core.annotation.TearDownIfFailed;
import com.kms.katalon.core.annotation.TearDownIfPassed;
import com.kms.katalon.core.annotation.TearDownTestCase;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.driver.internal.DriverCleanerCollector;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.ChromeSnapshotHelper;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.main.RetrySettings;
import com.kms.katalon.core.main.RetrySettingsImpl;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseMain;
import com.kms.katalon.core.main.TestCaseMethodNodeCollector;
import com.kms.katalon.core.main.TestCaseMethodNodeWrapper;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.main.TestSuiteExecutor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.testcase.VariableReport;
import com.kms.katalon.core.util.BrowserMobProxyManager;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import groovy.lang.Binding;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;

public class TestCaseExecutor {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private static ErrorCollector errorCollector = ErrorCollector.getCollector();
    protected TestResult testCaseResult;
    private TestCase testCase;
    private Stack<KeywordLogger.KeywordStackElement> keywordStack;
    private TestCaseMethodNodeCollector methodNodeCollector;
    private List<Throwable> parentErrors;
    protected ScriptEngine engine;
    protected Binding variableBinding;
    private TestCaseBinding testCaseBinding;
    private ExecutionEventManager eventManager;
    private boolean doCleanUp;
    private InternalTestCaseContext testCaseContext;
    private TestSuiteExecutor testSuiteExecutor;
    private RetrySettings retrySettings;
    private ChromeSnapshotHelper chromeSnapshotTool;
    private List<VariableReport> dataBindingReport = new ArrayList<VariableReport>();
    private List<String> secureValues = new ArrayList<String>();
    private Pattern secureProtectedGlobalValuesPattern;
    private Pattern secureValuesPattern;
    PrintStream originalOutStream = System.out;
    PrintStream originalErrStream = System.err;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue;

    public void setTestSuiteExecutor(TestSuiteExecutor testSuiteExecutor) {
        this.testSuiteExecutor = testSuiteExecutor;
    }

    public TestCaseExecutor(TestCaseBinding testCaseBinding, ScriptEngine engine, ExecutionEventManager eventManager, InternalTestCaseContext testCaseContext, boolean doCleanUp) {
        this.testCaseBinding = testCaseBinding;
        this.engine = engine;
        this.testCase = TestCaseFactory.findTestCase(testCaseBinding.getTestCaseId());
        this.doCleanUp = doCleanUp;
        this.eventManager = eventManager;
        this.testCaseContext = testCaseContext;
        this.chromeSnapshotTool = new ChromeSnapshotHelper();
        this.getIterationValueByIterationName();
    }

    public TestCaseExecutor(TestCaseBinding testCaseBinding, ScriptEngine engine, ExecutionEventManager eventManager, InternalTestCaseContext testCaseContext) {
        this(testCaseBinding, engine, eventManager, testCaseContext, false);
    }

    private void preExecution() {
        this.secureValues.clear();
        Map<Object, Object> protectedGlobalVariables = Collections.emptyMap();
        try {
            protectedGlobalVariables = TestCaseMain.getProtectedGlobalVariables();
        }
        catch (Exception e) {
            this.logger.logWarning("Failed to retrieve protected global variables: " + e.getMessage(), null, e);
        }
        for (Map.Entry<Object, Object> entry : protectedGlobalVariables.entrySet()) {
            Object value = protectedGlobalVariables.get(entry.getKey());
            if (value == null) continue;
            String trimmed = String.valueOf(value).trim();
            trimmed = trimmed.replaceAll("^'|'$", "");
            this.addSecureValue(trimmed);
        }
        this.secureValuesPattern = this.generateSecureValuesPattern(this.secureValues);
        this.logger.setSecureValuesPattern(this.secureValuesPattern);
        System.setOut(new PrintStream(new InterceptingOutputStream(System.out)));
        System.setErr(new PrintStream(new InterceptingOutputStream(System.err)));
        this.testCaseResult = TestResult.getDefault();
        this.keywordStack = new Stack();
        this.parentErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();
        int suiteRetry = RunConfiguration.getSuiteRerunIndex();
        if (suiteRetry > this.testCaseContext.getRetryIndex()) {
            this.testCaseContext.setRetryIndex(suiteRetry);
        }
        if (this.testCaseContext.isMainTestCase()) {
            KeywordExecutionContext.setHasHealedSomeObjects(false);
            KeywordExecutionContext.resetKeywordsUsage();
            KeywordExecutionContext.resetUsingApplitools();
        }
    }

    private void onExecutionComplete() {
        this.endAllUnfinishedKeywords(this.keywordStack);
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDownIfPassed.class));
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
        this.logger.logPassed(this.testCase.getTestCaseId());
    }

    private void onExecutionError(Throwable t) {
        String stackTraceForThrowable;
        if (!this.keywordStack.isEmpty()) {
            this.logErrorForTheLastError();
            this.endAllUnfinishedKeywords(this.keywordStack);
        }
        this.testCaseResult.setCause(t);
        this.testCaseResult.getTestStatus().setStatusValue(this.getResultByError(t));
        try {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        catch (Exception exception) {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, this.testCase.getTestCaseId(), stackTraceForThrowable);
        this.testCaseResult.setMessage(message);
        this.logError(t, message);
        this.runTearDownMethodByError(t);
    }

    private void logErrorForTheLastError() {
        String stackTraceForThrowable;
        if (!errorCollector.containsErrors()) {
            return;
        }
        Throwable t = errorCollector.getLastError();
        try {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        catch (Exception exception) {
            stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable(t);
        }
        String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, this.testCase.getTestCaseId(), stackTraceForThrowable);
        if (!(t instanceof StepFailedException)) {
            this.logError(t, message);
        }
    }

    private boolean processScriptPreparationPhase() {
        try {
            this.methodNodeCollector = new TestCaseMethodNodeCollector(this.testCase);
        }
        catch (IOException ioException) {
            this.onSetupError(ioException);
            return false;
        }
        catch (MultipleCompilationErrorsException multiCompilationErrException) {
            this.onSetupError(multiCompilationErrException);
            return false;
        }
        try {
            this.variableBinding = this.collectTestCaseVariables();
        }
        catch (CompilationFailedException e) {
            this.onSetupError(e);
            return false;
        }
        return true;
    }

    private boolean processSetupPhase() {
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(SetUp.class));
        boolean setupFailed = errorCollector.containsErrors();
        if (setupFailed) {
            this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDownIfError.class));
            this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
            this.onSetupError(errorCollector.getFirstError());
        }
        return !setupFailed;
    }

    protected File getScriptFile() throws IOException {
        return new File(this.testCase.getGroovyScriptPath());
    }

    private void onSetupError(Throwable t) {
        String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_ERROR_BECAUSE_OF, this.testCase.getTestCaseId(), ExceptionsUtil.getMessageForThrowable(t));
        this.testCaseResult.setMessage(message);
        this.testCaseResult.getTestStatus().setStatusValue(TestStatus.TestStatusValue.ERROR);
        this.logger.logError(message, null, t);
    }

    private void postExecution() {
        boolean hasHealedSomeObjects = KeywordExecutionContext.hasHealedSomeObjects();
        if (hasHealedSomeObjects && (RunConfiguration.shouldApplySelfHealing().booleanValue() || RunConfiguration.shouldApplySelfHealingForMobile().booleanValue())) {
            this.logger.logInfo("");
            this.logger.logInfo("===================== Self-healing Report ====================");
            this.logger.logInfo(StringConstants.SELF_HEALING_REPORT_VISIT_INSIGHT_PART);
            this.logger.logInfo(StringConstants.SELF_HEALING_REFER_TO_DOCUMENT);
            this.logger.logInfo("==============================================================");
        }
        errorCollector.clearErrors();
        errorCollector.getErrors().addAll(0, this.parentErrors);
        if (this.testCaseContext.isMainTestCase()) {
            BrowserMobProxyManager.shutdownProxy();
        }
        System.setOut(this.originalOutStream);
        System.setErr(this.originalErrStream);
    }

    /*
     * Unable to fully structure code
     */
    public TestResult execute(FailureHandling flowControl) {
        block66: {
            block64: {
                block65: {
                    block63: {
                        initialTestCaseBindedValues = new HashMap<String, Object>((Map)Optional.fromNullable(this.testCaseBinding.getBindedValues()).or(new HashMap<K, V>()));
                        try {
                            this.preExecution();
                            testCaseProperties = this.getTestCaseProperties(this.testCaseBinding, this.testCase, flowControl);
                            if (this.testCaseContext.isMainTestCase()) {
                                this.logger.startTest(this.testCase.getTestCaseId(), testCaseProperties, this.keywordStack);
                            } else {
                                this.logger.startCalledTest(this.testCase.getTestCaseId(), testCaseProperties, this.keywordStack);
                            }
                            if (!this.hasTestCaseScript()) ** GOTO lbl132
                            if (this.processScriptPreparationPhase()) break block63;
                            var6_4 = this.testCaseResult;
                        }
                        catch (Throwable var5_33) {
                            if (!this.testCaseResult.getTestStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.PASSED) && RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
                                logFolderPath = this.logger.getLogFolderPath();
                                testArtifactFolderPath = StringUtils.isEmpty((CharSequence)logFolderPath) != false ? RunConfiguration.getProjectDir() : logFolderPath;
                                try {
                                    this.chromeSnapshotTool.captureSnapshot(testArtifactFolderPath, this.testCaseContext.getTestCaseId());
                                }
                                catch (Exception error) {
                                    this.logger.logWarning(error.getMessage(), null, error);
                                }
                            }
                            this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                            this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                            if (this.testCaseContext.isMainTestCase()) {
                                this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                            }
                            shouldRetry = false;
                            if (this.testCaseContext.isMainTestCase()) {
                                if (this.testCaseContext.isSkipped()) {
                                    this.logger.logSkipped(this.testCaseResult.getMessage());
                                } else {
                                    testCaseStatus = this.testCaseResult.getTestStatus().getStatusValue();
                                    switch (TestCaseExecutor.$SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue()[testCaseStatus.ordinal()]) {
                                        case 3: 
                                        case 5: {
                                            if (this.retrySettings != null && this.retrySettings.getRemainingRetryCount() > 0) {
                                                shouldRetry = true;
                                            }
                                            if (this.testSuiteExecutor == null) break;
                                            this.testSuiteExecutor.updateFailedThreshold();
                                        }
                                    }
                                }
                                attributes = new HashMap<String, String>();
                                if (this.retrySettings != null) {
                                    attributes.put("currentRetryCount", Integer.toString(this.retrySettings.getCurrentRetryCount()));
                                    attributes.put("remainingRetryCount", Integer.toString(this.retrySettings.getRemainingRetryCount()));
                                }
                                keywordsUsage = KeywordExecutionContext.getKeywordsUsage();
                                attributes.put("keywordsUsage", JsonUtil.toJson(keywordsUsage));
                                executedKeywords = KeywordExecutionContext.getExecutedKeywords();
                                attributes.put("executedKeywords", JsonUtil.toJson(executedKeywords));
                                attributes.put("applitools", String.valueOf(KeywordExecutionContext.isUsingApplitools()));
                                attributes.put("executionBindingVariables", JsonUtil.toJson(this.dataBindingReport));
                                this.logger.endTest(this.testCase.getTestCaseId(), attributes);
                            } else {
                                this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                            }
                            this.postExecution();
                            if (shouldRetry && this.testSuiteExecutor != null && !this.testSuiteExecutor.reachFailedThreshold()) {
                                this.testCaseContext.setRetryIndex(this.retrySettings.getCurrentRetryCount() + 1);
                                this.testCaseBinding.setBindedValues(initialTestCaseBindedValues);
                                executor = new TestCaseExecutor(this.testCaseBinding, this.engine, this.eventManager, this.testCaseContext, this.doCleanUp);
                                newRetry = new RetrySettingsImpl();
                                newRetry.setCurrentRetryCount(this.retrySettings.getCurrentRetryCount() + 1);
                                newRetry.setRemainingRetryCount(this.retrySettings.getRemainingRetryCount() - 1);
                                executor.setRetrySettings(newRetry);
                                executor.setTestSuiteExecutor(this.testSuiteExecutor);
                                executor.execute(flowControl);
                            }
                            throw var5_33;
                        }
                        if (!this.testCaseResult.getTestStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.PASSED) && RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
                            logFolderPath = this.logger.getLogFolderPath();
                            testArtifactFolderPath = StringUtils.isEmpty((CharSequence)logFolderPath) != false ? RunConfiguration.getProjectDir() : logFolderPath;
                            try {
                                this.chromeSnapshotTool.captureSnapshot(testArtifactFolderPath, this.testCaseContext.getTestCaseId());
                            }
                            catch (Exception error) {
                                this.logger.logWarning(error.getMessage(), null, error);
                            }
                        }
                        this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                        this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                        if (this.testCaseContext.isMainTestCase()) {
                            this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                        }
                        shouldRetry = false;
                        if (this.testCaseContext.isMainTestCase()) {
                            if (this.testCaseContext.isSkipped()) {
                                this.logger.logSkipped(this.testCaseResult.getMessage());
                            } else {
                                testCaseStatus = this.testCaseResult.getTestStatus().getStatusValue();
                                switch (TestCaseExecutor.$SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue()[testCaseStatus.ordinal()]) {
                                    case 3: 
                                    case 5: {
                                        if (this.retrySettings != null && this.retrySettings.getRemainingRetryCount() > 0) {
                                            shouldRetry = true;
                                        }
                                        if (this.testSuiteExecutor == null) break;
                                        this.testSuiteExecutor.updateFailedThreshold();
                                    }
                                }
                            }
                            attributes = new HashMap<String, String>();
                            if (this.retrySettings != null) {
                                attributes.put("currentRetryCount", Integer.toString(this.retrySettings.getCurrentRetryCount()));
                                attributes.put("remainingRetryCount", Integer.toString(this.retrySettings.getRemainingRetryCount()));
                            }
                            keywordsUsage = KeywordExecutionContext.getKeywordsUsage();
                            attributes.put("keywordsUsage", JsonUtil.toJson(keywordsUsage));
                            executedKeywords = KeywordExecutionContext.getExecutedKeywords();
                            attributes.put("executedKeywords", JsonUtil.toJson(executedKeywords));
                            attributes.put("applitools", String.valueOf(KeywordExecutionContext.isUsingApplitools()));
                            attributes.put("executionBindingVariables", JsonUtil.toJson(this.dataBindingReport));
                            this.logger.endTest(this.testCase.getTestCaseId(), attributes);
                        } else {
                            this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                        }
                        this.postExecution();
                        if (shouldRetry && this.testSuiteExecutor != null && !this.testSuiteExecutor.reachFailedThreshold()) {
                            this.testCaseContext.setRetryIndex(this.retrySettings.getCurrentRetryCount() + 1);
                            this.testCaseBinding.setBindedValues(initialTestCaseBindedValues);
                            executor = new TestCaseExecutor(this.testCaseBinding, this.engine, this.eventManager, this.testCaseContext, this.doCleanUp);
                            newRetry = new RetrySettingsImpl();
                            newRetry.setCurrentRetryCount(this.retrySettings.getCurrentRetryCount() + 1);
                            newRetry.setRemainingRetryCount(this.retrySettings.getRemainingRetryCount() - 1);
                            executor.setRetrySettings(newRetry);
                            executor.setTestSuiteExecutor(this.testSuiteExecutor);
                            executor.execute(flowControl);
                        }
                        return var6_4;
                    }
                    this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                    this.testCaseContext.setTestCaseVariables(this.variableBinding.getVariables());
                    break block65;
lbl132:
                    // 1 sources

                    this.testCaseContext.skipThisTestCase();
                }
                if (this.testCaseContext.isMainTestCase()) {
                    this.eventManager.publicEvent(ExecutionListenerEvent.BEFORE_TEST_CASE, new Object[]{this.testCaseContext});
                }
                RunConfiguration.getExecutionProperties().put("current_testcase", this.testCaseContext.getTestCaseId());
                if (this.testCaseContext.isSkipped()) ** GOTO lbl208
                this.testCaseResult = this.invokeTestSuiteMethod(SetupTestCase.class.getName(), "setup action", false, this.testCaseResult);
                if (!ErrorCollector.getCollector().containsErrors()) break block64;
                error = ErrorCollector.getCollector().getFirstError();
                this.testCaseResult.setMessage(ExceptionsUtil.getStackTraceForThrowable(error));
                this.logger.logError(this.testCaseResult.getMessage(), null, error);
                var6_5 = this.testCaseResult;
                if (!this.testCaseResult.getTestStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.PASSED) && RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
                    logFolderPath = this.logger.getLogFolderPath();
                    testArtifactFolderPath = StringUtils.isEmpty((CharSequence)logFolderPath) != false ? RunConfiguration.getProjectDir() : logFolderPath;
                    try {
                        this.chromeSnapshotTool.captureSnapshot(testArtifactFolderPath, this.testCaseContext.getTestCaseId());
                    }
                    catch (Exception error) {
                        this.logger.logWarning(error.getMessage(), null, error);
                    }
                }
                this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
                this.testCaseContext.setMessage(this.testCaseResult.getMessage());
                if (this.testCaseContext.isMainTestCase()) {
                    this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
                }
                shouldRetry = false;
                if (this.testCaseContext.isMainTestCase()) {
                    if (this.testCaseContext.isSkipped()) {
                        this.logger.logSkipped(this.testCaseResult.getMessage());
                    } else {
                        testCaseStatus = this.testCaseResult.getTestStatus().getStatusValue();
                        switch (TestCaseExecutor.$SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue()[testCaseStatus.ordinal()]) {
                            case 3: 
                            case 5: {
                                if (this.retrySettings != null && this.retrySettings.getRemainingRetryCount() > 0) {
                                    shouldRetry = true;
                                }
                                if (this.testSuiteExecutor == null) break;
                                this.testSuiteExecutor.updateFailedThreshold();
                            }
                        }
                    }
                    attributes = new HashMap<String, String>();
                    if (this.retrySettings != null) {
                        attributes.put("currentRetryCount", Integer.toString(this.retrySettings.getCurrentRetryCount()));
                        attributes.put("remainingRetryCount", Integer.toString(this.retrySettings.getRemainingRetryCount()));
                    }
                    keywordsUsage = KeywordExecutionContext.getKeywordsUsage();
                    attributes.put("keywordsUsage", JsonUtil.toJson(keywordsUsage));
                    executedKeywords = KeywordExecutionContext.getExecutedKeywords();
                    attributes.put("executedKeywords", JsonUtil.toJson(executedKeywords));
                    attributes.put("applitools", String.valueOf(KeywordExecutionContext.isUsingApplitools()));
                    attributes.put("executionBindingVariables", JsonUtil.toJson(this.dataBindingReport));
                    this.logger.endTest(this.testCase.getTestCaseId(), attributes);
                } else {
                    this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
                }
                this.postExecution();
                if (shouldRetry && this.testSuiteExecutor != null && !this.testSuiteExecutor.reachFailedThreshold()) {
                    this.testCaseContext.setRetryIndex(this.retrySettings.getCurrentRetryCount() + 1);
                    this.testCaseBinding.setBindedValues(initialTestCaseBindedValues);
                    executor = new TestCaseExecutor(this.testCaseBinding, this.engine, this.eventManager, this.testCaseContext, this.doCleanUp);
                    newRetry = new RetrySettingsImpl();
                    newRetry.setCurrentRetryCount(this.retrySettings.getCurrentRetryCount() + 1);
                    newRetry.setRemainingRetryCount(this.retrySettings.getRemainingRetryCount() - 1);
                    executor.setRetrySettings(newRetry);
                    executor.setTestSuiteExecutor(this.testSuiteExecutor);
                    executor.execute(flowControl);
                }
                return var6_5;
            }
            this.accessMainPhase();
            this.invokeTestSuiteMethod(TearDownTestCase.class.getName(), "tear down", true, this.testCaseResult);
            break block66;
lbl208:
            // 1 sources

            testStatus = new TestStatus();
            testStatus.setStatusValue(TestStatus.TestStatusValue.SKIPPED);
            testStatus.setStackTrace(StringConstants.TEST_CASE_SKIPPED);
            this.testCaseResult.setTestStatus(testStatus);
        }
        var6_6 = this.testCaseResult;
        if (!this.testCaseResult.getTestStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.PASSED) && RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
            logFolderPath = this.logger.getLogFolderPath();
            testArtifactFolderPath = StringUtils.isEmpty((CharSequence)logFolderPath) != false ? RunConfiguration.getProjectDir() : logFolderPath;
            try {
                this.chromeSnapshotTool.captureSnapshot(testArtifactFolderPath, this.testCaseContext.getTestCaseId());
            }
            catch (Exception error) {
                this.logger.logWarning(error.getMessage(), null, error);
            }
        }
        this.testCaseContext.setTestCaseStatus(this.testCaseResult.getTestStatus().getStatusValue().name());
        this.testCaseContext.setMessage(this.testCaseResult.getMessage());
        if (this.testCaseContext.isMainTestCase()) {
            this.eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_CASE, new Object[]{this.testCaseContext});
        }
        shouldRetry = false;
        if (this.testCaseContext.isMainTestCase()) {
            if (this.testCaseContext.isSkipped()) {
                this.logger.logSkipped(this.testCaseResult.getMessage());
            } else {
                testCaseStatus = this.testCaseResult.getTestStatus().getStatusValue();
                switch (TestCaseExecutor.$SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue()[testCaseStatus.ordinal()]) {
                    case 3: 
                    case 5: {
                        if (this.retrySettings != null && this.retrySettings.getRemainingRetryCount() > 0) {
                            shouldRetry = true;
                        }
                        if (this.testSuiteExecutor == null) break;
                        this.testSuiteExecutor.updateFailedThreshold();
                    }
                }
            }
            attributes = new HashMap<String, String>();
            if (this.retrySettings != null) {
                attributes.put("currentRetryCount", Integer.toString(this.retrySettings.getCurrentRetryCount()));
                attributes.put("remainingRetryCount", Integer.toString(this.retrySettings.getRemainingRetryCount()));
            }
            keywordsUsage = KeywordExecutionContext.getKeywordsUsage();
            attributes.put("keywordsUsage", JsonUtil.toJson(keywordsUsage));
            executedKeywords = KeywordExecutionContext.getExecutedKeywords();
            attributes.put("executedKeywords", JsonUtil.toJson(executedKeywords));
            attributes.put("applitools", String.valueOf(KeywordExecutionContext.isUsingApplitools()));
            attributes.put("executionBindingVariables", JsonUtil.toJson(this.dataBindingReport));
            this.logger.endTest(this.testCase.getTestCaseId(), attributes);
        } else {
            this.logger.endCalledTest(this.testCase.getTestCaseId(), null);
        }
        this.postExecution();
        if (shouldRetry && this.testSuiteExecutor != null && !this.testSuiteExecutor.reachFailedThreshold()) {
            this.testCaseContext.setRetryIndex(this.retrySettings.getCurrentRetryCount() + 1);
            this.testCaseBinding.setBindedValues(initialTestCaseBindedValues);
            executor = new TestCaseExecutor(this.testCaseBinding, this.engine, this.eventManager, this.testCaseContext, this.doCleanUp);
            newRetry = new RetrySettingsImpl();
            newRetry.setCurrentRetryCount(this.retrySettings.getCurrentRetryCount() + 1);
            newRetry.setRemainingRetryCount(this.retrySettings.getRemainingRetryCount() - 1);
            executor.setRetrySettings(newRetry);
            executor.setTestSuiteExecutor(this.testSuiteExecutor);
            executor.execute(flowControl);
        }
        return var6_6;
    }

    private TestResult invokeTestSuiteMethod(String methodName, String actionType, boolean ignoredIfFailed, TestResult testCaseResult) {
        if (this.testSuiteExecutor != null) {
            ErrorCollector errorCollector = ErrorCollector.getCollector();
            List<Throwable> coppiedError = errorCollector.getCoppiedErrors();
            errorCollector.clearErrors();
            this.testSuiteExecutor.invokeEachTestCaseMethod(methodName, actionType, ignoredIfFailed);
            if (!ignoredIfFailed && errorCollector.containsErrors()) {
                coppiedError.add(errorCollector.getFirstError());
            }
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedError);
            if (errorCollector.containsErrors() && ignoredIfFailed) {
                Throwable firstError = errorCollector.getFirstError();
                TestStatus testStatus = new TestStatus();
                TestStatus.TestStatusValue errorType = ErrorCollector.isErrorFailed(firstError) ? TestStatus.TestStatusValue.FAILED : TestStatus.TestStatusValue.ERROR;
                testStatus.setStatusValue(errorType);
                String errorMessage = ExceptionsUtil.getMessageForThrowable(firstError);
                testStatus.setStackTrace(errorMessage);
                testCaseResult.setTestStatus(testStatus);
                return testCaseResult;
            }
        }
        return testCaseResult;
    }

    private void accessMainPhase() {
        if (!this.processSetupPhase()) {
            return;
        }
        this.processExecutionPhase();
    }

    private void processExecutionPhase() {
        try {
            this.engine.changeConfigForExecutingScript();
            this.setupContextClassLoader();
            this.doExecute();
        }
        catch (ExceptionInInitializerError e) {
            errorCollector.addError(e.getCause());
        }
        catch (Throwable e) {
            errorCollector.addError(e);
        }
        if (errorCollector.containsErrors()) {
            this.onExecutionError(errorCollector.getFirstError());
        } else {
            this.onExecutionComplete();
        }
        if (this.doCleanUp) {
            this.cleanUp();
        }
    }

    protected void doExecute() throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        this.testCaseResult.setScriptResult(this.runScript(this.getScriptFile()));
    }

    private void cleanUp() {
        DriverCleanerCollector.getInstance().cleanDrivers();
    }

    private Object runScript(File scriptFile) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        return this.engine.runScriptAsRawText(FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"), scriptFile.toURI().toURL().toExternalForm(), this.variableBinding, this.getTestCase().getName());
    }

    protected void runMethod(File scriptFile, String methodName) throws ResourceException, ScriptException, ClassNotFoundException, IOException {
        this.engine.changeConfigForExecutingScript();
        this.engine.runScriptMethodAsRawText(FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"), scriptFile.toURI().toURL().toExternalForm(), methodName, this.variableBinding);
    }

    private Map<String, String> getTestCaseProperties(TestCaseBinding testCaseBinding, TestCase testCase, FailureHandling flowControl) {
        HashMap<String, String> testProperties = new HashMap<String, String>();
        if (this.retrySettings != null) {
            testProperties.put("currentRetryCount", Integer.toString(this.retrySettings.getCurrentRetryCount()));
            testProperties.put("remainingRetryCount", Integer.toString(this.retrySettings.getRemainingRetryCount()));
        }
        testProperties.put("name", testCaseBinding.getTestCaseId());
        testProperties.put("description", testCase.getDescription());
        testProperties.put("id", testCase.getTestCaseId());
        testProperties.put("source", testCase.getMetaFilePath());
        testProperties.put("tag", testCase.getTag());
        testProperties.put("isOptional", String.valueOf(flowControl == FailureHandling.OPTIONAL));
        testProperties.put("iteration", testCase.getIterationVariableValue());
        testProperties.put("origin", testCase.getOrigin());
        if (testCaseBinding.getTestCaseExecutionId() != null) {
            testProperties.put("uuid", testCaseBinding.getTestCaseExecutionId().toString());
        }
        return testProperties;
    }

    private Map<String, Object> getBindedValues() {
        Map<String, Object> bindedValues = this.testCaseBinding.getBindedValues();
        return bindedValues != null ? bindedValues : Collections.emptyMap();
    }

    private Binding collectTestCaseVariables() {
        Binding variableBinding = new Binding(this.testCaseBinding != null ? this.testCaseBinding.getBindedValues() : Collections.emptyMap());
        this.engine.changeConfigForCollectingVariable();
        this.logger.logDebug(StringConstants.MAIN_LOG_INFO_START_EVALUATE_VARIABLE);
        this.testCase.getVariables().stream().forEach(testCaseVariable -> {
            String variableName = testCaseVariable.getName();
            if (this.getBindedValues().containsKey(variableName)) {
                Matcher matcher;
                Object variableValue = this.testCaseBinding.getBindedValues().get(variableName);
                variableBinding.setVariable(variableName, variableValue);
                if (testCaseVariable.isMasked()) {
                    this.addSecureValue(variableValue);
                } else if (this.secureProtectedGlobalValuesPattern != null && (matcher = this.secureProtectedGlobalValuesPattern.matcher(Objects.toString(variableValue))).matches()) {
                    this.addSecureValue(variableValue);
                }
                this.dataBindingReport.add(VariableReport.value(this.maskValue(Objects.toString(variableValue)), variableName, testCaseVariable.isMasked()));
                this.logger.logInfo(MessageFormat.format(StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y, variableName, Objects.toString(variableValue)));
                return;
            }
            try {
                String defaultValue = (String)StringUtils.defaultIfEmpty((CharSequence)testCaseVariable.getDefaultValue(), (CharSequence)"null");
                Object defaultValueObject = this.engine.runScriptWithoutLogging(defaultValue, null);
                variableBinding.setVariable(variableName, defaultValueObject);
                if (testCaseVariable.isMasked()) {
                    this.addSecureValue(defaultValueObject);
                }
                this.dataBindingReport.add(VariableReport.defaultValue(this.maskValue(Objects.toString(defaultValueObject)), variableName, testCaseVariable.isMasked()));
                this.logger.logInfo(MessageFormat.format(StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y_AS_DEFAULT, variableName, Objects.toString(defaultValueObject)));
            }
            catch (ExceptionInInitializerError e) {
                this.logger.logWarning(MessageFormat.format(StringConstants.MAIN_LOG_MSG_SET_TEST_VARIABLE_ERROR_BECAUSE_OF, variableName, e.getCause().getMessage()), null, e);
            }
            catch (Exception e) {
                this.logger.logWarning(MessageFormat.format(StringConstants.MAIN_LOG_MSG_SET_TEST_VARIABLE_ERROR_BECAUSE_OF, variableName, e.getMessage()), null, e);
            }
        });
        this.getBindedValues().entrySet().stream().filter(entry -> !variableBinding.hasVariable((String)entry.getKey())).forEach(entry -> {
            String variableName = (String)entry.getKey();
            Object variableValue = entry.getValue();
            variableBinding.setProperty(variableName, variableValue);
            this.logger.logInfo(MessageFormat.format(StringConstants.MAIN_LOG_INFO_VARIABLE_NAME_X_IS_SET_TO_Y, variableName, Objects.toString(variableValue)));
        });
        this.logger.logRunData("executionBindingVariables", JsonUtil.toJson(this.dataBindingReport), true);
        return variableBinding;
    }

    private void logError(Throwable t, String message) {
        this.logger.logMessage(ErrorCollector.fromError(t), message, t);
    }

    private TestStatus.TestStatusValue getResultByError(Throwable t) {
        return TestStatus.TestStatusValue.valueOf(ErrorCollector.fromError(t).name());
    }

    private void endAllUnfinishedKeywords(Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        while (!keywordStack.isEmpty()) {
            KeywordLogger.KeywordStackElement keywordStackElement = keywordStack.pop();
            this.logger.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    private void internallyRunMethods(TestCaseMethodNodeWrapper methodNodeWrapper) {
        List<MethodNode> methodList = methodNodeWrapper.getMethodNodes();
        if (methodList == null || methodList.isEmpty()) {
            return;
        }
        this.logger.logDebug(methodNodeWrapper.getStartMessage());
        int count = 1;
        for (MethodNode method : methodList) {
            this.runMethod(method.getName(), methodNodeWrapper.getActionType(), count++, methodNodeWrapper.isIgnoredIfFailed());
        }
    }

    private void runMethod(String methodName, String actionType, int index, boolean ignoreIfFailed) {
        Stack<KeywordLogger.KeywordStackElement> keywordStack = new Stack<KeywordLogger.KeywordStackElement>();
        HashMap<String, String> startKeywordAttributeMap = new HashMap<String, String>();
        startKeywordAttributeMap.put("stepIndex", String.valueOf(index));
        if (ignoreIfFailed) {
            startKeywordAttributeMap.put("isIgnoredIfFailed", String.valueOf(ignoreIfFailed));
        }
        boolean isKeyword = true;
        this.logger.startKeyword(methodName, actionType, startKeywordAttributeMap, keywordStack);
        try {
            try {
                this.runMethod(this.getScriptFile(), methodName);
                this.endAllUnfinishedKeywords(keywordStack);
                this.logger.logPassed(MessageFormat.format(StringConstants.MAIN_LOG_PASSED_METHOD_COMPLETED, methodName), Collections.emptyMap(), isKeyword);
            }
            catch (Throwable e) {
                this.endAllUnfinishedKeywords(keywordStack);
                String message = MessageFormat.format(StringConstants.MAIN_LOG_WARNING_ERROR_OCCURRED_WHEN_RUN_METHOD, methodName, e.getClass().getName(), ExceptionsUtil.getMessageForThrowable(e));
                if (ignoreIfFailed) {
                    this.logger.logWarning(message, null, e, isKeyword);
                    this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
                    return;
                }
                this.logger.logError(message, null, e, isKeyword);
                errorCollector.addError(e);
                this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
            }
        }
        finally {
            this.logger.endKeyword(methodName, actionType, Collections.emptyMap(), keywordStack);
        }
    }

    private void runTearDownMethodByError(Throwable t) {
        LogLevel errorLevel = ErrorCollector.fromError(t);
        TestCaseMethodNodeWrapper failedMethodWrapper = this.methodNodeCollector.getMethodNodeWrapper(TearDownIfFailed.class);
        if (errorLevel == LogLevel.ERROR) {
            failedMethodWrapper = this.methodNodeCollector.getMethodNodeWrapper(TearDownIfError.class);
        }
        this.internallyRunMethods(failedMethodWrapper);
        this.internallyRunMethods(this.methodNodeCollector.getMethodNodeWrapper(TearDown.class));
    }

    public void setupContextClassLoader() {
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public void setRetrySettings(RetrySettings retrySettings) {
        this.retrySettings = retrySettings;
    }

    public TestResult getTestCaseResult() {
        return this.testCaseResult;
    }

    public void getIterationValueByIterationName() {
        this.testCase.getVariables().stream().forEach(testCaseVariable -> {
            String variableName = testCaseVariable.getName();
            String iterationVariableName = this.testCaseBinding.getIterationVariableName();
            if (iterationVariableName != null && iterationVariableName.equals(variableName)) {
                Object variableValue = this.testCaseBinding.getBindedValues().get(variableName);
                if (variableValue == null) {
                    try {
                        String defaultValue = (String)StringUtils.defaultIfEmpty((CharSequence)testCaseVariable.getDefaultValue(), (CharSequence)"null");
                        variableValue = this.engine.runScriptWithoutLogging(defaultValue, null);
                    }
                    catch (Exception e) {
                        this.logger.logWarning(MessageFormat.format(StringConstants.MAIN_LOG_MSG_SET_TEST_VARIABLE_ERROR_BECAUSE_OF, variableName, e.getMessage()), null, e);
                    }
                }
                if (variableValue != null) {
                    this.testCase.setIterationVariableValue(variableValue.toString());
                }
                if (testCaseVariable.isMasked()) {
                    this.addSecureValue(variableValue);
                }
            }
        });
    }

    private void addSecureValue(Object variableValue) {
        String value = Objects.toString(variableValue);
        if ("''".equals(value) || "".equals(value) || "0".equals(value)) {
            return;
        }
        this.secureValues.add(value);
        this.secureValuesPattern = this.generateSecureValuesPattern(this.secureValues);
        this.logger.setSecureValuesPattern(this.secureValuesPattern);
    }

    private Pattern generateSecureValuesPattern(List<String> secureValues) {
        if (secureValues.isEmpty()) {
            return null;
        }
        String regex = secureValues.stream().sorted((a, b) -> Integer.compare(b.length(), a.length())).map(Pattern::quote).collect(Collectors.joining("|"));
        if (StringUtils.isEmpty((CharSequence)regex)) {
            return null;
        }
        return Pattern.compile(regex);
    }

    public String maskValue(String message) {
        if (message == null || this.secureValuesPattern == null) {
            return message;
        }
        Matcher matcher = this.secureValuesPattern.matcher(message);
        return matcher.replaceAll("\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022");
    }

    private boolean hasTestCaseScript() {
        try {
            File scriptFile = new File(this.testCase.getGroovyScriptPath());
            return scriptFile.exists() && StringUtils.isNotBlank((CharSequence)FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"));
        }
        catch (IOException e) {
            this.logger.logError(e.getMessage(), null, e);
            return false;
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue() {
        if ($SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue != null) {
            return $SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue;
        }
        int[] nArray = new int[TestStatus.TestStatusValue.values().length];
        try {
            nArray[TestStatus.TestStatusValue.ERROR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.FAILED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.INCOMPLETE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.INFO.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.NOT_RUN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.PASSED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.SKIPPED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TestStatus.TestStatusValue.WARNING.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$kms$katalon$core$logging$model$TestStatus$TestStatusValue = nArray;
        return nArray;
    }

    class InterceptingOutputStream
    extends OutputStream {
        private final PrintStream originalStream;

        public InterceptingOutputStream(PrintStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public void write(int b) {
            char c = (char)b;
            this.processLog(String.valueOf(c));
        }

        @Override
        public void write(byte[] b, int off, int len) {
            String intercepted = new String(b, off, len);
            this.processLog(intercepted);
        }

        private void processLog(String message) {
            this.originalStream.print(this.maskValue(message));
        }

        public String maskValue(String message) {
            if (message == null || TestCaseExecutor.this.secureValuesPattern == null) {
                return message;
            }
            Matcher matcher = TestCaseExecutor.this.secureValuesPattern.matcher(message);
            return matcher.replaceAll("********");
        }
    }
}

