/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.profiling;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class ResourceTrackerService {
    private final Logger logger = LoggerFactory.getLogger(ResourceTrackerService.class);
    private static final long INTERVAL_MINUTES = 15L;
    private ScheduledExecutorService scheduler;
    private boolean enableProcessProfiling = false;
    private SystemInfo systemInfo;
    private OperatingSystem os;

    public ResourceTrackerService() {
        String profilingSettings = System.getProperty("katalon.enableProfiling", "false");
        this.enableProcessProfiling = Boolean.valueOf(profilingSettings);
    }

    public void start() {
        if (this.enableProcessProfiling) {
            this.logger.info("Starting ResourceTrackerService...");
            this.systemInfo = new SystemInfo();
            this.os = this.systemInfo.getOperatingSystem();
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.scheduleAtFixedRate(this::trackResources, 15L, 15L, TimeUnit.MINUTES);
            this.logger.info("ResourceTrackerService started. Resource Snapshot will display every {} minute(s)...", (Object)15L);
        }
    }

    private void trackResources() {
        try {
            long currentPid = ProcessHandle.current().pid();
            OSProcess currentProcess = this.os.getProcess((int)currentPid);
            if (currentProcess == null) {
                this.logger.warn("Current process not found!");
                return;
            }
            this.logger.info("\n=== Resource Snapshot ===");
            this.logProcess(currentProcess, "", true);
            List children = this.os.getChildProcesses((int)currentPid, p -> true, (o1, o2) -> 0, 100);
            int i = 0;
            while (i < children.size()) {
                OSProcess child = (OSProcess)children.get(i);
                boolean lastChild = i == children.size() - 1;
                String prefix = lastChild ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
                this.logProcess(child, prefix, lastChild);
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.warn("Error tracking resources: " + e.getMessage());
        }
    }

    private void logProcess(OSProcess process, String prefix, boolean last) {
        long pid = process.getProcessID();
        double cpuPercent = process.getProcessCpuLoadCumulative() * 100.0;
        double memoryMb = (double)process.getResidentSetSize() / 1024.0 / 1024.0;
        String name = process.getName();
        System.out.printf("%sPID %-6d | CPU: %6.2f%% | RAM: %8.2f MB | Name: %s%n", prefix, pid, cpuPercent, memoryMb, name);
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.logger.info("ResourceTrackerService stopped.");
            this.scheduler = null;
        }
    }
}

