/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.newreport;

import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.TestSuiteXMLLogParser;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.reporting.newreport.NewReportModelMapper;
import com.kms.katalon.core.util.ArrayUtil;
import com.kms.katalon.report.core.models.common.DataBindingVariable;
import com.kms.katalon.report.core.models.common.ExecutedTestResult;
import com.kms.katalon.report.core.models.common.ExecutedTestStatus;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.report.core.models.logmessage.LogMessage;
import com.kms.katalon.util.DateTimes;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NewLogRecordModelMapper {
    private static final EnumSet<LogLevel> RECORD_RESULT_LEVELS = EnumSet.of(LogLevel.PASSED, LogLevel.FAILED, LogLevel.WARNING, LogLevel.NOT_RUN, LogLevel.ERROR);
    private Deque<XmlLogRecord> xmlLogRecordStack = new ArrayDeque<XmlLogRecord>();
    private Deque<Object> logRecordStack = new ArrayDeque<Object>();
    private Deque<ExecutedTestEntity> entityStack = new ArrayDeque<ExecutedTestEntity>();
    private NewReportModelMapper reportModelMapper = new NewReportModelMapper();
    private int lastLogRecordIndex = 0;
    private Map<String, XmlLogRecord> resultXMLRecordMap = new HashMap<String, XmlLogRecord>();
    private Map<String, ExecutedTestEntity> entityMap = new HashMap<String, ExecutedTestEntity>();

    public XmlLogRecord findResultXMLRecord(String entityId) {
        return this.resultXMLRecordMap.get(entityId);
    }

    public ExecutedTestEntity findEntity(String entityId) {
        return this.entityMap.get(entityId);
    }

    public void reset() {
        this.logRecordStack.clear();
        this.entityStack.clear();
        this.xmlLogRecordStack.clear();
        this.lastLogRecordIndex = 0;
        this.resultXMLRecordMap.clear();
        this.entityMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutedTestEntity mapTheWholeLogRecords(List<XmlLogRecord> logRecords, boolean flushIncompleteRecords) {
        this.reset();
        if (logRecords == null) {
            return null;
        }
        ExecutedTestEntity firstEntity = null;
        ArrayList<XmlLogRecord> clonedLogRecords = null;
        List<XmlLogRecord> list = logRecords;
        synchronized (list) {
            clonedLogRecords = new ArrayList<XmlLogRecord>(logRecords);
            this.lastLogRecordIndex = clonedLogRecords.size();
        }
        for (XmlLogRecord logRecordI : clonedLogRecords) {
            ExecutedTestEntity entityI = this.mapLogRecord(logRecordI, true);
            if (firstEntity != null) continue;
            firstEntity = entityI;
        }
        if (flushIncompleteRecords) {
            this.flushIncompleteLogRecords();
        }
        return firstEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<XmlLogRecord> collectNewLogRecords(List<XmlLogRecord> logRecords) {
        if (logRecords == null) {
            return null;
        }
        ArrayList<XmlLogRecord> newRecords = null;
        List<XmlLogRecord> list = logRecords;
        synchronized (list) {
            int size = logRecords.size();
            newRecords = new ArrayList<XmlLogRecord>(logRecords.subList(this.lastLogRecordIndex, size));
            this.lastLogRecordIndex = size;
        }
        return newRecords;
    }

    public ExecutedTestEntity[] mapLogRecordParts(List<XmlLogRecord> newRecords) {
        if (newRecords == null) {
            return null;
        }
        ExecutedTestEntity[] newEntities = newRecords.stream().map(recordI -> this.mapLogRecord((XmlLogRecord)recordI, false)).filter(logRecord -> logRecord != null).collect(Collectors.toList()).toArray(new ExecutedTestEntity[0]);
        ArrayList<ExecutedTestEntity> combinedEntities = new ArrayList<ExecutedTestEntity>();
        ExecutedTestEntity lastEntity = null;
        ExecutedTestEntity[] executedTestEntityArray = newEntities;
        int n = newEntities.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutedTestEntity entityI = executedTestEntityArray[n2];
            if (lastEntity != null && StringUtils.equals((CharSequence)entityI.id, (CharSequence)lastEntity.id)) {
                this.mergeEntity(lastEntity, entityI);
            } else {
                combinedEntities.add(entityI);
                lastEntity = entityI;
            }
            ++n2;
        }
        return combinedEntities.toArray(new ExecutedTestEntity[0]);
    }

    public ExecutedTestEntity mapLogRecord(XmlLogRecord xmlLogRecord, boolean collectingMode) {
        ExecutedTestEntity executedEntity;
        boolean isGoDepeper;
        boolean isSameLevel;
        block16: {
            ILogRecord logRecord;
            boolean isRunData = LogLevel.RUN_DATA.toString().equals(xmlLogRecord.getLevel().getName());
            int stackDepth = this.logRecordStack.size();
            ILogRecord iLogRecord = logRecord = isRunData ? (ILogRecord)this.logRecordStack.peekLast() : TestSuiteXMLLogParser.mapLogRecord(xmlLogRecord, this.logRecordStack);
            if (logRecord == null) {
                return null;
            }
            if (isRunData) {
                ExecutedTestEntity parentEntity = this.entityStack.peekLast();
                Map<String, String> properties = xmlLogRecord.getProperties();
                if (properties == null) {
                    return null;
                }
                List<DataBindingVariable> newDataBinding = properties.entrySet().stream().map(entry -> {
                    DataBindingVariable variable = new DataBindingVariable();
                    variable.name = (String)entry.getKey();
                    variable.value = (String)entry.getValue();
                    return variable;
                }).collect(Collectors.toList());
                parentEntity.dataBinding = ArrayUtil.concat(parentEntity.dataBinding, newDataBinding.toArray(new DataBindingVariable[0]));
                return parentEntity;
            }
            isSameLevel = this.logRecordStack.size() - stackDepth == 0;
            isGoDepeper = this.logRecordStack.size() - stackDepth > 0;
            executedEntity = null;
            try {
                if (logRecord instanceof MessageLogRecord) {
                    MessageLogRecord messageLog = (MessageLogRecord)logRecord;
                    LogMessage logMessage = this.reportModelMapper.mapLogMessage(messageLog);
                    executedEntity = this.entityStack.peekLast();
                    executedEntity.logs = ArrayUtil.concat(executedEntity.logs, logMessage);
                    LogLevel logLevel = LogLevel.valueOf(xmlLogRecord.getLevel());
                    if (RECORD_RESULT_LEVELS.contains((Object)logLevel)) {
                        this.resultXMLRecordMap.put(executedEntity.id, xmlLogRecord);
                    }
                    return executedEntity;
                }
                executedEntity = this.reportModelMapper.mapLogRecord(logRecord, 0);
                if (executedEntity != null) break block16;
                return null;
            }
            catch (IOException iOException) {}
        }
        executedEntity.index = xmlLogRecord.getIndex();
        if (isSameLevel) {
            ExecutedTestEntity parent = this.entityStack.peekLast();
            if (parent != null) {
                executedEntity.parentId = parent.id;
            }
        } else if (isGoDepeper) {
            String startMessage = xmlLogRecord.getMessage();
            if (StringUtils.isNotBlank((CharSequence)startMessage)) {
                int stepContentIndex = startMessage.indexOf(":");
                executedEntity.message = startMessage.substring(stepContentIndex + 1).trim();
            }
            executedEntity.status = ExecutedTestStatus.RUNNING;
            executedEntity.result = null;
            ExecutedTestEntity parent = this.entityStack.peekLast();
            this.entityMap.put(executedEntity.id, executedEntity);
            if (parent != null) {
                executedEntity.parentId = parent.id;
                if (collectingMode) {
                    parent.children = ArrayUtil.concat(parent.children, executedEntity);
                }
            }
            this.entityStack.addLast(executedEntity);
            this.xmlLogRecordStack.addLast(xmlLogRecord);
        } else {
            this.xmlLogRecordStack.pollLast();
            ExecutedTestEntity startEntity = this.entityStack.pollLast();
            executedEntity.id = startEntity.id;
            executedEntity.parentId = startEntity.parentId;
            executedEntity.logs = startEntity.logs;
            executedEntity.dataBinding = startEntity.dataBinding;
            this.mergeEntity(startEntity, executedEntity);
        }
        return executedEntity;
    }

    private void mergeEntity(ExecutedTestEntity entity, ExecutedTestEntity entityPart) {
        entity.endTime = entityPart.endTime;
        entity.status = entityPart.status;
        entity.result = entityPart.result;
    }

    public ExecutedTestEntity[] flushIncompleteLogRecords() {
        ExecutedTestEntity[] incompleteRecords;
        String endTime = DateTimes.formatISO8601((Date)new Date());
        for (XmlLogRecord xmlLogRecord : this.xmlLogRecordStack) {
            if (!StringUtils.isBlank((CharSequence)xmlLogRecord.getEndTime())) continue;
            xmlLogRecord.setEndTime(endTime);
        }
        ExecutedTestEntity[] executedTestEntityArray = incompleteRecords = this.entityStack.toArray(new ExecutedTestEntity[0]);
        int n = incompleteRecords.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutedTestEntity entity = executedTestEntityArray[n2];
            if (entity != null) {
                entity.status = ExecutedTestStatus.COMPLETED;
                entity.result = ExecutedTestResult.INCOMPLETE;
                if (StringUtils.isBlank((CharSequence)entity.endTime)) {
                    entity.endTime = endTime;
                }
            }
            ++n2;
        }
        this.entityStack.clear();
        this.logRecordStack.clear();
        this.xmlLogRecordStack.clear();
        return incompleteRecords;
    }
}

