/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.newreport;

import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.reporting.newreport.analyzer.FailureAnalyzer;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.core.testcase.VariableReport;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.core.util.MediaUtils;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.report.core.models.common.DataBindingVariable;
import com.kms.katalon.report.core.models.common.ExecutedTestResult;
import com.kms.katalon.report.core.models.common.ExecutedTestStatistics;
import com.kms.katalon.report.core.models.common.ExecutedTestStatus;
import com.kms.katalon.report.core.models.common.LocalTestExecutionContext;
import com.kms.katalon.report.core.models.common.TargetTestExecutionContext;
import com.kms.katalon.report.core.models.common.TestExecutionContext;
import com.kms.katalon.report.core.models.entities.ExecutedTestCase;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntry;
import com.kms.katalon.report.core.models.entities.ExecutedTestStep;
import com.kms.katalon.report.core.models.entities.ExecutedTestSuite;
import com.kms.katalon.report.core.models.entities.ExecutedTestSuiteCollection;
import com.kms.katalon.report.core.models.execution.ExternalReport;
import com.kms.katalon.report.core.models.execution.TestExecution;
import com.kms.katalon.report.core.models.execution.TestProjectInfo;
import com.kms.katalon.report.core.models.logmessage.LogAttachment;
import com.kms.katalon.report.core.models.logmessage.LogAttachmentType;
import com.kms.katalon.report.core.models.logmessage.LogLevel;
import com.kms.katalon.report.core.models.logmessage.LogMessage;
import com.kms.katalon.util.DateTimes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewReportModelMapper {
    private Logger logger = LoggerFactory.getLogger(NewReportModelMapper.class);
    private static final Map<TestStatus.TestStatusValue, ExecutedTestResult> TEST_RESULT_MAP = new HashMap<TestStatus.TestStatusValue, ExecutedTestResult>();
    private static final Map<TestStatus.TestStatusValue, ExecutedTestStatus> TEST_STATUS_MAP;
    private static final Map<TestStatus.TestStatusValue, LogLevel> LOG_LEVEL_MAP;
    public static final String MAIN_PART_KEY = "main";
    public static final int INFINITE_DEPTH = -1;
    public ReportSettings settings;
    public File reportFolder;
    private IFailureAnalysisService failureAnalysisService = this.getFailureAnalysisService();
    private boolean canExecuteAIFailureAnalysis;

    static {
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.PASSED, ExecutedTestResult.PASSED);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.FAILED, ExecutedTestResult.FAILED);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.ERROR, ExecutedTestResult.ERROR);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.WARNING, ExecutedTestResult.WARNING);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.INCOMPLETE, ExecutedTestResult.INCOMPLETE);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.SKIPPED, ExecutedTestResult.SKIPPED);
        TEST_RESULT_MAP.put(TestStatus.TestStatusValue.NOT_RUN, null);
        TEST_STATUS_MAP = new HashMap<TestStatus.TestStatusValue, ExecutedTestStatus>();
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.PASSED, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.FAILED, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.ERROR, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.WARNING, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.INCOMPLETE, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.SKIPPED, ExecutedTestStatus.COMPLETED);
        TEST_STATUS_MAP.put(TestStatus.TestStatusValue.NOT_RUN, ExecutedTestStatus.NOT_RUN);
        LOG_LEVEL_MAP = new HashMap<TestStatus.TestStatusValue, LogLevel>();
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.PASSED, LogLevel.PASSED);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.FAILED, LogLevel.FAILED);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.ERROR, LogLevel.ERROR);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.WARNING, LogLevel.WARNING);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.SKIPPED, LogLevel.SKIPPED);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.INFO, LogLevel.INFO);
        LOG_LEVEL_MAP.put(TestStatus.TestStatusValue.NOT_RUN, LogLevel.NOT_RUN);
    }

    public NewReportModelMapper() {
    }

    public NewReportModelMapper(ReportSettings settings, File reportFolder) {
        this.settings = settings;
        this.reportFolder = reportFolder;
        this.canExecuteAIFailureAnalysis = this.failureAnalysisService != null && this.failureAnalysisService.canExecute();
    }

    public void toTestExecutionParts(TestSuiteLogRecord testSuiteLogRecord, ExecutionDataPartHandler partHandler) throws IOException {
        if (partHandler == null) {
            return;
        }
        partHandler.handle(JsonUtil.toJson((Object)this.toTestExecution(testSuiteLogRecord, 1), false), MAIN_PART_KEY);
        ILogRecord[] children = testSuiteLogRecord.getChildRecords();
        int i = 0;
        while (i < children.length) {
            ExecutedTestEntity part = this.mapLogRecord(children[i]);
            this.handleSimplifiedDataPart(partHandler, i, part);
            ++i;
        }
    }

    private void handleSimplifiedDataPart(ExecutionDataPartHandler partHandler, int i, ExecutedTestEntity part) throws IOException {
        SimplifiedDataPart simplifiedPart = new SimplifiedDataPart(part.children, part.logs);
        partHandler.handle(JsonUtil.toJson((Object)simplifiedPart, false), String.valueOf(i));
    }

    public TestExecution toTestExecution(TestSuiteLogRecord testSuiteLogRecord, int depth) throws IOException {
        TestExecution execution = new TestExecution();
        execution.entity = (ExecutedTestEntry)this.mapLogRecord(testSuiteLogRecord, depth);
        execution.project = this.getProject(testSuiteLogRecord);
        String collectionName = testSuiteLogRecord.getTestSuiteCollectionName();
        if (StringUtils.isNotBlank((CharSequence)collectionName)) {
            ExternalReport parentReport = new ExternalReport();
            parentReport.name = collectionName;
            parentReport.path = testSuiteLogRecord.getTestSuiteCollectionPath();
            execution.parentReport = parentReport;
        }
        return execution;
    }

    private TestProjectInfo getProject(TestSuiteLogRecord testSuiteLogRecord) {
        TestProjectInfo project = new TestProjectInfo();
        project.name = testSuiteLogRecord.getProjectName();
        return project;
    }

    public ExecutedTestEntity mapLogRecord(ILogRecord logRecord) throws IOException {
        return this.mapLogRecord(logRecord, -1);
    }

    public ExecutedTestEntity mapLogRecord(ILogRecord logRecord, int depth) throws IOException {
        ExecutedTestSuite entity = null;
        if (logRecord instanceof TestSuiteLogRecord) {
            TestSuiteLogRecord testSuite = (TestSuiteLogRecord)logRecord;
            entity = this.mapTestSuite(testSuite);
        } else if (logRecord instanceof TestCaseLogRecord) {
            TestCaseLogRecord testCase = (TestCaseLogRecord)logRecord;
            entity = this.mapTestCase(testCase);
        } else if (logRecord instanceof TestStepLogRecord) {
            TestStepLogRecord testStep = (TestStepLogRecord)logRecord;
            entity = this.mapTestStep(testStep);
        }
        if (entity == null) {
            return null;
        }
        this.mapCommonProperties(logRecord, entity);
        this.collectChildrenAndLogMessages((ExecutedTestEntity)entity, logRecord, depth);
        if (this.isExecutedTestEntry((ExecutedTestEntity)entity)) {
            this.mapEntryProperties(logRecord, (ExecutedTestEntry)entity);
        }
        if (this.shouldAnalyzeFailure((ExecutedTestEntity)entity, depth)) {
            boolean isAnalyzeFailedReasonByAIEnabled = this.settings != null && this.settings.useAnalyzeFailedReasonByAI && this.canExecuteAIFailureAnalysis;
            FailureAnalyzer failureAnalyzer = new FailureAnalyzer(isAnalyzeFailedReasonByAIEnabled, this.failureAnalysisService);
            failureAnalyzer.analyzeAndEnrich((ExecutedTestEntity)entity, logRecord);
        }
        return entity;
    }

    private boolean shouldAnalyzeFailure(ExecutedTestEntity entity, int depth) {
        if (depth < 0) {
            return false;
        }
        if (!(entity instanceof ExecutedTestSuite) && !(entity instanceof ExecutedTestCase)) {
            return false;
        }
        return entity.result == ExecutedTestResult.FAILED || entity.result == ExecutedTestResult.ERROR;
    }

    private boolean isExecutedTestEntry(ExecutedTestEntity entity) {
        return entity instanceof ExecutedTestSuiteCollection || entity instanceof ExecutedTestSuite || entity instanceof ExecutedTestCase;
    }

    private ExecutedTestSuite mapTestSuite(TestSuiteLogRecord testSuiteLogRecord) {
        ExecutedTestSuite testSuite = new ExecutedTestSuite();
        testSuite.startIndex = testSuiteLogRecord.getBeforeTestSuiteLogRecords().size();
        if (StringUtils.isNotBlank((CharSequence)testSuiteLogRecord.getTestSuiteCollectionLocation()) && StringUtils.isNotBlank((CharSequence)testSuiteLogRecord.getTestSuitePath())) {
            testSuite.reportUrl = Paths.get(testSuiteLogRecord.getTestSuiteCollectionLocation(), new String[0]).relativize(Paths.get(testSuiteLogRecord.getTestSuitePath(), new String[0])).toString();
        }
        return testSuite;
    }

    private ExecutedTestCase mapTestCase(TestCaseLogRecord testCaseLogRecord) {
        ExecutedTestCase testCase = new ExecutedTestCase();
        testCase.dataIterationName = testCaseLogRecord.getIterationVariableValue();
        return testCase;
    }

    private ExecutedTestStep mapTestStep(TestStepLogRecord testStepLogRecord) {
        ExecutedTestStep step = new ExecutedTestStep();
        return step;
    }

    public LogMessage mapLogMessage(MessageLogRecord logMessageRecord) throws IOException {
        LogMessage logMessage = new LogMessage();
        logMessage.time = this.formatDate(logMessageRecord.getStartTime());
        logMessage.message = logMessageRecord.getMessage();
        logMessage.level = this.mapLogLevel(logMessageRecord);
        String attachmentPath = logMessageRecord.getAttachment();
        if (StringUtils.isNotBlank((CharSequence)attachmentPath)) {
            logMessage.attachments = new LogAttachment[]{this.collectAttachment(attachmentPath)};
        }
        return logMessage;
    }

    private LogAttachment collectAttachment(String attachmentPath) throws IOException {
        LogAttachment attachment = new LogAttachment();
        attachment.type = LogAttachmentType.IMAGE;
        if (this.settings == null || this.settings.useHTMLImageReferences) {
            attachment.content = attachmentPath;
            return attachment;
        }
        File attachmentFile = this.getReportFile(attachmentPath);
        if (!attachmentFile.exists()) {
            this.logger.warn(MessageFormat.format("The attachment does not exist and cannot be embedded in the report. Falling back to the attachment reference: \"{0}\" (Absolute path: \"{1}\")", attachmentPath, attachmentFile.getAbsolutePath()));
            attachment.content = attachmentPath;
            return attachment;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("katalon-", ".png");
            tempFile.deleteOnExit();
        }
        catch (Throwable error) {
            tempFile = null;
            this.logger.warn(MessageFormat.format("Cannot create a temporary file for optimizing the attachment. Skipping optimization: \"{0}\"", attachmentPath), error);
        }
        if (tempFile == null) {
            attachment.content = this.encodeAttachmentToDataURL(attachmentFile, attachmentPath);
            return attachment;
        }
        try {
            try {
                MediaUtils.optimizeImage(attachmentFile, tempFile);
                attachment.content = FileUtil.readFileToImageDataURL(tempFile);
            }
            catch (Throwable error) {
                this.logger.warn(MessageFormat.format("Failed to compress the attachment. Falling back to processing the original attachment: \"{0}\"", attachmentPath), error);
                attachment.content = this.encodeAttachmentToDataURL(attachmentFile, attachmentPath);
                FileUtils.deleteQuietly((File)tempFile);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
        return attachment;
    }

    private String encodeAttachmentToDataURL(File attachmentFile, String originalFilePath) {
        try {
            return FileUtil.readFileToImageDataURL(attachmentFile);
        }
        catch (Throwable error2) {
            this.logger.warn(MessageFormat.format("Failed to process the attachment. Falling back to the attachment reference: \"{0}\"", originalFilePath), error2);
            return originalFilePath;
        }
    }

    private <EntryType extends ExecutedTestEntry> void mapEntryProperties(ILogRecord logRecord, EntryType entry) {
        entry.entityId = logRecord.getId();
        entry.statistics = this.calculateStatistics(logRecord);
        entry.dataBinding = this.collectDataBinding(logRecord);
        entry.context = this.collectExecutionContext(logRecord);
    }

    private TestExecutionContext collectExecutionContext(ILogRecord logRecord) {
        if (!(logRecord instanceof TestSuiteLogRecord)) {
            return null;
        }
        TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)logRecord;
        TestExecutionContext context = new TestExecutionContext();
        TargetTestExecutionContext targetContext = new TargetTestExecutionContext();
        targetContext.platform = testSuiteLogRecord.getDevicePlatform();
        targetContext.deviceName = testSuiteLogRecord.getMobileDeviceName();
        targetContext.deviceOS = testSuiteLogRecord.getDevicePlatform();
        targetContext.deviceOSVersion = testSuiteLogRecord.getDeviceVersion();
        targetContext.browserName = testSuiteLogRecord.getBrowser();
        context.local = this.collectLocalContext(testSuiteLogRecord);
        context.target = targetContext;
        context.executedBy = testSuiteLogRecord.getUserFullName();
        context.profile = testSuiteLogRecord.getExecutionProfile();
        return context;
    }

    private LocalTestExecutionContext collectLocalContext(TestSuiteLogRecord testSuiteLogRecord) {
        LocalTestExecutionContext localContext = new LocalTestExecutionContext();
        localContext.hostName = testSuiteLogRecord.getHostName();
        localContext.os = testSuiteLogRecord.getOs();
        String[] appVersion = testSuiteLogRecord.getAppVersion().split("\\.");
        if (appVersion.length >= 3) {
            localContext.katalonVersion = appVersion[0] + "." + appVersion[1] + "." + appVersion[2];
        }
        return localContext;
    }

    private DataBindingVariable[] collectDataBinding(ILogRecord logRecord) {
        if (!(logRecord instanceof TestCaseLogRecord)) {
            return null;
        }
        String rawDataBinding = ReportUtil.getTestCaseLogRecordProperty((TestCaseLogRecord)logRecord, "executionBindingVariables");
        List<VariableReport> dataBinding = ReportUtil.parseDataBinding(rawDataBinding);
        if (dataBinding == null) {
            return null;
        }
        ArrayList<DataBindingVariable> variables = new ArrayList<DataBindingVariable>();
        for (VariableReport variable : dataBinding) {
            DataBindingVariable dataBindingVar = new DataBindingVariable();
            dataBindingVar.name = variable.getName();
            dataBindingVar.masked = variable.isMasked();
            dataBindingVar.value = variable.isMasked() ? "" : variable.getValue();
            variables.add(dataBindingVar);
        }
        return variables.toArray(new DataBindingVariable[0]);
    }

    private ExecutedTestStatistics calculateStatistics(ILogRecord logRecord) {
        ILogRecord[] children = logRecord.getChildRecords();
        if (children == null) {
            return null;
        }
        ExecutedTestStatistics stats = new ExecutedTestStatistics();
        stats.total = 0;
        ILogRecord[] iLogRecordArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord child = iLogRecordArray[n2];
            if (!(logRecord instanceof TestSuiteLogRecord) || child instanceof TestCaseLogRecord) {
                this.updateStatistics(stats, child.getStatus().getStatusValue());
                ++stats.total;
            }
            ++n2;
        }
        return stats;
    }

    private <EntityType extends ExecutedTestEntity> void mapCommonProperties(ILogRecord logRecord, EntityType entity) {
        entity.id = UUID.randomUUID().toString();
        entity.name = logRecord.getName();
        entity.description = logRecord.getDescription();
        entity.startTime = logRecord.getStartTime() > 0L ? this.formatDate(logRecord.getStartTime()) : null;
        entity.endTime = logRecord.getEndTime() > 0L ? this.formatDate(logRecord.getEndTime()) : null;
        entity.status = this.mapTestStatus(logRecord);
        entity.result = this.mapTestResult(logRecord);
        entity.message = logRecord.getMessage();
        entity.retryCount = LogRecordHelper.getRetryCount(logRecord);
    }

    private void collectChildrenAndLogMessages(ExecutedTestEntity entity, ILogRecord logRecord, int depth) throws IOException {
        if (depth == 0) {
            return;
        }
        --depth;
        ArrayList<ExecutedTestEntity> children = new ArrayList<ExecutedTestEntity>();
        ArrayList<LogMessage> logMessages = new ArrayList<LogMessage>();
        ILogRecord[] childRecords = logRecord.getChildRecords();
        int stepIndex = 0;
        int i = 0;
        while (i < childRecords.length) {
            ILogRecord stepLogRecord = childRecords[i];
            if (stepLogRecord instanceof MessageLogRecord) {
                LogMessage log = this.mapLogMessage((MessageLogRecord)stepLogRecord);
                logMessages.add(log);
            } else {
                ExecutedTestEntity child = this.mapLogRecord(stepLogRecord, depth);
                if (child != null) {
                    child.index = stepIndex++;
                    children.add(child);
                }
            }
            ++i;
        }
        entity.children = children.toArray(new ExecutedTestEntity[0]);
        entity.logs = logMessages.toArray(new LogMessage[0]);
    }

    private ExecutedTestResult mapTestResult(ILogRecord logRecord) {
        if (logRecord instanceof TestSuiteLogRecord) {
            return TEST_RESULT_MAP.get((Object)logRecord.getStatus().getStatusValue());
        }
        return TEST_RESULT_MAP.get((Object)logRecord.getStatus().getStatusValue());
    }

    private ExecutedTestStatus mapTestStatus(ILogRecord logRecord) {
        return TEST_STATUS_MAP.get((Object)logRecord.getStatus().getStatusValue());
    }

    private LogLevel mapLogLevel(ILogRecord logRecord) {
        return LOG_LEVEL_MAP.get((Object)logRecord.getStatus().getStatusValue());
    }

    private String formatDate(long datetime) {
        return DateTimes.formatISO8601((Date)new Date(datetime));
    }

    private File getReportFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return this.reportFolder != null ? new File(this.reportFolder, path) : file;
    }

    public void toTestExecutionParts(TestSuiteCollectionLogRecord tscLogRecord, ExecutionDataPartHandler partHandler) throws IOException {
        if (partHandler == null || tscLogRecord == null) {
            return;
        }
        partHandler.handle(JsonUtil.toJson((Object)this.toTestExecution(tscLogRecord, 1), false), MAIN_PART_KEY);
        List<TestSuiteLogRecord> children = tscLogRecord.getTestSuiteRecords();
        String testSuiteCollectionLocation = tscLogRecord.getReportFolder();
        int i = 0;
        while (i < children.size()) {
            TestSuiteLogRecord childRecord = children.get(i);
            childRecord.setTestSuiteCollectionLocation(testSuiteCollectionLocation);
            ExecutedTestEntity part = this.mapLogRecord(childRecord, 2);
            this.handleSimplifiedDataPart(partHandler, i, part);
            ++i;
        }
    }

    public TestExecution toTestExecution(TestSuiteCollectionLogRecord tscLogRecord, int depth) throws IOException {
        TestExecution execution = new TestExecution();
        execution.entity = (ExecutedTestEntry)this.mapLogRecord(tscLogRecord, depth);
        execution.project = this.getProject(tscLogRecord.getTestSuiteRecords().get(0));
        return execution;
    }

    private ExecutedTestEntity mapLogRecord(TestSuiteCollectionLogRecord logRecord, int depth) throws IOException {
        ExecutedTestSuiteCollection entity = new ExecutedTestSuiteCollection();
        entity.name = logRecord.getName();
        entity.startTime = this.formatDate(logRecord.getStartTime());
        entity.endTime = this.formatDate(logRecord.getEndTime());
        entity.result = TEST_RESULT_MAP.get((Object)logRecord.getStatus());
        entity.description = logRecord.getDescription();
        entity.entityId = logRecord.getId();
        entity.statistics = this.calculateStatistics(logRecord);
        this.collectChildrenAndLogMessages((ExecutedTestEntity)entity, logRecord, depth);
        TestExecutionContext context = new TestExecutionContext();
        TestSuiteLogRecord testSuite = logRecord.getTestSuiteRecords().get(0);
        context.local = this.collectLocalContext(testSuite);
        context.executedBy = testSuite.getUserFullName();
        entity.context = context;
        return entity;
    }

    private ExecutedTestStatistics calculateStatistics(TestSuiteCollectionLogRecord logRecord) {
        List<TestSuiteLogRecord> testSuites = logRecord.getTestSuiteRecords();
        ExecutedTestStatistics stats = new ExecutedTestStatistics();
        for (TestSuiteLogRecord testSuite : testSuites) {
            TestStatus.TestStatusValue status = testSuite.getStatus().getStatusValue();
            this.updateStatistics(stats, status);
        }
        stats.total = testSuites.size();
        return stats;
    }

    private void updateStatistics(ExecutedTestStatistics stats, TestStatus.TestStatusValue status) {
        switch (status) {
            case PASSED: {
                ++stats.passed;
                break;
            }
            case FAILED: {
                ++stats.failed;
                break;
            }
            case ERROR: {
                ++stats.errored;
                break;
            }
            case WARNING: {
                ++stats.warned;
                break;
            }
            case INCOMPLETE: {
                ++stats.incomplete;
                break;
            }
            case SKIPPED: {
                ++stats.skipped;
                break;
            }
            case NOT_RUN: {
                ++stats.notRun;
                break;
            }
        }
    }

    private void collectChildrenAndLogMessages(ExecutedTestEntity entity, TestSuiteCollectionLogRecord logRecord, int depth) throws IOException {
        if (depth == 0) {
            return;
        }
        --depth;
        ArrayList<ExecutedTestEntity> children = new ArrayList<ExecutedTestEntity>();
        List<TestSuiteLogRecord> childRecords = logRecord.getTestSuiteRecords();
        int stepIndex = 0;
        for (TestSuiteLogRecord stepLogRecord : childRecords) {
            ExecutedTestEntity child = this.mapLogRecord(stepLogRecord, depth);
            if (child == null) continue;
            child.index = stepIndex++;
            children.add(child);
        }
        entity.children = children.toArray(new ExecutedTestEntity[0]);
    }

    private IFailureAnalysisService getFailureAnalysisService() {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (bundleContext != null) {
                IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
                return (IFailureAnalysisService)eclipseContext.get(IFailureAnalysisService.class);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve failure analysis service", (Throwable)e);
        }
        return null;
    }

    public static interface ExecutionDataPartHandler {
        public void handle(String var1, String var2) throws IOException;
    }

    private class SimplifiedDataPart {
        public ExecutedTestEntity[] children;
        public LogMessage[] logs;

        public SimplifiedDataPart(ExecutedTestEntity[] children, LogMessage[] logs) {
            this.children = children;
            this.logs = logs;
        }
    }
}

