/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.newreport.analyzer;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.newreport.analyzer.FailedEntityBuilder;
import com.kms.katalon.core.reporting.newreport.extractor.FailureReasonExtractors;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.core.reporting.service.dto.FailureAnalysisResponse;
import com.kms.katalon.report.core.models.common.ExecutedTestResult;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.report.core.models.entities.FailureAnalysis;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(FailureAnalyzer.class);
    private final FailureReasonExtractors failureReasonExtractors = FailureReasonExtractors.getDefault();
    private final boolean analyzeByAIEnabled;
    private final IFailureAnalysisService failureAnalysisService;
    private final FailedEntityBuilder failedEntityBuilder = new FailedEntityBuilder();

    public FailureAnalyzer(boolean analyzeByAIEnabled, IFailureAnalysisService failureAnalysisService) {
        this.analyzeByAIEnabled = analyzeByAIEnabled;
        this.failureAnalysisService = failureAnalysisService;
    }

    public void analyzeAndEnrich(ExecutedTestEntity entity, ILogRecord logRecord) {
        if (!this.isFailedEntity(entity)) {
            return;
        }
        if (this.isAiAnalysisEnabled()) {
            this.enrichWithAiAnalysis(entity, logRecord);
        } else {
            this.enrichWithBasicExtraction(entity, logRecord);
        }
    }

    private boolean isAiAnalysisEnabled() {
        return this.analyzeByAIEnabled && this.failureAnalysisService != null;
    }

    private boolean isFailedEntity(ExecutedTestEntity entity) {
        return entity != null && (entity.result == ExecutedTestResult.FAILED || entity.result == ExecutedTestResult.ERROR);
    }

    private void enrichWithAiAnalysis(ExecutedTestEntity entity, ILogRecord logRecord) {
        try {
            ExecutedTestEntity failureContext = this.failedEntityBuilder.buildFailedTestEntity(entity);
            FailureAnalysisResponse response = this.failureAnalysisService.executeAnalysis(failureContext);
            if (response != null) {
                this.applyAnalysisResponse(entity, response);
                return;
            }
        }
        catch (Exception e) {
            logger.warn("AI failure analysis failed for entity: " + entity.id, (Throwable)e);
        }
        this.enrichWithBasicExtraction(entity, logRecord);
    }

    private FailureAnalysis mapToFailureAnalysis(FailureAnalysisResponse response) {
        if (response == null) {
            return null;
        }
        FailureAnalysis failureAnalysis = new FailureAnalysis();
        failureAnalysis.setImpact(response.getImpact());
        failureAnalysis.setRecommendation(response.getRecommendation());
        failureAnalysis.setConfidence(response.getConfidence());
        return failureAnalysis;
    }

    private void enrichWithBasicExtraction(ExecutedTestEntity entity, ILogRecord logRecord) {
        TestCaseLogRecord testCaseLogRecord;
        String message;
        String failedReason = "";
        if (logRecord instanceof TestSuiteLogRecord) {
            String message2;
            TestSuiteLogRecord suiteLogRecord = (TestSuiteLogRecord)logRecord;
            ILogRecord[] childRecords = suiteLogRecord.getChildRecords();
            if (childRecords == null || childRecords.length == 0) {
                entity.failedReason = failedReason;
                return;
            }
            Optional<TestCaseLogRecord> firstFailedTestCase = Arrays.stream(childRecords).filter(TestCaseLogRecord.class::isInstance).map(TestCaseLogRecord.class::cast).filter(tc -> this.isFailedLogRecord((ILogRecord)tc)).findFirst();
            if (firstFailedTestCase.isPresent() && StringUtils.isNotBlank((CharSequence)(message2 = firstFailedTestCase.get().getMessage()))) {
                failedReason = this.extractFailedReasonFromMessage(message2);
            }
        } else if (logRecord instanceof TestCaseLogRecord && StringUtils.isNotBlank((CharSequence)(message = (testCaseLogRecord = (TestCaseLogRecord)logRecord).getMessage()))) {
            failedReason = this.extractFailedReasonFromMessage(message);
        }
        entity.failedReason = failedReason;
    }

    private String extractFailedReasonFromMessage(String message) {
        return this.failureReasonExtractors.extract(message).orElse("");
    }

    private void applyAnalysisResponse(ExecutedTestEntity entity, FailureAnalysisResponse response) {
        entity.failedReason = response.getFailedReason();
        entity.failureAnalysis = this.mapToFailureAnalysis(response);
    }

    private boolean isFailedLogRecord(ILogRecord logRecord) {
        return logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.FAILED || logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.ERROR;
    }
}

