/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.setting;

import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.ReportSettings;
import java.io.IOException;

public class ReportBundleSettingStore
extends BundleSettingStore {
    private static final String LEGACY_REPORT_BUNDLE_ID = "com.katalon.plugin.report";
    private static final String GENERATE_HTML_REPORT_KEY = "generateHTML";
    private static final String GENERATE_CSV_REPORT_KEY = "generateCSV";
    private static final String GENERATE_PDF_REPORT_KEY = "generatePDF";
    private static final String GENERATE_CONSOLE_LOG_REPORT_KEY = "generateConsoleLog";
    private static final String USE_SPLIT_REPORT_DATA_KEY = "useSplitReportData";
    private static final String USE_IMAGE_REFERENCES_KEY = "useHTMLImageReferences";
    private static final String USE_NEW_REPORT_KEY = "applyNewReport";
    private static final String USE_ANALYZE_FAILED_REASON_BY_AI_KEY = "analyzeFailedReasonByAi";

    public ReportBundleSettingStore(String projectDir) {
        super(projectDir, LEGACY_REPORT_BUNDLE_ID, true);
    }

    public static ReportBundleSettingStore getStore(String projectDir) {
        return new ReportBundleSettingStore(projectDir);
    }

    public boolean useGenerateHTML() throws IOException {
        return this.getBoolean(GENERATE_HTML_REPORT_KEY, true);
    }

    public void setGenerateHTML(boolean enabled) throws IOException {
        this.setProperty(GENERATE_HTML_REPORT_KEY, enabled);
    }

    public boolean useGenerateCSV() throws IOException {
        return this.getBoolean(GENERATE_CSV_REPORT_KEY, true);
    }

    public void setGenerateCSV(boolean enabled) throws IOException {
        this.setProperty(GENERATE_CSV_REPORT_KEY, enabled);
    }

    public boolean useGeneratePDF() throws IOException {
        return this.getBoolean(GENERATE_PDF_REPORT_KEY, false);
    }

    public void setGeneratePDF(boolean enabled) throws IOException {
        this.setProperty(GENERATE_PDF_REPORT_KEY, enabled);
    }

    public boolean useGenerateConsoleLog() throws IOException {
        return this.getBoolean(GENERATE_CONSOLE_LOG_REPORT_KEY, true);
    }

    public void setGenerateConsoleLog(boolean enabled) throws IOException {
        this.setProperty(GENERATE_CONSOLE_LOG_REPORT_KEY, enabled);
    }

    public boolean useHTMLImageReferences() throws IOException {
        return this.getBoolean(USE_IMAGE_REFERENCES_KEY, false);
    }

    public void setUseHTMLImageReferences(boolean enabled) throws IOException {
        this.setProperty(USE_IMAGE_REFERENCES_KEY, enabled);
    }

    public boolean useNewReport() throws IOException {
        return this.getBoolean(USE_NEW_REPORT_KEY, true);
    }

    public void setNewReport(boolean enabled) throws IOException {
        this.setProperty(USE_NEW_REPORT_KEY, enabled);
    }

    public boolean useSplitReportData() throws IOException {
        return this.getBoolean(USE_SPLIT_REPORT_DATA_KEY, false);
    }

    public void setSplitReportData(boolean enabled) throws IOException {
        this.setProperty(USE_SPLIT_REPORT_DATA_KEY, enabled);
    }

    public void setUseAnalyzeFailedReasonByAI(boolean enabled) throws IOException {
        this.setProperty(USE_ANALYZE_FAILED_REASON_BY_AI_KEY, enabled);
    }

    public boolean useAnalyzeFailedReasonByAI() throws IOException {
        return this.getBoolean(USE_ANALYZE_FAILED_REASON_BY_AI_KEY, false);
    }

    public ReportSettings getSettings() throws IOException {
        ReportSettings settings = new ReportSettings();
        settings.useHTMLImageReferences = this.useHTMLImageReferences();
        settings.generateHTMLReport = this.useGenerateHTML();
        settings.generateCSVReport = this.useGenerateCSV();
        settings.generatePDFReport = this.useGeneratePDF();
        settings.generateConsoleLogReport = this.useGenerateConsoleLog();
        settings.applyNewReport = this.useNewReport();
        settings.useSplitReportData = this.useSplitReportData();
        settings.useAnalyzeFailedReasonByAI = this.useAnalyzeFailedReasonByAI();
        return settings;
    }
}

