/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testcase;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.core.testcase.Variable;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.util.SAXReaderProvider;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class TestCaseFactory {
    private static final String TEST_CASE_META_ROOT_FOLDER_NAME = "Test Cases";
    private static final String TEST_CASE_ID_PREFIX = "Test Cases/";
    static final String TEMP_TEST_CASE_META_ROOT_FOLDER_NAME = "Libs";
    private static final String TEST_CASE_SCRIPT_ROOT_FOLDER_NAME = "Scripts";
    private static final String TEST_CASE_SCRIPT_ID_PREFIX = "Scripts/";
    private static final String TEST_CASE_SCRIPT_FILE_EXTENSION = "groovy";
    static final String TEST_CASE_META_FILE_EXTENSION = ".tc";
    private static final String DESCRIPTION_NODE_NAME = "description";
    private static final String TAG_NODE_NAME = "tag";
    private static final String ORIGIN_NODE_NAME = "origin";
    private static final String VARIABLE_NODE_NAME = "variable";
    private static final String TEMP_NODE_NAME = "temp";
    private static final String VARIABLE_NAME_PROPERTY = "name";
    private static final String VARIABLE_DEFAULTVALUE_PROPERTY = "defaultValue";
    private static final String VARIABLE_MASKED_PROPERTY = "masked";

    public static TestCase findTestCase(String testCaseRelativeId) throws IllegalArgumentException {
        if (testCaseRelativeId == null) {
            throw new IllegalArgumentException(StringConstants.TEST_CASE_FACTORY_MSG_ID_IS_NULL);
        }
        String testCaseId = TestCaseFactory.getTestCaseId(testCaseRelativeId);
        File testCaseMetaFile = new File(TestCaseFactory.getProjectDirPath() + File.separator + testCaseId + TEST_CASE_META_FILE_EXTENSION);
        if (testCaseMetaFile.exists()) {
            return TestCaseFactory.readTestCase(testCaseId, testCaseMetaFile);
        }
        throw new IllegalArgumentException(MessageFormat.format(StringConstants.TEST_CASE_FACTORY_MSG_TC_NOT_EXISTED, testCaseId));
    }

    private static TestCase readTestCase(String testCaseId, File testCaseMetaFile) {
        try {
            SAXReader reader = SAXReaderProvider.newInstance();
            Document document = reader.read(testCaseMetaFile);
            Element rootElement = document.getRootElement();
            TestCase testCase = new TestCase(testCaseId);
            testCase.setDescription(rootElement.element(DESCRIPTION_NODE_NAME).getText());
            testCase.setTag(rootElement.element(TAG_NODE_NAME).getText());
            Element originElement = rootElement.element(ORIGIN_NODE_NAME);
            testCase.setOrigin(originElement != null ? originElement.getText() : "");
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (Object variableObject : rootElement.elements(VARIABLE_NODE_NAME)) {
                Element variableElement = (Element)variableObject;
                Variable variable = new Variable();
                variable.setName(variableElement.elementText(VARIABLE_NAME_PROPERTY));
                variable.setDefaultValue(variableElement.elementText(VARIABLE_DEFAULTVALUE_PROPERTY));
                String maskValueAsText = variableElement.elementText(VARIABLE_MASKED_PROPERTY);
                variable.setMasked(StringUtils.isNotEmpty((String)maskValueAsText) ? Boolean.valueOf(maskValueAsText).booleanValue() : variable.isMasked());
                variables.add(variable);
            }
            testCase.setVariables(variables);
            return testCase;
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.TEST_CASE_FACTORY_MSG_TC_NOT_EXISTED_WITH_REASON, testCaseId, ExceptionsUtil.getMessageForThrowable(e)));
        }
        catch (SAXException e) {
            throw new KatalonRuntimeException(e);
        }
    }

    public static String getTestCaseId(String testCaseRelativeId) {
        if (testCaseRelativeId == null) {
            return testCaseRelativeId;
        }
        if (testCaseRelativeId.startsWith(TEST_CASE_ID_PREFIX)) {
            return testCaseRelativeId;
        }
        return TEST_CASE_ID_PREFIX + testCaseRelativeId;
    }

    public static String getTestCaseRelativeId(String testCaseId) {
        if (testCaseId == null) {
            return null;
        }
        return testCaseId.replaceFirst(TEST_CASE_ID_PREFIX, "");
    }

    static String getProjectDirPath() {
        return new File(RunConfiguration.getProjectDir()).getAbsolutePath();
    }

    static String getScriptPathByTestCaseId(String testCaseId) throws IOException {
        String testCaseScriptRelativePath = testCaseId.replaceFirst(TEST_CASE_ID_PREFIX, TEST_CASE_SCRIPT_ID_PREFIX).replace("/", File.separator);
        File testCaseScriptFolder = new File(TestCaseFactory.getProjectDirPath(), testCaseScriptRelativePath);
        if (!testCaseScriptFolder.exists()) {
            return "";
        }
        File[] testCaseScriptFiles = testCaseScriptFolder.listFiles();
        if (testCaseScriptFiles == null) {
            return "";
        }
        File[] fileArray = testCaseScriptFiles;
        int n = testCaseScriptFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (TEST_CASE_SCRIPT_FILE_EXTENSION.equals(FilenameUtils.getExtension((String)file.getName()))) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return "";
    }

    static String getScriptClassNameByTestCaseId(String testCaseId) throws IOException {
        return FilenameUtils.getBaseName((String)TestCaseFactory.getScriptPathByTestCaseId(testCaseId));
    }
}

