/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import java.util.EnumMap;
import java.util.Map;

public class MobileTestObject
extends TestObject {
    private LocatorStrategy locatorStrategy;
    private Map<LocatorStrategy, String> locatorCollection = new EnumMap<LocatorStrategy, String>(LocatorStrategy.class);
    private MobilePlatform platform;

    public MobileTestObject(String objectId) {
        super(objectId);
    }

    @Deprecated
    public String getLocator() {
        return this.locatorCollection.get((Object)this.locatorStrategy);
    }

    @Deprecated
    public void setLocator(String locator) {
        this.locatorCollection.put(this.locatorStrategy, locator);
    }

    public LocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public Map<LocatorStrategy, String> getLocatorCollection() {
        return this.locatorCollection;
    }

    public void setLocatorCollection(Map<LocatorStrategy, String> locatorCollection) {
        this.locatorCollection.clear();
        if (locatorCollection != null && !locatorCollection.isEmpty()) {
            this.locatorCollection.putAll(locatorCollection);
        }
    }

    public void setLocatorValue(LocatorStrategy locatorStrategy, String locator) {
        this.locatorCollection.put(locatorStrategy, locator);
    }

    public MobilePlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(MobilePlatform platform) {
        this.platform = platform;
    }

    public static MobileTestObject cloneFromTestObject(TestObject source) {
        String devicePlatform;
        MobileTestObject mobileTestObject = new MobileTestObject(source.getObjectId());
        mobileTestObject.setProperties(source.getProperties());
        mobileTestObject.setXpaths(source.getXpaths());
        mobileTestObject.setSelectorMethod(source.getSelectorMethod());
        mobileTestObject.setSelectorValue(source.getSelectorMethod(), source.getSelectorCollection().get((Object)source.getSelectorMethod()));
        mobileTestObject.setSmartSelectorCollection(source.getSmartSelectorCollection());
        mobileTestObject.setImagePath(source.getImagePath());
        mobileTestObject.setUseRelativeImagePath(source.getUseRelativeImagePath());
        mobileTestObject.setParentObject(source.getParentObject());
        mobileTestObject.setParentObjectShadowRoot(source.isParentObjectShadowRoot());
        if (source.getCachedWebElement() != null) {
            mobileTestObject.setCachedWebElement(source.getCachedWebElement());
        }
        LocatorStrategy locatorStrategy = MobileTestObject.mapSelectorMethodToLocatorStrategy(source.getSelectorMethod());
        String locator = source.getSelectorCollection().get((Object)source.getSelectorMethod());
        if (locatorStrategy != null && locator != null) {
            mobileTestObject.setLocatorStrategy(locatorStrategy);
            mobileTestObject.setLocatorValue(locatorStrategy, locator);
        }
        if ("ANDROID_DRIVER".equals(devicePlatform = RunConfiguration.getDevicePlatform())) {
            mobileTestObject.setPlatform(MobilePlatform.ANDROID);
        } else if ("IOS_DRIVER".equals(devicePlatform)) {
            mobileTestObject.setPlatform(MobilePlatform.IOS);
        }
        return mobileTestObject;
    }

    private static LocatorStrategy mapSelectorMethodToLocatorStrategy(SelectorMethod selectorMethod) {
        if (selectorMethod == null) {
            return null;
        }
        switch (selectorMethod) {
            case BASIC: {
                return LocatorStrategy.ATTRIBUTES;
            }
            case XPATH: {
                return LocatorStrategy.XPATH;
            }
        }
        return null;
    }
}

