/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

public enum OAuth2GrantType {
    AUTHORIZATION_CODE("Authorization Code"),
    CLIENT_CREDENTIALS("Client Credentials"),
    PASSWORD_CREDENTIALS("Password Credentials"),
    REFRESH_TOKEN("Refresh Token");

    private final String displayName;

    private OAuth2GrantType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static OAuth2GrantType fromDisplayName(String displayName) {
        OAuth2GrantType[] oAuth2GrantTypeArray = OAuth2GrantType.values();
        int n = oAuth2GrantTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OAuth2GrantType type = oAuth2GrantTypeArray[n2];
            if (type.getDisplayName().equals(displayName)) {
                return type;
            }
            ++n2;
        }
        try {
            return OAuth2GrantType.valueOf(displayName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown grant type display name: " + displayName);
        }
    }
}

