/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.trace;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TraceDebug {
    private static File logFile;
    private static Writer writer;
    private static final AtomicBoolean initialized;

    static {
        initialized = new AtomicBoolean(false);
    }

    private TraceDebug() {
    }

    public static void init(File file) {
        if (file == null) {
            return;
        }
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        try {
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));
            logFile = file;
            TraceDebug.writeLine("TraceDebug initialized -> " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {}
    }

    public static void writeLine(String line) {
        if (writer == null) {
            return;
        }
        try {
            String ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
            writer.write("[" + ts + "] " + line + "\n");
            writer.flush();
        }
        catch (Throwable throwable) {}
    }

    public static File getLogFile() {
        return logFile;
    }
}

