/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.trace;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.ExecutionListenerEventHandler;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.VideoRecorderUtil;
import com.kms.katalon.core.util.internal.TestOpsUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TraceRecorderService
implements ExecutionListenerEventHandler {
    private static final String TRACE_KEYWORD_NAME = "Trace";
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private Object session;
    private final Map<Integer, String> callIds = new ConcurrentHashMap<Integer, String>();
    private ScheduledExecutorService screencastExec;

    @Override
    public void handleListenerEvent(ExecutionListenerEvent listenerEvent, Object[] injectedObjects) {
        try {
            switch (listenerEvent) {
                case BEFORE_TEST_CASE: {
                    this.onBeforeTestCase((InternalTestCaseContext)injectedObjects[0]);
                    break;
                }
                case AFTER_TEST_CASE: {
                    this.onAfterTestCase((InternalTestCaseContext)injectedObjects[0]);
                    break;
                }
                case BEFORE_TEST_STEP: {
                    this.onBeforeTestStep(injectedObjects);
                    break;
                }
                case AFTER_TEST_STEP: {
                    this.onAfterTestStep(injectedObjects);
                    break;
                }
            }
        }
        catch (Throwable t) {
            TraceRecorderService.traceDebug("TraceRecorderService error: " + t.getMessage());
        }
    }

    private void onBeforeTestCase(InternalTestCaseContext ctx) {
        boolean decision = RunConfiguration.shouldTraceFor(ctx);
        int suiteRerunIndex = RunConfiguration.getSuiteRerunIndex();
        int tcRetry = ctx != null ? ctx.getRetryIndex() : 0;
        TraceRecorderService.traceDebug("Trace decision: mode=" + String.valueOf((Object)RunConfiguration.getTraceMode()) + " tcRetry=" + tcRetry + " suiteRerunIndex=" + suiteRerunIndex + " retryRun=" + Math.max(tcRetry, suiteRerunIndex) + " decision=" + decision);
        if (!decision) {
            TraceRecorderService.traceHolderSetSession(null);
            this.session = null;
            return;
        }
        try {
            Class<?> har = Class.forName("com.kms.katalon.core.webui.trace.HarTracer");
            har.getMethod("stopAndFlush", Long.TYPE).invoke(null, 0L);
        }
        catch (Throwable throwable) {}
        File reportDir = new File(RunConfiguration.getReportFolder());
        String safeId = TraceRecorderService.sanitize(ctx.getTestCaseId());
        File tempTracingDir = new File(reportDir, "tmp/tracing/" + safeId);
        TraceRecorderService.traceDebugInit(new File(tempTracingDir, "trace-debug-" + safeId + ".log"));
        File tracesDir = tempTracingDir;
        this.session = TraceRecorderService.newTraceSession(tracesDir);
        TraceRecorderService.traceHolderSetSession(this.session);
        TraceRecorderService.invoke(this.session, "start", ctx.getTestCaseId());
        TraceRecorderService.traceDebug("TraceRecorderService: session created at " + tracesDir.getAbsolutePath());
        try {
            Class<?> ki = Class.forName("com.kms.katalon.core.webui.trace.KeywordInterceptor");
            ki.getMethod("reset", new Class[0]).invoke(null, new Object[0]);
            ki.getMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {}
        this.screencastExec = Executors.newSingleThreadScheduledExecutor();
        this.screencastExec.scheduleAtFixedRate(() -> {
            try {
                TraceRecorderService.invoke(this.session, "captureScreencastFrame", new Object[0]);
            }
            catch (Throwable throwable) {}
        }, 500L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void onAfterTestCase(InternalTestCaseContext ctx) {
        if (this.session == null) {
            return;
        }
        try {
            File reportDir = new File(RunConfiguration.getReportFolder());
            String safeId = TraceRecorderService.sanitize(ctx.getTestCaseId());
            File tempTracingDir = new File(reportDir, "tmp/tracing/" + safeId);
            File tracesOutDir = new File(reportDir, "traces");
            String baseName = TraceRecorderService.buildTraceFileName(ctx);
            File out = new File(tracesOutDir, baseName);
            int n = 1;
            while (out.exists() && n < 1000) {
                String candidate = baseName.replaceFirst("\\.ktrace$", "-" + n + ".ktrace");
                out = new File(tracesOutDir, candidate);
                ++n;
            }
            TraceRecorderService.invoke(this.session, "stopChunk", out);
            TraceRecorderService.traceDebug("TraceRecorderService: packaged -> " + out.getAbsolutePath());
            this.cleanupTempTracingDir(tempTracingDir);
            this.maybeDeleteOnPass(ctx, out);
            this.logTraceRecordingStep(ctx, out);
        }
        catch (Throwable throwable) {
            TraceRecorderService.traceHolderSetSession(null);
            this.session = null;
            try {
                if (this.screencastExec != null) {
                    this.screencastExec.shutdownNow();
                }
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        TraceRecorderService.traceHolderSetSession(null);
        this.session = null;
        try {
            if (this.screencastExec != null) {
                this.screencastExec.shutdownNow();
            }
        }
        catch (Throwable throwable) {}
    }

    private void cleanupTempTracingDir(File tempTracingDir) {
        if (tempTracingDir == null || !tempTracingDir.exists()) {
            return;
        }
        File[] children = tempTracingDir.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String name = child.getName();
            if (!(child.isFile() && name.startsWith("trace-debug-") && name.endsWith(".log"))) {
                this.deleteRecursively(child);
            }
            ++n2;
        }
    }

    private void deleteRecursively(File file) {
        File[] children;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteRecursively(child);
                ++n2;
            }
        }
        try {
            file.delete();
        }
        catch (Throwable throwable) {}
    }

    private void onBeforeTestStep(Object[] info) {
        if (this.session == null || !TraceRecorderService.getRecordingFlag(this.session)) {
            return;
        }
        int stepIdx = (Integer)info[0];
        String description = info.length > 1 ? String.valueOf(Objects.requireNonNullElse(info[1], "")) : "";
        String keywordName = info.length > 2 ? String.valueOf(Objects.requireNonNullElse(info[2], "")) : "";
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (!description.isEmpty()) {
            params.put("runtimeDescription", description);
        }
        if (!keywordName.isEmpty()) {
            params.put("runtimeAction", keywordName);
        }
        params.put("runtimeStepIndex", stepIdx);
        params.put("runtimePhase", "Before");
        String runtimeTitle = !description.isEmpty() ? description : (!keywordName.isEmpty() ? keywordName : "Step " + stepIdx);
        String title = "Before " + runtimeTitle;
        String callId = (String)TraceRecorderService.invoke(this.session, "beginStep", title, params);
        this.callIds.put(stepIdx, callId);
    }

    private void onAfterTestStep(Object[] info) {
        if (this.session == null || !TraceRecorderService.getRecordingFlag(this.session)) {
            return;
        }
        int stepIdx = (Integer)info[0];
        String callId = this.callIds.remove(stepIdx);
        if (callId == null) {
            return;
        }
        String description = info.length > 1 ? String.valueOf(Objects.requireNonNullElse(info[1], "")) : "";
        String keywordName = info.length > 2 ? String.valueOf(Objects.requireNonNullElse(info[2], "")) : "";
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put("runtimePhase", "After");
        meta.put("runtimeStepIndex", stepIdx);
        if (!description.isEmpty()) {
            meta.put("runtimeDescription", description);
        }
        if (!keywordName.isEmpty()) {
            meta.put("runtimeAction", keywordName);
        }
        TraceRecorderService.invoke(this.session, "endStep", callId, "ok", meta);
    }

    private static Object newTraceSession(File dir) {
        try {
            Class<?> cls = Class.forName("com.kms.katalon.core.webui.trace.TraceSession");
            return cls.getDeclaredConstructor(File.class).newInstance(dir);
        }
        catch (Throwable t) {
            TraceRecorderService.traceDebugStatic("TraceRecorderService: cannot instantiate TraceSession " + t.getMessage());
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Object invoke(Object target, String method, Object ... args) {
        if (target == null) {
            return null;
        }
        try {
            m = target.getClass().getMethod("invokeMethod", new Class[]{String.class, Object.class});
            return m.invoke(target, new Object[]{method, args});
        }
        catch (NoSuchMethodException v0) {
            var6_6 = target.getClass().getMethods();
            var5_7 = var6_6.length;
            var4_8 = 0;
            ** while (var4_8 < var5_7)
        }
lbl-1000:
        // 1 sources

        {
            cand = var6_6[var4_8];
            if (cand.getName().equals(method) && cand.getParameterCount() == args.length) {
                try {
                    cand.setAccessible(true);
                    return cand.invoke(target, args);
                }
                catch (Throwable v1) {}
            }
            ++var4_8;
            continue;
        }
lbl19:
        // 1 sources

        TraceRecorderService.traceDebugStatic("TraceRecorderService invoke " + method + " missing");
        return null;
        catch (Throwable t) {
            TraceRecorderService.traceDebugStatic("TraceRecorderService invoke " + method + " error " + t.getMessage());
            return null;
        }
    }

    private static boolean getRecordingFlag(Object session) {
        try {
            Method m = session.getClass().getMethod("getRecording", new Class[0]);
            Object val = m.invoke(session, new Object[0]);
            return Boolean.TRUE.equals(val);
        }
        catch (Throwable throwable) {
            try {
                Method m = session.getClass().getMethod("isRecording", new Class[0]);
                Object val = m.invoke(session, new Object[0]);
                return Boolean.TRUE.equals(val);
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
    }

    private static String sanitize(String s) {
        return (s == null ? "" : s).replaceAll("[\\\\/:*?\"<>|\\n\\r\\t ]+", "-");
    }

    private static String buildTraceFileName(InternalTestCaseContext ctx) {
        String raw = ctx != null ? ctx.getTestCaseName() : null;
        Object base = VideoRecorderUtil.getTestCaseNameFromFullPath(raw);
        base = TraceRecorderService.sanitize((String)base).replaceAll("-{2,}", "-");
        if (((String)(base = ((String)base).replaceAll("^-", "").replaceAll("-$", ""))).isEmpty()) {
            base = "trace";
        }
        if (((String)base).length() > 120) {
            String hash = Integer.toHexString(((String)base).hashCode());
            int keep = Math.max(1, 120 - (hash.length() + 2));
            base = ((String)base).substring(0, keep) + "--" + hash;
        }
        int index = ctx != null ? ctx.getTestCaseIndex() : 0;
        int retryIdx = ctx != null ? ctx.getRetryIndex() : 0;
        return (String)base + "_" + (index + 1) + "_" + retryIdx + ".ktrace";
    }

    private static void traceHolderSetSession(Object s) {
        try {
            Class<?> cls = Class.forName("com.kms.katalon.core.trace.TraceHolder");
            cls.getMethod("setSession", Object.class).invoke(null, s);
        }
        catch (Throwable throwable) {}
    }

    private static void traceDebugInit(File file) {
        try {
            Class<?> cls = Class.forName("com.kms.katalon.core.trace.TraceDebug");
            cls.getMethod("init", File.class).invoke(null, file);
        }
        catch (Throwable throwable) {}
    }

    private static void traceDebug(String msg) {
        TraceRecorderService.traceDebugStatic(msg);
    }

    private static void traceDebugStatic(String msg) {
        try {
            Class<?> cls = Class.forName("com.kms.katalon.core.trace.TraceDebug");
            cls.getMethod("writeLine", String.class).invoke(null, msg);
        }
        catch (Throwable throwable) {}
    }

    private void maybeDeleteOnPass(InternalTestCaseContext ctx, File out) {
        RunConfiguration.TraceMode mode = RunConfiguration.getTraceMode();
        if (mode == RunConfiguration.TraceMode.ON_FAILURE || mode == RunConfiguration.TraceMode.ON_FIRST_FAILURE) {
            String status;
            String string = status = ctx != null ? ctx.getTestCaseStatus() : null;
            if (status != null && "PASSED".equalsIgnoreCase(status) && out != null && out.exists()) {
                out.delete();
            }
        }
    }

    private void logTraceRecordingStep(InternalTestCaseContext ctx, File out) {
        if (ctx == null || out == null || !out.exists()) {
            return;
        }
        String relativePath = TestOpsUtil.getRelativePathForLog(out.getAbsolutePath());
        if (relativePath == null || relativePath.isEmpty()) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attachment", relativePath);
        String message = "Trace recording for test case '" + ctx.getTestCaseId() + "'.";
        this.logger.startKeyword(TRACE_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
        this.logger.logInfo(message, attributes);
        this.logger.endKeyword(TRACE_KEYWORD_NAME, new HashMap<String, String>(), new Stack<KeywordLogger.KeywordStackElement>());
    }
}

