/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.trace;

import com.kms.katalon.core.trace.TraceDebug;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public final class TraceUtils {
    private TraceUtils() {
    }

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static String sha1Hex(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(bytes);
            StringBuilder sb = new StringBuilder(digest.length * 2);
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b));
                ++n2;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    public static void ensureDir(File dir) {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void writeBytes(File file, byte[] bytes) {
        if (file == null || bytes == null) {
            return;
        }
        TraceUtils.ensureDir(file.getParentFile());
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(bytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public static void appendJsonLine(File file, Map<String, Object> event) {
        if (file == null || event == null) {
            return;
        }
        TraceUtils.ensureDir(file.getParentFile());
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fos = new FileOutputStream(file, true);){
                String line = JsonUtil.toJson(event, false) + "\n";
                fos.write(line.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        try {
            Object type = event.get("type");
            Object snapshot = event.get("snapshot");
            String kind = type != null ? String.valueOf(type) : (snapshot != null ? "frame-snapshot" : "unknown");
            TraceDebug.writeLine("appendJsonLine: " + kind + " -> " + file.getName());
        }
        catch (Throwable throwable) {}
    }

    public static byte[] pngToJpeg(byte[] pngBytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(pngBytes);
            BufferedImage img = ImageIO.read(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpeg", baos);
            return baos.toByteArray();
        }
        catch (Throwable throwable) {
            return pngBytes;
        }
    }

    public static void zipEntries(File zipFile, List<Map<String, Object>> entries) {
        if (zipFile == null) {
            return;
        }
        TraceUtils.ensureDir(zipFile.getParentFile());
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
                for (Map<String, Object> e : entries) {
                    Object nameObj = e.get("name");
                    Object fileObj = e.get("file");
                    if (!(nameObj instanceof String) || !(fileObj instanceof File)) continue;
                    String name = (String)nameObj;
                    File src = (File)fileObj;
                    if (src == null || !src.exists()) continue;
                    try {
                        TraceDebug.writeLine("zip: add " + name + " size=" + src.length());
                    }
                    catch (Throwable throwable2) {}
                    zos.putNextEntry(new ZipEntry(name.replace('\\', '/')));
                    Throwable throwable3 = null;
                    Object var12_15 = null;
                    try (FileInputStream fis = new FileInputStream(src);){
                        fis.transferTo(zos);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    zos.closeEntry();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        try {
            TraceDebug.writeLine("zip: wrote " + zipFile.getAbsolutePath() + " size=" + zipFile.length());
        }
        catch (Throwable throwable) {}
    }
}

