/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import in.wilsonl.minifyhtml.Configuration;
import in.wilsonl.minifyhtml.MinifyHtml;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class HTMLMinifier {
    private String originalHTML;
    private Document document;
    private boolean debuggingEnabled = true;
    private static final String HIDDEN_ELEMENT_SELECTOR = StringUtils.join(Arrays.asList("script", "style", "noscript", "link", "meta", "head", "base", "template", "slot", "iframe", "object", "embed", "track", "param", "source", "picture", "*[style*=\"display: none\"]", "*[style*=\"display:none\"]", "*[style*=\"visibility: hidden\"]", "*[style*=\"visibility:hidden\"]", "*[style*=\"opacity: 0\"]", "*[style*=\"opacity:0\"]", "svg", "footer"), (String)",");
    private static final int MAX_ATTRIBUTE_VALUE_LENGTH = 50;
    private static final int MAX_TEXT_CONTENT_LENGTH = 100;

    public HTMLMinifier(String html) {
        this.originalHTML = html;
    }

    private void parseHTML() {
        this.document = Jsoup.parse((String)this.originalHTML, (String)"", (Parser)Parser.xmlParser());
        this.document.outputSettings().prettyPrint(false);
    }

    public String minify() {
        return this.minify(null);
    }

    public String minify(String locator) {
        String minifiedDOM = this.minifyDOM(locator);
        String minifiedHTML = this.minifyHTML(minifiedDOM);
        int originalLength = this.originalHTML.length();
        int minifiedLength = this.buildHTML().length();
        System.out.println(MessageFormat.format(">>> Total: {0} -> {1} (-{2,number,#.##}%)", originalLength, minifiedLength, ((double)originalLength - (double)minifiedLength) / (double)originalLength * 100.0));
        return minifiedHTML;
    }

    protected String minifyDOM(String locator) {
        this.parseHTML();
        this.runDOMMinizationPhase("Remove hidden elements", () -> this.removeHiddenElements());
        this.runDOMMinizationPhase("Remove next siblings", () -> this.removeUnusedSiblings(locator));
        this.runDOMMinizationPhase("Remove redundant parents", () -> this.removeRedundantParents());
        this.runDOMMinizationPhase("Remove event handler attributes", () -> this.removeEventHandlerAttributes());
        this.runDOMMinizationPhase("Trim long attributes", () -> this.trimLongAttributes());
        this.runDOMMinizationPhase("Trim long text", () -> this.trimLongText());
        return this.buildHTML();
    }

    protected void runDOMMinizationPhase(String name, Runnable phase) {
        if (this.debuggingEnabled) {
            int beforeSize = this.buildHTML().length();
            phase.run();
            int afterSize = this.buildHTML().length();
            this.log(name, beforeSize, afterSize);
        } else {
            phase.run();
        }
    }

    private void log(String label, int beforeSize, int afterSize) {
        int originalSize = this.originalHTML.length();
        System.out.println(MessageFormat.format("> {0}: {1} -> {2} (-{3,number,#.##}%)", label, beforeSize, afterSize, ((double)beforeSize - (double)afterSize) / (double)originalSize * 100.0));
    }

    protected String buildHTML() {
        return this.document.toString();
    }

    protected String minifyHTML(String html) {
        int beforeSize = html.length();
        Configuration configs = new Configuration.Builder().setKeepHtmlAndHeadOpeningTags(false).setMinifyCss(true).setMinifyJs(true).setMinifyDoctype(true).setKeepInputTypeTextAttr(false).setKeepComments(false).setKeepSsiComments(false).setKeepClosingTags(false).setAllowNoncompliantUnquotedAttributeValues(true).setAllowRemovingSpacesBetweenAttributes(true).setAllowOptimalEntities(false).setPreserveBraceTemplateSyntax(false).setPreserveChevronPercentTemplateSyntax(false).setRemoveProcessingInstructions(true).setRemoveBangs(true).build();
        String minimizedHTML = MinifyHtml.minify((String)html, (Configuration)configs);
        int afterSize = minimizedHTML.length();
        if (this.debuggingEnabled) {
            this.log("Minify HTML syntax", beforeSize, afterSize);
        }
        return minimizedHTML;
    }

    private void removeHiddenElements() {
        Elements elements = this.document.select(HIDDEN_ELEMENT_SELECTOR);
        for (Element element : elements) {
            element.remove();
        }
    }

    private void removeUnusedSiblings(String targetLocator) {
        if (StringUtils.isBlank((CharSequence)targetLocator)) {
            return;
        }
        Elements matchedElements = this.document.select(targetLocator);
        if (CollectionUtils.isEmpty((Collection)matchedElements)) {
            return;
        }
        matchedElements.forEach(matchedElement -> this.removeUnusedSiblings((Element)matchedElement));
    }

    private void removeUnusedSiblings(Element element) {
        Elements parents = element.parents();
        Element anchorElement = element;
        for (Element parent : parents) {
            int anchorIndex = anchorElement.elementSiblingIndex();
            Elements children = parent.children();
            for (Element child : children) {
                if (child.elementSiblingIndex() <= anchorIndex) continue;
                child.remove();
            }
            anchorElement = parent;
        }
    }

    private void removeRedundantParents() {
        this.removeRedundantParents(this.getRootElement());
    }

    private void removeRedundantParents(Element root) {
        boolean isOnlyChild;
        Elements children = root.children();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        Element firstChild = (Element)children.get(0);
        boolean bl = isOnlyChild = children.size() == 1 && firstChild.children().size() == 1 && "div".equalsIgnoreCase(firstChild.tagName()) && firstChild.attributes().size() == 0;
        if (isOnlyChild) {
            root.replaceWith((Node)firstChild);
            this.removeRedundantParents(firstChild);
            return;
        }
        children.forEach(child -> this.removeRedundantParents((Element)child));
    }

    private void removeEventHandlerAttributes() {
        this.removeEventHandlerAttributes(this.getRootElement());
    }

    private void removeEventHandlerAttributes(Element root) {
        Attributes attributes = root.attributes();
        ArrayList<String> tobeRemovedAttributes = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            String attributeKey = attribute.getKey();
            if (!attributeKey.startsWith("on")) continue;
            tobeRemovedAttributes.add(attributeKey);
        }
        tobeRemovedAttributes.forEach(attributeName -> root.removeAttr(attributeName));
        root.children().forEach(child -> this.removeEventHandlerAttributes((Element)child));
    }

    private void trimLongAttributes() {
        this.trimLongAttributes(this.getRootElement());
    }

    private void trimLongAttributes(Element root) {
        root.removeAttr("style");
        Attributes attributes = root.attributes();
        for (Attribute attribute : attributes) {
            String attributeValue;
            String attributeKey = attribute.getKey();
            if (Strings.CS.equalsAny((CharSequence)attributeKey, new CharSequence[]{"class", "value", "id", "name"}) || Strings.CS.equalsAny((CharSequence)attributeKey, new CharSequence[]{"aria-"}) || !StringUtils.isNotBlank((CharSequence)(attributeValue = attribute.getValue())) || attributeValue.length() <= 50) continue;
            String trimmedAttributeValue = this.trimLongText(attributeValue, 50);
            root.attr(attributeKey, trimmedAttributeValue);
        }
        root.children().forEach(child -> this.trimLongAttributes((Element)child));
    }

    private void trimLongText() {
        this.trimLongText(this.getRootElement());
    }

    private void trimLongText(Element root) {
        root.childNodes().forEach(childNode -> {
            if (childNode instanceof TextNode) {
                TextNode textNode = (TextNode)childNode;
                String text = textNode.text().trim();
                textNode.text(this.trimLongText(text, 100));
                return;
            }
            if (childNode instanceof Element) {
                Element childElement = (Element)childNode;
                this.trimLongText(childElement);
            }
        });
    }

    private String trimLongText(String text, int maxLength) {
        return text.length() > maxLength ? StringUtils.substring((String)text.trim(), (int)0, (int)(maxLength - 3)) + "..." : text.trim();
    }

    protected Element getRootElement() {
        Element body = this.document.selectFirst("body");
        if (body != null) {
            return body;
        }
        return this.document.firstElementChild();
    }
}

