/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

public class ImageProcessor {
    private BufferedImage sourceImage;
    private BufferedImage currentImage;

    private ImageProcessor(BufferedImage sourceImage) {
        this.currentImage = this.sourceImage = sourceImage;
    }

    public static ImageProcessor fromBase64(String imageBase64) throws IOException {
        if (imageBase64 == null || imageBase64.isEmpty()) {
            throw new IllegalArgumentException("PNG base64 string cannot be null or empty");
        }
        byte[] imageBytes = Base64.getDecoder().decode(imageBase64);
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        BufferedImage imageBuffer = ImageIO.read(bais);
        if (imageBuffer == null) {
            throw new IOException("Failed to read PNG image from base64 string");
        }
        return new ImageProcessor(imageBuffer);
    }

    public static ImageProcessor fromFile(File sourceFile) throws IOException {
        return new ImageProcessor(ImageIO.read(sourceFile));
    }

    public ImageProcessor scale(double scale) {
        int newWidth = (int)((double)this.currentImage.getWidth() * scale);
        int newHeight = (int)((double)this.currentImage.getHeight() * scale);
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, this.currentImage.getType());
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(this.currentImage, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        this.currentImage = scaledImage;
        return this;
    }

    public ImageProcessor compress(double quality) {
        return this;
    }

    public ImageProcessor toJPEG() {
        BufferedImage jpegImage = new BufferedImage(this.currentImage.getWidth(), this.currentImage.getHeight(), 1);
        Graphics2D g2d = jpegImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, jpegImage.getWidth(), jpegImage.getHeight());
        g2d.drawImage((Image)this.currentImage, 0, 0, null);
        g2d.dispose();
        this.currentImage = jpegImage;
        return this;
    }

    public String toPNGBase64() throws IOException {
        return this.toBase64("png");
    }

    public String toJPEGBase64() throws IOException {
        return this.toBase64("jpg");
    }

    public String toBase64(String format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.currentImage, format, baos);
        byte[] scaledImageBytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(scaledImageBytes);
    }

    public File toFile(File output) throws IOException {
        String format = this.getFileFormat(output);
        ImageIO.write((RenderedImage)this.currentImage, format, output);
        return output;
    }

    public File toFile(File output, String format) throws IOException {
        ImageIO.write((RenderedImage)this.currentImage, format, output);
        return output;
    }

    public ImageProcessor reset() {
        this.currentImage = this.sourceImage;
        return this;
    }

    private String getFileFormat(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        return extension;
    }
}

