/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

public class MediaUtils {
    private MediaUtils() {
    }

    public static void optimizeImage(File source, File dest) throws IOException {
        MediaUtils.to8Bit(source, dest);
    }

    public static void to8Bit(File source, File dest) throws IOException {
        BufferedImage image = ImageIO.read(source);
        BufferedImage destBuffer = new BufferedImage(image.getWidth(), image.getHeight(), 13);
        Graphics graphic = destBuffer.getGraphics();
        graphic.setColor(new Color(231, 20, 189));
        graphic.fillRect(0, 0, destBuffer.getWidth(), destBuffer.getHeight());
        destBuffer = MediaUtils.to8Bit(destBuffer);
        destBuffer.createGraphics().drawImage((Image)image, 0, 0, null);
        ImageIO.write((RenderedImage)destBuffer, FilenameUtils.getExtension((String)dest.getName()), dest);
    }

    public static BufferedImage to8Bit(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return image;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        WritableRaster raster = image.getRaster();
        int pixel = raster.getSample(0, 0, 0);
        int size = icm.getMapSize();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        IndexColorModel icm2 = new IndexColorModel(8, size, reds, greens, blues, pixel);
        return new BufferedImage(icm2, raster, image.isAlphaPremultiplied(), null);
    }
}

