/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.HTMLMinifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MobilePageSourceMinifier
extends HTMLMinifier {
    private static final Map<String, String> ANDROID_DEFAULT_VALUES = new HashMap<String, String>();
    private static final Map<String, String> IOS_DEFAULT_VALUES;

    static {
        ANDROID_DEFAULT_VALUES.put("class", null);
        ANDROID_DEFAULT_VALUES.put("package", null);
        ANDROID_DEFAULT_VALUES.put("text", null);
        ANDROID_DEFAULT_VALUES.put("content-desc", null);
        ANDROID_DEFAULT_VALUES.put("resource-id", null);
        ANDROID_DEFAULT_VALUES.put("index", "0");
        ANDROID_DEFAULT_VALUES.put("bounds", "[0,0][0,0]");
        ANDROID_DEFAULT_VALUES.put("x", "0");
        ANDROID_DEFAULT_VALUES.put("y", "0");
        ANDROID_DEFAULT_VALUES.put("width", "0");
        ANDROID_DEFAULT_VALUES.put("height", "0");
        ANDROID_DEFAULT_VALUES.put("displayed", "false");
        ANDROID_DEFAULT_VALUES.put("checkable", "false");
        ANDROID_DEFAULT_VALUES.put("checked", "false");
        ANDROID_DEFAULT_VALUES.put("clickable", "false");
        ANDROID_DEFAULT_VALUES.put("enabled", "true");
        ANDROID_DEFAULT_VALUES.put("focusable", "false");
        ANDROID_DEFAULT_VALUES.put("focused", "false");
        ANDROID_DEFAULT_VALUES.put("scrollable", "false");
        ANDROID_DEFAULT_VALUES.put("longClickable", "false");
        ANDROID_DEFAULT_VALUES.put("long-clickable", "false");
        ANDROID_DEFAULT_VALUES.put("selected", "false");
        ANDROID_DEFAULT_VALUES.put("password", "false");
        ANDROID_DEFAULT_VALUES.put("xpath", null);
        ANDROID_DEFAULT_VALUES.put("drawing-order", "0");
        ANDROID_DEFAULT_VALUES.put("text-entry-key", "false");
        ANDROID_DEFAULT_VALUES.put("dismissable", "false");
        ANDROID_DEFAULT_VALUES.put("context-clickable", "false");
        ANDROID_DEFAULT_VALUES.put("showing-hint", "false");
        ANDROID_DEFAULT_VALUES.put("a11y-important", "false");
        ANDROID_DEFAULT_VALUES.put("a11y-focused", "false");
        ANDROID_DEFAULT_VALUES.put("screen-reader-focusable", "false");
        ANDROID_DEFAULT_VALUES.put("live-region", "0");
        ANDROID_DEFAULT_VALUES.put("heading", "false");
        ANDROID_DEFAULT_VALUES.put("content-invalid", "false");
        ANDROID_DEFAULT_VALUES.put("hintText", null);
        ANDROID_DEFAULT_VALUES.put("clickableHost", "false");
        ANDROID_DEFAULT_VALUES.put("importantForAutofill", "0");
        ANDROID_DEFAULT_VALUES.put("autofillHints", null);
        ANDROID_DEFAULT_VALUES.put("accessibilityTraversalBefore", null);
        ANDROID_DEFAULT_VALUES.put("accessibilityTraversalAfter", null);
        ANDROID_DEFAULT_VALUES.put("class-chain", null);
        ANDROID_DEFAULT_VALUES.put("android-widget-hash", null);
        ANDROID_DEFAULT_VALUES.put("clickableRegion", null);
        ANDROID_DEFAULT_VALUES.put("visibleToUser", "true");
        IOS_DEFAULT_VALUES = new HashMap<String, String>();
        IOS_DEFAULT_VALUES.put("type", null);
        IOS_DEFAULT_VALUES.put("name", null);
        IOS_DEFAULT_VALUES.put("label", null);
        IOS_DEFAULT_VALUES.put("value", null);
        IOS_DEFAULT_VALUES.put("hint", null);
        IOS_DEFAULT_VALUES.put("x", "0");
        IOS_DEFAULT_VALUES.put("y", "0");
        IOS_DEFAULT_VALUES.put("width", "0");
        IOS_DEFAULT_VALUES.put("height", "0");
        IOS_DEFAULT_VALUES.put("visible", "false");
        IOS_DEFAULT_VALUES.put("accessible", "true");
        IOS_DEFAULT_VALUES.put("enabled", "true");
        IOS_DEFAULT_VALUES.put("selected", "false");
        IOS_DEFAULT_VALUES.put("xpath", null);
        IOS_DEFAULT_VALUES.put("index", "0");
    }

    public MobilePageSourceMinifier(String html) {
        super(html);
    }

    @Override
    protected String minifyDOM(String locator) {
        super.minifyDOM(locator);
        this.runDOMMinizationPhase("Remove hidden or invisible or zero bounds elements", () -> this.removeInvisibleElements());
        this.runDOMMinizationPhase("Remove redundant mobile attributes", () -> this.removeMobileRedundantAttributes());
        this.runDOMMinizationPhase("Remove attributes with default values", () -> this.removeAttributesWithDefaultValues());
        return this.buildHTML();
    }

    @Override
    protected String minifyHTML(String html) {
        html = this.removeRedundantSpaces(html);
        return html;
    }

    private String removeRedundantSpaces(String html) {
        html = html.replaceAll("\r\n", "").replaceAll(">\\s*", ">");
        return html;
    }

    private void removeMobileRedundantAttributes() {
        this.removeMobileRedundantAttributes(this.getRootElement());
    }

    private void removeMobileRedundantAttributes(Element root) {
        Attributes attributes = root.attributes();
        for (Attribute attribute : attributes.clone()) {
            String attributeName = attribute.getKey();
            if (!Strings.CI.equalsAny((CharSequence)attributeName, new CharSequence[]{"class", "package", "xpath", "bounds", "drawing-order", "android-widget-hash", "class-chain", "accessibilityTraversalBefore", "accessibilityTraversalAfter", "clickableRegion", "importantForAutofill", "autofillHints"})) continue;
            root.removeAttr(attributeName);
        }
        root.children().forEach(child -> this.removeMobileRedundantAttributes((Element)child));
    }

    private void removeAttributesWithDefaultValues() {
        this.removeAttributesWithDefaultValues(this.getRootElement());
    }

    private void removeAttributesWithDefaultValues(Element root) {
        Attributes attributes = root.attributes();
        for (Attribute attribute : attributes.clone()) {
            String defaultValue;
            String attributeName = attribute.getKey();
            String attributeValue = attribute.getValue();
            if (ANDROID_DEFAULT_VALUES.containsKey(attributeName) && this.isMatchingDefaultValue(attributeValue, defaultValue = ANDROID_DEFAULT_VALUES.get(attributeName))) {
                root.removeAttr(attributeName);
                continue;
            }
            if (!IOS_DEFAULT_VALUES.containsKey(attributeName) || !this.isMatchingDefaultValue(attributeValue, defaultValue = IOS_DEFAULT_VALUES.get(attributeName))) continue;
            root.removeAttr(attributeName);
        }
        root.children().forEach(child -> this.removeAttributesWithDefaultValues((Element)child));
    }

    private boolean isMatchingDefaultValue(String actualValue, String defaultValue) {
        if (defaultValue == null) {
            return actualValue == null || actualValue.isEmpty() || actualValue.equals("null");
        }
        if (actualValue == null || actualValue.isEmpty()) {
            return defaultValue.isEmpty();
        }
        if (actualValue.equals(defaultValue)) {
            return true;
        }
        if (defaultValue.equals("true") || defaultValue.equals("false")) {
            return actualValue.equalsIgnoreCase(defaultValue);
        }
        return false;
    }

    private void removeInvisibleElements() {
        this.removeInvisibleElements(this.getRootElement());
    }

    private void removeInvisibleElements(Element root) {
        Elements children = root.children();
        int i = children.size() - 1;
        while (i >= 0) {
            Element child = (Element)children.get(i);
            this.removeInvisibleElements(child);
            if (this.isInvisibleElement(child)) {
                child.remove();
            }
            --i;
        }
    }

    private boolean isInvisibleElement(Element element) {
        String displayed = element.attr("displayed");
        if ("false".equalsIgnoreCase(displayed)) {
            return true;
        }
        String visibleToUser = element.attr("visibleToUser");
        if ("false".equalsIgnoreCase(visibleToUser)) {
            return true;
        }
        String visible = element.attr("visible");
        if ("false".equalsIgnoreCase(visible)) {
            return true;
        }
        String bounds = element.attr("bounds");
        if (bounds != null && !bounds.isEmpty() && this.isZeroBounds(bounds)) {
            return true;
        }
        String width = element.attr("width");
        String height = element.attr("height");
        if (width != null && !width.isEmpty()) {
            try {
                if (Integer.parseInt(width) == 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (height != null && !height.isEmpty()) {
            try {
                if (Integer.parseInt(height) == 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    private boolean isZeroBounds(String bounds) {
        try {
            String[] parts = bounds.replace("][", ",").replace("[", "").replace("]", "").split(",");
            if (parts.length == 4) {
                int x1 = Integer.parseInt(parts[0].trim());
                int y1 = Integer.parseInt(parts[1].trim());
                int x2 = Integer.parseInt(parts[2].trim());
                int y2 = Integer.parseInt(parts[3].trim());
                return x2 - x1 == 0 || y2 - y1 == 0;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }
}

