/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.core.constants.StringConstants;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    private static GsonBuilder createGsonBuilderWithIsoDateTimeSupport() {
        return new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new JsonSerializer<ZonedDateTime>(){

            public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
        }).registerTypeAdapter(OffsetDateTime.class, (Object)new JsonSerializer<OffsetDateTime>(){

            public JsonElement serialize(OffsetDateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
        }).registerTypeAdapter(OffsetDateTime.class, (Object)new JsonDeserializer<OffsetDateTime>(){

            public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return OffsetDateTime.parse(json.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
        });
    }

    public static String toJson(Object src) {
        return JsonUtil.toJson(src, true);
    }

    public static String toJson(Object src, boolean prettyPrint) {
        return JsonUtil.toJson(src, prettyPrint, false);
    }

    public static String toJson(Object src, boolean prettyPrint, boolean excludeFieldsWithoutExposeAnnotation) {
        return JsonUtil.toJson(src, prettyPrint, excludeFieldsWithoutExposeAnnotation, false);
    }

    public static String toJson(Object src, boolean prettyPrint, boolean excludeFieldsWithoutExposeAnnotation, boolean disableHtmlEscaping) {
        Gson gson;
        GsonBuilder gsonBuilder = JsonUtil.createGsonBuilderWithIsoDateTimeSupport();
        if (disableHtmlEscaping) {
            gsonBuilder.disableHtmlEscaping();
        }
        if (prettyPrint || excludeFieldsWithoutExposeAnnotation) {
            if (prettyPrint) {
                gsonBuilder = gsonBuilder.setPrettyPrinting();
            }
            if (excludeFieldsWithoutExposeAnnotation) {
                gsonBuilder = gsonBuilder.excludeFieldsWithoutExposeAnnotation();
            }
            gson = gsonBuilder.create();
        } else {
            gson = gsonBuilder.create();
        }
        return gson.toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return JsonUtil.toJson(src, typeOfSrc, true);
    }

    public static String toJson(Object src, Type typeOfSrc, boolean prettyPrint) {
        GsonBuilder gsonBuilder = JsonUtil.createGsonBuilderWithIsoDateTimeSupport();
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        return gson.toJson(src, typeOfSrc);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T[]> arrayType) {
        T[] items = JsonUtil.fromJson(json, arrayType);
        return Arrays.asList(items);
    }

    public static <T> T fromJson(String json, Type typeOfT) throws IllegalArgumentException {
        try {
            return (T)JsonUtil.createGsonBuilderWithIsoDateTimeSupport().create().fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(Reader reader, Type typeOfT) throws IllegalArgumentException {
        try {
            return (T)JsonUtil.createGsonBuilderWithIsoDateTimeSupport().create().fromJson(reader, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(Reader reader, Class<T> classOfT) throws IllegalArgumentException {
        try {
            return (T)JsonUtil.createGsonBuilderWithIsoDateTimeSupport().create().fromJson(reader, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws IllegalArgumentException {
        try {
            return JsonUtil.fromJson(null, json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(String dateTimeFormat, String json, Class<T> classOfT) throws IllegalArgumentException {
        try {
            if (StringUtils.isBlank((CharSequence)dateTimeFormat)) {
                return (T)JsonUtil.createGsonBuilderWithIsoDateTimeSupport().create().fromJson(json, classOfT);
            }
            return (T)JsonUtil.createGsonBuilderWithIsoDateTimeSupport().setDateFormat(dateTimeFormat).create().fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static JsonObject toJsonObject(Object src) {
        Gson gson = JsonUtil.createGsonBuilderWithIsoDateTimeSupport().create();
        return gson.toJsonTree(src).getAsJsonObject();
    }

    public static void mergeJsonObject(JsonObject src, JsonObject dst) {
        for (Map.Entry entry : src.entrySet()) {
            dst.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static boolean isValidJsonSchema(String aSchema) {
        JsonNode schemaNode;
        block3: {
            ObjectMapper mapper = new ObjectMapper();
            try {
                schemaNode = mapper.readTree(aSchema);
                if (schemaNode != null) break block3;
                return false;
            }
            catch (JsonProcessingException jsonProcessingException) {
                return false;
            }
        }
        Schema jsonSchema = JsonUtil.parseJsonSchema(schemaNode);
        return jsonSchema != null;
    }

    private static Schema parseJsonSchema(JsonNode schemaNode) {
        if (schemaNode == null) {
            return null;
        }
        return SchemaRegistry.withDialect((Dialect)Dialects.getDraft202012()).getSchema(schemaNode);
    }
}

