/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class NamingUtil {
    public static final String ELLIPSIS = "...";
    public static final int MAX_FILE_PATH_LENGTH = 255;
    public static final int DEFAULT_MAX_FILE_NAME_LENGTH = 25;

    public static File truncateAndSanitizePath(File file) throws InvalidPathException {
        return NamingUtil.truncateAndSanitizePath(file, 25);
    }

    public static File truncateAndSanitizePath(File file, int maxNameLength) throws InvalidPathException {
        return NamingUtil.truncateAndSanitizePath(file.toPath(), maxNameLength).toFile();
    }

    public static Path truncateAndSanitizePath(Path path) throws InvalidPathException {
        return NamingUtil.truncateAndSanitizePath(path, 25);
    }

    public static Path truncateAndSanitizePath(Path path, int maxNameLength) throws InvalidPathException {
        return NamingUtil.sanitizeFileName(NamingUtil.makeEllipsisPath(path, maxNameLength));
    }

    public static String makeEllipsisPath(String path) throws InvalidPathException {
        return NamingUtil.makeEllipsisPath(path, 25);
    }

    public static String makeEllipsisPath(String path, int maxNameLength) throws InvalidPathException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        return NamingUtil.makeEllipsisPath(Path.of(path, new String[0]), maxNameLength).toString();
    }

    public static File makeEllipsisPath(File file) throws InvalidPathException {
        return NamingUtil.makeEllipsisPath(file, 25);
    }

    public static File makeEllipsisPath(File file, int maxNameLength) throws InvalidPathException {
        if (file == null) {
            return file;
        }
        return NamingUtil.makeEllipsisPath(file.toPath(), maxNameLength).toFile();
    }

    public static Path makeEllipsisPath(Path path) throws InvalidPathException {
        return NamingUtil.makeEllipsisPath(path, 25);
    }

    public static Path makeEllipsisPath(Path path, int maxNameLength) throws InvalidPathException {
        if (path == null) {
            return path;
        }
        String absolutePath = path.getParent().toAbsolutePath().toString();
        int remaining = 255 - absolutePath.length();
        if (remaining <= 0) {
            throw new InvalidPathException(absolutePath, MessageFormat.format("Maximum length reached ({0}/{1})", absolutePath.length(), 255));
        }
        String ellipsisName = NamingUtil.makeEllipsisFileName(path.getFileName().toString(), Math.min(maxNameLength, remaining));
        return path.getParent().resolve(ellipsisName);
    }

    public static String makeEllipsisFileName(String fileName) {
        return NamingUtil.makeEllipsisFileName(fileName, 25);
    }

    public static String makeEllipsisFileName(String fileName, int maxLength) {
        String baseName = FilenameUtils.getBaseName((String)fileName);
        String extension = FilenameUtils.getExtension((String)fileName);
        Object extensionPart = StringUtils.isBlank((CharSequence)extension) ? "" : "." + extension;
        return NamingUtil.makeEllipsisName(baseName, maxLength - ((String)extensionPart).length()) + (String)extensionPart;
    }

    public static String makeEllipsisName(String name) {
        return NamingUtil.makeEllipsisName(name, 25);
    }

    public static String makeEllipsisName(String name, int maxLength) {
        String secondPart;
        String firstPart;
        int firstExtraLength;
        if (StringUtils.defaultString((String)name).length() <= maxLength) {
            return name;
        }
        int remaining = maxLength - ELLIPSIS.length();
        if (remaining <= 1) {
            return name.substring(0, maxLength);
        }
        int halfLength = Math.floorDiv(remaining, 2);
        int secondPartLength = halfLength + (firstExtraLength = halfLength - (firstPart = StringUtils.trimToEmpty((String)name.substring(0, halfLength))).length());
        int secondExtraLength = secondPartLength - (secondPart = StringUtils.trimToEmpty((String)name.substring(name.length() - secondPartLength, name.length()))).length();
        if (secondExtraLength > 0) {
            firstPart = StringUtils.trimToEmpty((String)name.substring(0, halfLength + secondExtraLength));
        }
        return firstPart + ELLIPSIS + secondPart;
    }

    public static File sanitizeFileName(File file) {
        return new File(file.getParentFile(), NamingUtil.sanitizeFileName(file.getName()));
    }

    public static Path sanitizeFileName(Path path) {
        return path.getParent().resolve(NamingUtil.sanitizeFileName(path.getFileName().toString()));
    }

    public static String sanitizeFileName(String name) {
        return name.replaceAll("\\s+", "-");
    }

    public static String getUniqueFileName(String preferredName, String location) {
        return NamingUtil.getUniqueFileName(preferredName, location, null);
    }

    public static String getUniqueFileName(String preferredName, String location, Integer sequenceNumber) {
        File file;
        File parent = new File(location);
        if (!parent.exists()) {
            return preferredName;
        }
        while (true) {
            String fileNameToBeTested = NamingUtil.buildSequenceName(preferredName, sequenceNumber);
            file = new File(FilenameUtils.concat((String)parent.getAbsolutePath(), (String)fileNameToBeTested));
            if (!file.exists()) break;
            sequenceNumber = sequenceNumber != null ? sequenceNumber + 1 : 1;
        }
        return file.getName();
    }

    private static String buildSequenceName(String preferredName, Integer sequenceNumber) {
        return sequenceNumber != null ? MessageFormat.format("{0} ({1})", preferredName, sequenceNumber) : preferredName;
    }
}

