/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PUtil;

public class PActivity {
    public static final int TERMINATE_WITHOUT_FINISHING = 0;
    public static final int TERMINATE_AND_FINISH = 1;
    public static final int TERMINATE_AND_FINISH_IF_STEPPING = 2;
    private PActivityScheduler scheduler;
    private long startTime;
    private long duration;
    private long stepRate;
    private PActivityDelegate delegate;
    private boolean stepping;
    private long nextStepTime;

    public PActivity(long aDuration) {
        this(aDuration, PUtil.DEFAULT_ACTIVITY_STEP_RATE);
    }

    public PActivity(long aDuration, long aStepRate) {
        this(aDuration, aStepRate, System.currentTimeMillis());
    }

    public PActivity(long aDuration, long aStepRate, long aStartTime) {
        this.duration = aDuration;
        this.stepRate = aStepRate;
        this.startTime = aStartTime;
        this.nextStepTime = aStartTime;
        this.stepping = false;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long aTriggerTime) {
        this.startTime = aTriggerTime;
    }

    public long getStepRate() {
        return this.stepRate;
    }

    public void setStepRate(long aStepRate) {
        this.stepRate = aStepRate;
    }

    public long getNextStepTime() {
        return this.nextStepTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long aDuration) {
        this.duration = aDuration;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.scheduler;
    }

    public void setActivityScheduler(PActivityScheduler aScheduler) {
        this.scheduler = aScheduler;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    protected boolean isAnimation() {
        return false;
    }

    protected void activityStarted() {
        if (this.delegate != null) {
            this.delegate.activityStarted(this);
        }
    }

    protected void activityStep(long elapsedTime) {
        if (this.delegate != null) {
            this.delegate.activityStepped(this);
        }
    }

    protected void activityFinished() {
        if (this.delegate != null) {
            this.delegate.activityFinished(this);
        }
    }

    public PActivityDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(PActivityDelegate delegate) {
        this.delegate = delegate;
    }

    public void startAfter(PActivity first) {
        this.setStartTime(first.getStartTime() + first.getDuration());
    }

    public void terminate() {
        this.terminate(2);
    }

    public void terminate(int terminationBehavior) {
        if (this.scheduler != null) {
            this.scheduler.removeActivity(this);
        }
        switch (terminationBehavior) {
            case 0: {
                this.stepping = false;
                break;
            }
            case 1: {
                if (this.stepping) {
                    this.stepping = false;
                    this.activityFinished();
                    break;
                }
                this.activityStarted();
                this.activityFinished();
                break;
            }
            case 2: {
                if (!this.stepping) break;
                this.stepping = false;
                this.activityFinished();
                break;
            }
            default: {
                throw new RuntimeException("Invalid termination behaviour provided to PActivity.terminate");
            }
        }
    }

    public long processStep(long currentTime) {
        if (currentTime < this.startTime) {
            return this.startTime - currentTime;
        }
        if (currentTime > this.getStopTime()) {
            if (this.stepping) {
                this.stepping = false;
                this.scheduler.removeActivity(this);
                this.activityFinished();
            } else {
                this.activityStarted();
                this.scheduler.removeActivity(this);
                this.activityFinished();
            }
            return -1L;
        }
        if (!this.stepping) {
            this.activityStarted();
            this.stepping = true;
        }
        if (currentTime >= this.nextStepTime) {
            this.activityStep(currentTime - this.startTime);
            this.nextStepTime = currentTime + this.stepRate;
        }
        return this.stepRate;
    }

    public long getStopTime() {
        if (this.duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.startTime + this.duration;
    }

    protected String paramString() {
        return "";
    }

    public static interface PActivityDelegate {
        public void activityStarted(PActivity var1);

        public void activityStepped(PActivity var1);

        public void activityFinished(PActivity var1);
    }
}

