/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PScrollDirector;
import edu.umd.cs.piccolox.swing.PScrollPane;
import edu.umd.cs.piccolox.swing.PViewport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

public class PDefaultScrollDirector
implements PScrollDirector,
PropertyChangeListener {
    protected PViewport viewPort;
    protected PScrollPane scrollPane;
    protected PCanvas view;
    protected PCamera camera;
    protected PRoot root;
    protected boolean scrollInProgress = false;

    public void install(PViewport targetViewPort, PCanvas targetView) {
        this.scrollPane = (PScrollPane)targetViewPort.getParent();
        this.viewPort = targetViewPort;
        this.view = targetView;
        if (targetView != null) {
            this.camera = targetView.getCamera();
            this.root = targetView.getRoot();
        }
        if (this.camera != null) {
            this.camera.addPropertyChangeListener(this);
        }
        if (this.root != null) {
            this.root.addPropertyChangeListener(this);
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void unInstall() {
        this.viewPort = null;
        this.view = null;
        if (this.camera != null) {
            this.camera.removePropertyChangeListener(this);
        }
        if (this.root != null) {
            this.root.removePropertyChangeListener(this);
        }
        this.camera = null;
        this.root = null;
    }

    public Point getViewPosition(Rectangle2D viewBounds) {
        Point pos = new Point();
        if (this.camera != null) {
            PBounds layerBounds = new PBounds();
            List layers = this.camera.getLayersReference();
            Iterator i2 = layers.iterator();
            while (i2.hasNext()) {
                PLayer layer = (PLayer)i2.next();
                layerBounds.add(layer.getFullBoundsReference());
            }
            this.camera.viewToLocal(layerBounds);
            layerBounds.add(viewBounds);
            pos.setLocation((int)(viewBounds.getX() - layerBounds.getX() + 0.5), (int)(viewBounds.getY() - layerBounds.getY() + 0.5));
        }
        return pos;
    }

    public Dimension getViewSize(Rectangle2D viewBounds) {
        Dimension size = new Dimension();
        if (this.camera != null) {
            PBounds bounds = new PBounds();
            List layers = this.camera.getLayersReference();
            Iterator i2 = layers.iterator();
            while (i2.hasNext()) {
                PLayer layer = (PLayer)i2.next();
                bounds.add(layer.getFullBoundsReference());
            }
            if (!bounds.isEmpty()) {
                this.camera.viewToLocal(bounds);
            }
            bounds.add(viewBounds);
            size.setSize((int)(bounds.getWidth() + 0.5), (int)(bounds.getHeight() + 0.5));
        }
        return size;
    }

    public void setViewPosition(double x, double y) {
        if (this.camera == null || this.scrollInProgress) {
            return;
        }
        this.scrollInProgress = true;
        PBounds layerBounds = new PBounds();
        List layers = this.camera.getLayersReference();
        Iterator i2 = layers.iterator();
        while (i2.hasNext()) {
            PLayer layer = (PLayer)i2.next();
            layerBounds.add(layer.getFullBoundsReference());
        }
        PAffineTransform at = this.camera.getViewTransform();
        at.transform(layerBounds, layerBounds);
        PBounds viewBounds = this.camera.getBoundsReference();
        layerBounds.add(viewBounds);
        Point2D.Double newPoint = new Point2D.Double(layerBounds.getX() + x, layerBounds.getY() + y);
        this.camera.localToView(newPoint);
        double newX = -(at.getScaleX() * ((Point2D)newPoint).getX() + at.getShearX() * ((Point2D)newPoint).getY());
        double newY = -(at.getShearY() * ((Point2D)newPoint).getX() + at.getScaleY() * ((Point2D)newPoint).getY());
        at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), newX, newY);
        this.camera.setViewTransform(at);
        this.scrollInProgress = false;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        boolean isRelevantBoundsEvent;
        boolean isRelevantViewEvent = "viewTransform".equals(pce.getPropertyName());
        boolean bl = isRelevantBoundsEvent = this.isBoundsChangedEvent(pce) && (pce.getSource() == this.camera || pce.getSource() == this.view.getRoot());
        if (isRelevantViewEvent || isRelevantBoundsEvent) {
            if (this.shouldRevalidateScrollPane()) {
                this.scrollPane.revalidate();
            } else {
                this.viewPort.fireStateChanged();
            }
        }
    }

    private boolean isBoundsChangedEvent(PropertyChangeEvent pce) {
        return "bounds".equals(pce.getPropertyName()) || "fullBounds".equals(pce.getPropertyName());
    }

    public boolean shouldRevalidateScrollPane() {
        if (this.camera != null) {
            if (this.scrollPane.getHorizontalScrollBarPolicy() != 30 && this.scrollPane.getVerticalScrollBarPolicy() != 20) {
                return false;
            }
            PBounds layerBounds = new PBounds();
            List layers = this.camera.getLayersReference();
            Iterator i2 = layers.iterator();
            while (i2.hasNext()) {
                PLayer layer = (PLayer)i2.next();
                layerBounds.add(layer.getFullBoundsReference());
            }
            this.camera.viewToLocal(layerBounds);
            PBounds cameraBounds = this.camera.getBoundsReference();
            layerBounds.add(cameraBounds);
            int layerWidth = (int)(layerBounds.getWidth() + 0.5);
            int layerHeight = (int)(layerBounds.getHeight() + 0.5);
            int cameraWidth = (int)(cameraBounds.getWidth() + 0.5);
            int cameraHeight = (int)(cameraBounds.getHeight() + 0.5);
            if (this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth <= cameraWidth || !this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth > cameraWidth || this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight <= cameraHeight || !this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight > cameraHeight) {
                return true;
            }
        }
        return false;
    }
}

