/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sikuli.api.DefaultScreenRegion;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.core.search.RegionMatch;

public abstract class DefaultTarget
implements Target {
    private double minScore = 0.0;
    private int limit = 0;
    private Target.Ordering ordering = Target.Ordering.DEFAULT;

    protected double getDefaultMinScore() {
        return 0.0;
    }

    protected int getDefaultLimit() {
        return 100;
    }

    public DefaultTarget() {
        this.setMinScore(this.getDefaultMinScore());
        this.setLimit(this.getDefaultLimit());
    }

    @Override
    public double getMinScore() {
        return this.minScore;
    }

    @Override
    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Target.Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public void setOrdering(Target.Ordering ordering) {
        this.ordering = ordering;
    }

    protected abstract List<ScreenRegion> getUnordredMatches(ScreenRegion var1);

    protected static List<ScreenRegion> convertToScreenRegions(ScreenRegion parent, List<RegionMatch> rms) {
        ArrayList irs = Lists.newArrayList();
        for (RegionMatch rm : rms) {
            DefaultScreenRegion ir = new DefaultScreenRegion(parent, rm.getX(), rm.getY(), rm.getWidth(), rm.getHeight());
            ir.setScore(rm.getScore());
            irs.add(ir);
        }
        return irs;
    }

    @Override
    public List<ScreenRegion> doFindAll(ScreenRegion screenRegion) {
        List<ScreenRegion> ScreenRegions = this.getUnordredMatches(screenRegion);
        if (this.ordering == Target.Ordering.TOP_DOWN) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a2, ScreenRegion b2) {
                    return a2.getBounds().y - b2.getBounds().y;
                }
            });
        } else if (this.ordering == Target.Ordering.BOTTOM_UP) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a2, ScreenRegion b2) {
                    return b2.getBounds().y - a2.getBounds().y;
                }
            });
        } else if (this.ordering == Target.Ordering.LEFT_RIGHT) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a2, ScreenRegion b2) {
                    return a2.getBounds().x - b2.getBounds().x;
                }
            });
        } else if (this.ordering == Target.Ordering.RIGHT_LEFT) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a2, ScreenRegion b2) {
                    return b2.getBounds().x - a2.getBounds().x;
                }
            });
        }
        return ScreenRegions;
    }

    public BufferedImage toImage() {
        return null;
    }
}

