/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import com.kms.katalon.composer.util.groovy.OrganizeGroovyImportsAction;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;

public class GroovyEditorUtil {
    private static final String GROOVY_EDITOR_URI = "org.codehaus.groovy.eclipse.editor.GroovyEditor";

    public static MPart createTestCaseEditorPart(IFile scriptFile, MPartStack parentPartStack, String testCaseEditorId, EPartService partService, int index) {
        MPart editor = GroovyEditorUtil.createEditorPart(scriptFile, partService);
        editor.setElementId(testCaseEditorId);
        parentPartStack.getChildren().add(index, editor);
        return editor;
    }

    public static MPart createEditorPart(ProjectEntity projectEntity, String filePath, EPartService partService) throws CoreException {
        IFile scriptFile = GroovyUtil.getGroovyProject((ProjectEntity)projectEntity).getFile(Path.fromOSString((String)filePath));
        scriptFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return GroovyEditorUtil.createEditorPart(scriptFile, partService);
    }

    public static MPart createEditorPart(IFile scriptFile, EPartService partService) {
        MPart editor = partService.createPart("org.eclipse.e4.ui.compatibility.editor");
        FileEditorInput input = new FileEditorInput(scriptFile);
        editor.getTags().add(GROOVY_EDITOR_URI);
        GroovyEditorUtil.createEditorReferenceForPart(editor, (IEditorInput)input, GROOVY_EDITOR_URI, null);
        GroovyEditorUtil.updateActiveEditorSources(editor);
        EditorDescriptor descriptor = (EditorDescriptor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkbenchWindow().getWorkbench().getEditorRegistry().findEditor(GROOVY_EDITOR_URI);
        GroovyEditorUtil.recordEditor((IEditorInput)input, (IEditorDescriptor)descriptor);
        editor.getTags().add("NoMove");
        return editor;
    }

    private static void recordEditor(IEditorInput input, IEditorDescriptor descriptor) {
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorHistory history = ((Workbench)page.getWorkbenchWindow().getWorkbench()).getEditorHistory();
        history.add(input, descriptor);
    }

    public static IEditorPart getEditor(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityEditor) {
            return ((CompatibilityEditor)clientObject).getEditor();
        }
        return null;
    }

    public static void discardEditor(MPart part) {
        if (!part.isDirty()) {
            return;
        }
        IEditorPart editor = GroovyEditorUtil.getEditor(part);
        if (editor instanceof StatusTextEditor) {
            ((StatusTextEditor)editor).doRevertToSaved();
        }
        part.setDirty(false);
    }

    public static void saveEditor(MPart part, boolean ignoredCheckDirty) {
        IEditorPart editor;
        block8: {
            if (!ignoredCheckDirty && !part.isDirty()) {
                return;
            }
            editor = GroovyEditorUtil.getEditor(part);
            if (editor instanceof GroovyEditor) {
                GroovyEditor groovyEditor = (GroovyEditor)editor;
                GroovyCompilationUnit unit = groovyEditor.getGroovyCompilationUnit();
                try {
                    try {
                        if (!unit.isWorkingCopy()) {
                            unit.becomeWorkingCopy(null);
                        }
                        unit.commitWorkingCopy(true, null);
                    }
                    catch (JavaModelException javaModelException) {
                        part.setDirty(false);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    part.setDirty(false);
                    throw throwable;
                }
                part.setDirty(false);
            }
        }
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public static void saveEditor(MPart part) {
        GroovyEditorUtil.saveEditor(part, false);
    }

    public static boolean isGroovyEditorPart(MPart part) {
        IEditorPart editor = GroovyEditorUtil.getEditor(part);
        return editor instanceof GroovyEditor;
    }

    public static boolean isJavaEditorPart(MPart part) {
        IEditorPart editor = GroovyEditorUtil.getEditor(part);
        return editor instanceof JavaEditor;
    }

    public static boolean isFeatureFileEditorPart(MPart part) {
        IEditorPart editor = GroovyEditorUtil.getEditor(part);
        if (editor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)editor;
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
            return GherkinEditorDocumentManager.isCompatibleTextBuffer((IDocument)document);
        }
        return false;
    }

    private static void updateActiveEditorSources(MPart part) {
        IEditorPart editor = GroovyEditorUtil.getEditor(part);
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        MWindow window = page.getWindowModel();
        window.getContext().set("activeEditorId", editor == null ? null : editor.getSite().getId());
        window.getContext().set("activeEditor", (Object)editor);
        window.getContext().set("activeEditorInput", (Object)(editor == null ? null : editor.getEditorInput()));
        if (editor != null) {
            NavigationHistory navigationHistory = (NavigationHistory)page.getNavigationHistory();
            navigationHistory.markEditor(editor);
        }
    }

    private static EditorReference createEditorReferenceForPart(MPart part, IEditorInput input, String editorId, IMemento memento) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        EditorDescriptor descriptor = (EditorDescriptor)registry.findEditor(editorId);
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorReference ref = new EditorReference(page.getWindowModel().getContext(), (IWorkbenchPage)page, part, input, descriptor, memento);
        page.addEditorReference(ref);
        ref.subscribe();
        return ref;
    }

    public static void showProblems(GroovyEditor editor) {
        IResource resource = null;
        try {
            resource = editor.getGroovyCompilationUnit().getResource();
            GroovyEditorUtil.clearEditorProblems(editor);
            String testScriptContent = editor.getGroovyCompilationUnit().getSource();
            if (testScriptContent == null || testScriptContent.isEmpty()) {
                return;
            }
            new AstBuilder().buildFromString(CompilePhase.CONVERSION, testScriptContent);
        }
        catch (MultipleCompilationErrorsException ex) {
            try {
                SyntaxErrorMessage message = (SyntaxErrorMessage)ex.getErrorCollector().getError(0);
                SyntaxException syntaxException = message.getCause();
                int lineOffset = editor.getViewer().getDocument().getLineOffset(syntaxException.getLine() - 1);
                IMarker marker = resource.createMarker("org.codehaus.groovy.eclipse.dsl.inferencing_problem");
                marker.setAttribute("priority", 2);
                marker.setAttribute("message", (Object)syntaxException.getMessage());
                marker.setAttribute("severity", 2);
                marker.setAttribute("lineNumber", syntaxException.getLine());
                marker.setAttribute("charStart", lineOffset + syntaxException.getStartColumn() - 1);
                marker.setAttribute("charEnd", lineOffset + syntaxException.getEndColumn() - 1);
                marker.setAttribute("location", (Object)String.format("line %d", syntaxException.getLine()));
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
    }

    public static void clearEditorProblems(GroovyEditor editor) throws CoreException {
        IResource resource = editor.getGroovyCompilationUnit().getResource();
        if (resource != null && resource.exists()) {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
    }

    public static void insertScript(GroovyEditor editor, int offset, String script) throws MalformedTreeException, BadLocationException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
        InsertEdit insertEdit = new InsertEdit(offset, script);
        insertEdit.apply(document);
    }

    public static void deleteScript(GroovyEditor editor, int offset, int length) throws MalformedTreeException, BadLocationException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
        DeleteEdit deleteEdit = new DeleteEdit(offset, length);
        deleteEdit.apply(document);
    }

    public static void addImportActions(GroovyEditor editor) {
        GenerateActionGroup group = (GenerateActionGroup)ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fGenerateActionGroup", (Object)editor);
        OrganizeGroovyImportsAction organizeGroovyImportsAction = new OrganizeGroovyImportsAction((JavaEditor)editor);
        organizeGroovyImportsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        editor.setAction("OrganizeImports", (IAction)organizeGroovyImportsAction);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fOrganizeImports", (Object)group, (Object)((Object)organizeGroovyImportsAction));
        IEclipseContext context = ((Workbench)PlatformUI.getWorkbench()).getContext();
        IEclipseContext activeLeaf = context.getActiveLeaf();
        if (activeLeaf == null) {
            return;
        }
        Object handlerObject = activeLeaf.get("handler::org.eclipse.jdt.ui.edit.text.java.organize.imports");
        if (handlerObject instanceof E4HandlerProxy) {
            E4HandlerProxy e4Handler = (E4HandlerProxy)handlerObject;
            ActionHandler actionHandler = (ActionHandler)e4Handler.getHandler();
            ReflectionUtils.setPrivateField(ActionHandler.class, (String)"action", (Object)actionHandler, (Object)((Object)organizeGroovyImportsAction));
        }
    }

    public static void collapseImportBlock(GroovyEditor editor) {
        if (editor == null || !(editor.getViewer() instanceof ProjectionViewer)) {
            return;
        }
        ProjectionViewer viewer = (ProjectionViewer)editor.getViewer();
        ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
        if (model == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            IDocument document = viewer.getDocument();
            Position importsPosition = GroovyEditorUtil.findStatementBlockPosition(document, "import ");
            if (importsPosition == null || importsPosition.isDeleted()) {
                return;
            }
            model.collapseAll(importsPosition.getOffset(), importsPosition.getLength());
        });
    }

    private static Position findStatementBlockPosition(IDocument document, String statementPrefix) {
        int startOffset = -1;
        int endOffset = -1;
        try {
            int lineCount = document.getNumberOfLines();
            int i = 0;
            while (i < lineCount) {
                int lineLength;
                int lineOffset = document.getLineOffset(i);
                String lineText = document.get(lineOffset, lineLength = document.getLineLength(i)).trim();
                if (lineText.startsWith(statementPrefix)) {
                    if (startOffset == -1) {
                        startOffset = lineOffset;
                    }
                    endOffset = lineOffset + lineLength;
                }
                ++i;
            }
            if (startOffset != -1) {
                int length = endOffset - startOffset;
                return new Position(startOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

