/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSession;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.EntityModificationType;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.McpServerConnectionStatus;
import com.kms.katalon.ai.core.model.agent.ToolCallApproval;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.preference.StudioAssistUserPreference;
import com.kms.katalon.ai.core.repository.IStudioAssistUserPreferenceRepository;
import com.kms.katalon.ai.core.services.IAgentManager;
import com.kms.katalon.ai.core.services.IAgentProfileManager;
import com.kms.katalon.ai.core.services.IFileSnapshotService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.util.collections.Pair;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AgentSessionContext
implements IAgentSessionContext {
    private static final Logger logger = LoggerFactory.getLogger(AgentSessionContext.class);
    private static final int MAX_DURATION_WAITING_FOR_ANSWER = 120;
    public static final String GENERIC_AGENT_SELECTION_KEY = "__GENERIC__";
    @Inject
    private IAgentManager agentManager;
    @Inject
    private IFileSnapshotService fileSnapshotService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IStudioAssistUserPreferenceRepository studioAssistUserPreferenceRepository;
    @Inject
    private IAgentProfileManager agentProfileManager;
    private final Map<String, AgentSession> agentSessions = new ConcurrentHashMap<String, AgentSession>();
    private volatile String activeSelectionKey = "__GENERIC__";
    private final EventHandler onProjectOpenedHandler = this::onProjectOpened;
    private final EventHandler onProjectClosedHandler = this::onProjectClosed;
    private final AtomicReference<AgentProfile> activeAgentProfile = new AtomicReference();

    public void initializeSession() {
        this.eventBroker.subscribe("PROJECT/OPENED", this.onProjectOpenedHandler);
        this.eventBroker.subscribe("PROJECT/CLOSED", this.onProjectClosedHandler);
        this.initializeSelectionFromUserPreference();
        this.getActiveSession();
        this.initializeMcpClientsForAllAgentProfiles();
        this.eventBroker.post("ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED", (Object)this.activeAgentProfile.get());
    }

    public void disposeSession() {
        this.eventBroker.unsubscribe(this.onProjectOpenedHandler);
        this.eventBroker.unsubscribe(this.onProjectClosedHandler);
        for (AgentSession each : this.agentSessions.values()) {
            for (McpClient client : each.getMcpClients()) {
                if (client == null || client.isBuiltin()) continue;
                this.agentManager.closeClient(client);
                client.setStatus(McpServerConnectionStatus.DISCONNECTED);
            }
        }
        this.agentSessions.clear();
    }

    public void addServer(McpServerDefinition server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.addServer(session, server, agentProfile);
    }

    public void disableServer(String server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.disableServer(session, server, agentProfile);
    }

    public void enableServer(String server, String agentProfileName) {
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        AgentSession session = this.getSessionForProfile(agentProfileName);
        this.agentManager.enableServer(session, server, agentProfile);
    }

    public void removeServer(String server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.removeServer(session, server, agentProfile);
    }

    public AuthorizationRequest requestServerAuthorization(String server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        return this.agentManager.requestServerAuthorization(session, server, agentProfileName);
    }

    public void authorizeClient(String state, String authorizationCode) {
        for (AgentSession agentProfileSession : this.agentSessions.values()) {
            AuthorizationRequest authRequest;
            McpClient client = agentProfileSession.getMcpClientByOAuthState(state);
            if (client == null || (authRequest = (AuthorizationRequest)client.getAuthorization().getRequests().get(state)) == null) continue;
            String agentProfileName = authRequest.getAgentProfileName();
            AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
            AgentSession session = this.getSessionForProfile(agentProfileName);
            this.agentManager.authorizeServer(session, state, authorizationCode, agentProfile);
            return;
        }
    }

    public McpClient refreshClient(String server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        McpClient client = session.getMcpClient(server);
        if (client == null) {
            this.reloadMcpClientsForProfile(session, this.agentProfileManager.getProfileByName(agentProfileName));
            client = session.getMcpClient(server);
            if (client == null) {
                return null;
            }
        }
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.refreshClient(session, client, agentProfile);
        return client;
    }

    public void excludeTools(String server, List<String> tools) {
    }

    public CompletableFuture<Void> sendMessage(ChatQuestionMessage question) {
        AgentSession session = this.getActiveSession();
        return ((CompletableFuture)this.agentManager.sendMessage(session, question, this.getAppliedAgentProfile()).thenCompose(this::processAgentResponseMessage)).thenApply(response -> null);
    }

    public CompletableFuture<Void> retryMessage(ChatQuestionMessage question) {
        AgentSession session = this.getActiveSession();
        return ((CompletableFuture)this.agentManager.retryMessage(session, question, this.getAppliedAgentProfile()).thenCompose(this::processAgentResponseMessage)).thenApply(response -> null);
    }

    public void approveToolCall(AgentMessage agentMessage, ToolCallApproval approval) {
        this.agentManager.approveToolCall(this.getActiveSession(), agentMessage, approval, this.getAppliedAgentProfile());
    }

    public void denyToolCall(AgentMessage agentMessage) {
        this.agentManager.denyToolCall(this.getActiveSession(), agentMessage, this.getAppliedAgentProfile());
    }

    public void acknowledgeMaxedToolCall(AgentMessage agentMessage) {
        this.agentManager.acknowledgeMaxedToolCall(this.getActiveSession(), agentMessage, this.getAppliedAgentProfile());
    }

    public void rejectMaxedToolCall(AgentMessage agentMessage) {
        this.agentManager.rejectMaxedToolCall(this.getActiveSession(), agentMessage, this.getAppliedAgentProfile());
    }

    public void stopGeneration(AgentMessage agentMessage) {
        this.agentManager.stopGeneration(this.getActiveSession(), agentMessage);
    }

    public void clearConversation() {
        this.cleanupSnapshots(this.getConversation());
        this.agentManager.clearConversation(this.getActiveSession());
    }

    public String getCurrentConversationId() {
        return this.getActiveSession().getConversation().getConversationId();
    }

    public void getFollowUpQuestions(String conversationId, String questionId) throws StudioAssistBaseException {
        this.agentManager.getFollowUpQuestions(this.getActiveSession(), conversationId, questionId);
    }

    public void resetApprovedTools(List<McpServerSetting> mcpServerSettings) {
        this.agentManager.resetApprovedTools(mcpServerSettings, this.getAppliedAgentProfile());
    }

    public List<McpClient> getMcpClients(String agentProfileName) {
        return this.getSessionForProfile(agentProfileName).getMcpClients();
    }

    public AgentMessage findAgentMessageById(String messageId) {
        if (messageId == null) {
            return null;
        }
        AgentSession session = this.getActiveSession();
        if (session.getConversation() == null) {
            return null;
        }
        return session.getConversation().getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).map(StudioAssistChatPair::getResponse).filter(response -> response instanceof AgentMessage).map(response -> (AgentMessage)response).filter(agentMessage -> messageId.equals(agentMessage.getMessageId())).findFirst().orElse(null);
    }

    public void selectTool(String server, String tool, String agentProfileName) {
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.selectTool(server, tool, agentProfile);
    }

    public void deselectTool(String server, String tool, String agentProfileName) {
        AgentProfile profile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.deselectTool(server, tool, profile);
    }

    public void selectAllTools(String server, String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        this.agentManager.selectAllTools(session.getMcpClient(server), agentProfile);
    }

    public void deselectAllTools(String server, String agentProfile) {
        AgentSession session = this.getSessionForProfile(agentProfile);
        this.agentManager.deselectAllTools(session.getMcpClient(server), this.agentProfileManager.getProfileByName(agentProfile));
    }

    private CompletableFuture<ResponseMessage> processAgentResponseMessage(Pair<AgentMessage, ResponseMessage> messages) {
        if (messages == null) {
            return CompletableFuture.completedFuture(null);
        }
        AgentSession session = this.getActiveSession();
        return this.agentManager.processAgentResponseMessage(session, messages, this.getAppliedAgentProfile()).thenCompose(newResponse -> {
            if (newResponse == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.processAgentResponseMessage((Pair<AgentMessage, ResponseMessage>)Pair.of((Object)((AgentMessage)messages.getLeft()), (Object)newResponse));
        });
    }

    public McpSetting getMcpSetting(String agentProfileName) {
        AgentProfile agentProfile = agentProfileName != null ? this.agentProfileManager.getProfileByName(agentProfileName) : null;
        return this.agentManager.getMcpSetting(agentProfile);
    }

    public boolean undoEntityModification(Entity entity) {
        return this.agentManager.undoEntityModification(this.getActiveSession(), entity);
    }

    public boolean markEntityModificationReviewed(Entity entity) {
        return this.agentManager.markEntityModificationReviewed(this.getActiveSession(), entity);
    }

    public boolean undoAllEntityModifications(String messageId) {
        AgentMessage agentMessage = this.findAgentMessageById(messageId);
        return this.agentManager.undoAllEntityModifications(this.getActiveSession(), agentMessage);
    }

    public boolean markAllEntityModificationsReviewed(String messageId) {
        AgentMessage agentMessage = this.findAgentMessageById(messageId);
        return this.agentManager.markAllEntityModificationsReviewed(this.getActiveSession(), agentMessage);
    }

    public AgentSetting getAgentSetting() {
        return this.agentManager.getAgentSetting(this.getAppliedAgentProfile());
    }

    public AgentSetting getAgentSetting(String agentProfileName) {
        AgentProfile profile = StringUtils.isBlank((CharSequence)agentProfileName) ? null : this.agentProfileManager.getProfileByName(agentProfileName);
        return this.agentManager.getAgentSetting(profile);
    }

    public AgentConversation getConversation() {
        return this.getActiveSession().getConversation();
    }

    public List<ToolCallMessage> getAvailableTools() {
        return this.agentManager.getAvailableTools(this.getActiveSession(), this.getAppliedAgentProfile());
    }

    public AgentProfile getAppliedAgentProfile() {
        return this.activeAgentProfile.get();
    }

    public void updateAppliedAgentProfile(String agentProfileName) {
        AgentProfile agentProfile = this.agentProfileManager.getProfileByName(agentProfileName);
        if (this.hasProfileSelectionChanged(agentProfile)) {
            this.getActiveSession();
            this.syncMcpClientsForCurrentSelection();
            this.persistSelectedProfileForCurrentProject(agentProfile != null ? StringUtils.trimToNull((String)agentProfile.getName()) : null);
            this.eventBroker.post("ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED", (Object)agentProfile);
        }
    }

    public void syncMcpClientsForProfile(String agentProfileName) {
        AgentSession session = this.getSessionForProfile(agentProfileName);
        AgentProfile profile = this.agentProfileManager != null ? this.agentProfileManager.getProfileByName(agentProfileName) : null;
        this.reloadMcpClientsForProfile(session, profile);
    }

    private void onProjectOpened(Event event) {
        this.applyAgentProfileFromUserPreference();
        this.eventBroker.post("ON_AGENT_PROFILES_UPDATED", null);
    }

    private void onProjectClosed(Event event) {
        this.setActiveSelection(null);
        this.closeAgentProfiles();
        this.eventBroker.post("ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED", null);
        this.eventBroker.post("ON_AGENT_PROFILES_UPDATED", null);
    }

    private String getLastSelectedAgentProfileNameFromPreference() {
        String selectedAgentProfileName;
        block9: {
            block8: {
                StudioAssistUserPreference preference;
                String projectLocation;
                block7: {
                    block6: {
                        try {
                            projectLocation = this.getCurrentProjectLocation();
                            if (projectLocation != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            logger.warn("Unable to resolve agent profile from user preference", (Throwable)e);
                            return null;
                        }
                    }
                    preference = this.studioAssistUserPreferenceRepository.getUserPreference();
                    if (preference != null) break block7;
                    return null;
                }
                selectedAgentProfileName = StringUtils.trimToNull((String)preference.getLastSelectedAgentProfile(projectLocation));
                if (selectedAgentProfileName != null) break block8;
                return null;
            }
            if (this.agentProfileManager.getProfileByName(selectedAgentProfileName) != null) break block9;
            return null;
        }
        return selectedAgentProfileName;
    }

    private void persistSelectedProfileForCurrentProject(String agentProfileName) {
        try {
            String projectLocation = this.getCurrentProjectLocation();
            if (projectLocation == null) {
                return;
            }
            StudioAssistUserPreference preference = this.studioAssistUserPreferenceRepository.getUserPreference();
            preference.setLastSelectedAgentProfile(projectLocation, agentProfileName);
            this.studioAssistUserPreferenceRepository.saveUserPreference(preference);
        }
        catch (Exception e) {
            logger.warn("Unable to persist selected agent profile", (Throwable)e);
        }
    }

    private void syncMcpClientsForCurrentSelection() {
        this.reloadMcpClientsForProfile(this.getActiveSession(), this.getAppliedAgentProfile());
    }

    private void initializeMcpClientsForAllAgentProfiles() {
        this.reloadMcpClientsForProfile(this.getSessionForProfile(null), null);
        if (this.getCurrentProjectLocation() == null) {
            return;
        }
        List profiles = this.agentProfileManager.listProfiles(false);
        for (AgentProfile profile : profiles) {
            if (profile == null || StringUtils.isBlank((CharSequence)profile.getName())) continue;
            AgentSession session = this.getSessionForProfile(profile.getName());
            this.reloadMcpClientsForProfile(session, profile);
        }
    }

    private void reloadMcpClientsForProfile(AgentSession session, AgentProfile agentProfile) {
        try {
            this.agentManager.syncMcpClients(session, agentProfile);
        }
        catch (Exception e) {
            logger.warn("Failed to reload MCP clients for selection", (Throwable)e);
        }
    }

    private void initializeSelectionFromUserPreference() {
        if (this.getCurrentProjectLocation() == null) {
            this.setActiveSelection(null);
            return;
        }
        String initialProfileName = this.getLastSelectedAgentProfileNameFromPreference();
        AgentProfile initialProfile = this.agentProfileManager.getProfileByName(initialProfileName);
        this.setActiveSelection(initialProfile);
    }

    private void applyAgentProfileFromUserPreference() {
        String profileName = this.getLastSelectedAgentProfileNameFromPreference();
        if (profileName != null) {
            AgentProfile selectedProfile = this.agentProfileManager.getProfileByName(profileName);
            if (this.hasProfileSelectionChanged(selectedProfile)) {
                this.getActiveSession();
                this.eventBroker.post("ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED", (Object)selectedProfile);
            }
            this.initializeMcpClientsForAllAgentProfiles();
        }
    }

    private boolean hasProfileSelectionChanged(AgentProfile selectedProfile) {
        String selectedProfileKey = selectedProfile != null ? StringUtils.trimToNull((String)selectedProfile.getName()) : null;
        String string = selectedProfileKey = selectedProfileKey != null ? selectedProfileKey : GENERIC_AGENT_SELECTION_KEY;
        if (Objects.equals(this.activeSelectionKey, selectedProfileKey)) {
            return false;
        }
        this.setActiveSelection(selectedProfile);
        return true;
    }

    private void setActiveSelection(AgentProfile profile) {
        this.activeAgentProfile.set(profile);
        String selectionKey = profile != null ? StringUtils.trimToNull((String)profile.getName()) : null;
        this.activeSelectionKey = selectionKey != null ? selectionKey : GENERIC_AGENT_SELECTION_KEY;
    }

    private void closeAgentProfiles() {
        for (String selectionKey : this.agentSessions.keySet()) {
            AgentSession agentSession;
            if (Objects.equals(selectionKey, GENERIC_AGENT_SELECTION_KEY) || (agentSession = this.agentSessions.remove(selectionKey)) == null) continue;
            for (McpClient client : agentSession.getMcpClients()) {
                if (client == null) continue;
                this.agentManager.closeClient(client);
            }
        }
    }

    private String getCurrentProjectLocation() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return project != null ? StringUtils.trimToNull((String)project.getLocation()) : null;
    }

    private AgentSession getActiveSession() {
        return this.agentSessions.computeIfAbsent(this.activeSelectionKey, ignored -> new AgentSession());
    }

    private AgentSession getSessionForProfile(String agentProfileName) {
        if (StringUtils.isBlank((CharSequence)agentProfileName)) {
            return this.agentSessions.computeIfAbsent(GENERIC_AGENT_SELECTION_KEY, ignored -> new AgentSession());
        }
        AgentProfile profile = this.agentProfileManager.getProfileByName(agentProfileName);
        String selectionKey = profile != null ? StringUtils.trimToNull((String)profile.getName()) : null;
        selectionKey = selectionKey != null ? selectionKey : GENERIC_AGENT_SELECTION_KEY;
        return this.agentSessions.computeIfAbsent(selectionKey, ignored -> new AgentSession());
    }

    private void cleanupSnapshots(AgentConversation conversation) {
        if (conversation == null) {
            return;
        }
        conversation.getEntityModifications().forEach(modification -> {
            try {
                boolean isCreate;
                boolean bl = isCreate = modification.getType() == EntityModificationType.CREATED;
                if (!isCreate && StringUtils.isNotBlank((CharSequence)modification.getSnapshotId())) {
                    this.fileSnapshotService.deleteSnapshot(modification.getSnapshotId());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to cleanup snapshot for entity {}", (Object)modification.getEntity().getId(), (Object)e);
            }
        });
    }
}

