/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingContextTypeEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.controller.IStudioAssistChatController;
import com.kms.katalon.ai.core.dto.StudioAssistChatRateConversationRequest;
import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContext;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistAvailabilityException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiIncompatibleModelException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistMismatchConversationIdException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.ai.services.internal.StudioAssistConversationManager;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class StudioAssistChatController
implements IStudioAssistChatController {
    private static final int MAX_DURATION_WAITING_FOR_CHECK_QUESTION = 60;
    private static final int EXPAND_STEP_CHAT_HISTORY_QUEUE_CAPACITY = 20;
    private static final boolean QUEUE_CHANGE_OPENRATION_FAIR = true;
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatController.class);
    @Inject
    private IStudioAssistService studioAssistService;
    @Inject
    private IStudioAssistTrackingService studioAssistTrackingService;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private StudioAssistConversationManager conversationManager;
    @Inject
    private ISessionController sessionController;
    private StudioAssistConversation conversation;

    @PostConstruct
    public void postConstructor() {
        this.conversation = this.conversationManager.getConversation();
    }

    public StudioAssistChatStatus validateFunctionAvailability() {
        try {
            LlmConfigType llmConfigType = Optional.ofNullable(this.studioAssistService.getConfig()).map(StudioAssistConfig::getType).orElse(LlmConfigType.NONE);
            boolean isOnline = this.testOpsController.isOnline();
            if (!isOnline) {
                return StudioAssistChatStatus.INTERNET_DISCONNECTED;
            }
            if (LlmConfigType.NONE == llmConfigType) {
                try {
                    if (this.studioAssistService.canExecute()) {
                        return StudioAssistChatStatus.AVAILABLE;
                    }
                    return StudioAssistChatStatus.ACCOUNT_LEVEL_AI_DISABLED;
                }
                catch (StudioAssistAvailabilityException | StudioAssistConfigException e) {
                    this.logger.error("Cannot fetch default setting for StudioAssistChat", e);
                    return StudioAssistChatStatus.ACCOUNT_LEVEL_AI_DISABLED;
                }
            }
            if (LlmConfigType.GEN_AI == llmConfigType) {
                boolean isOfflineOrOP;
                boolean enableAI = AiConfigPolicyType.AI_DISABLED != this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
                boolean bl = isOfflineOrOP = !ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO);
                if (!enableAI || isOfflineOrOP) {
                    return StudioAssistChatStatus.ACCOUNT_LEVEL_AI_DISABLED;
                }
            }
            if (!this.isLlmModelCompatible()) {
                return StudioAssistChatStatus.LLM_MODEL_UNSUPPORTED;
            }
            return StudioAssistChatStatus.AVAILABLE;
        }
        catch (StudioAssistLoadingConfigException e) {
            this.logger.error("Exception while validateFunctionAvailability -> getConfig", (Throwable)e);
            return StudioAssistChatStatus.ACCOUNT_LEVEL_AI_DISABLED;
        }
    }

    @Deprecated
    public StudioAssistChatAnswerMessageFuture askQuestion(List<StudioAssistChatReferenceContextMessage> context, ChatQuestionMessage question) throws StudioAssistBaseException {
        return this.studioAssistService.askQuestion(PromptType.CHATBOT, this.conversation.getValidChatItems(), question, Map.of());
    }

    @Deprecated
    public StudioAssistChatAnswerMessageFuture retryQuestion(List<StudioAssistChatReferenceContextMessage> context, ChatQuestionMessage question) throws StudioAssistBaseException {
        if (!StringUtils.equals((CharSequence)this.getCurrentConversationId(), (CharSequence)question.getMessageId())) {
            throw new StudioAssistMismatchConversationIdException("Mismatch conversationId | system = %s | supplied = %s".formatted(this.getCurrentConversationId(), question.getMessageId()));
        }
        StudioAssistChatItem chatItem = this.conversation.getMessages().stream().filter(item -> {
            StudioAssistChatPair pair;
            return item instanceof StudioAssistChatPair && StringUtils.equals((CharSequence)(pair = (StudioAssistChatPair)item).getRequest().getMessageId(), (CharSequence)question.getMessageId());
        }).findFirst().orElse(null);
        if (chatItem != null) {
            this.conversation.getMessages().remove(chatItem);
        }
        this.appendToConversation(context);
        return this.studioAssistService.askQuestion(PromptType.CHATBOT, this.conversation.getValidChatItems(), question, Map.of());
    }

    public void appendToConversation(ChatQuestionMessage question, StudioAssistChatAnswerMessage answer, boolean isGoodQuestion) throws StudioAssistBaseException {
        if (StringUtils.equals((CharSequence)question.getMessageId(), (CharSequence)answer.getMessageId())) {
            this.innerAppendChatItemIntoConversationHistory((StudioAssistChatItem)new StudioAssistChatPair(question, (ResponseMessage)answer, null, isGoodQuestion));
            return;
        }
        throw new StudioAssistMismatchConversationIdException("Mismatch conversationId | system = %s | supplied = %s".formatted(this.getCurrentConversationId()));
    }

    private void appendToConversation(List<StudioAssistChatReferenceContextMessage> context) {
        if (context == null || context.isEmpty()) {
            return;
        }
        for (StudioAssistChatReferenceContextMessage each : context) {
            if (!StringUtils.equals((CharSequence)this.getCurrentConversationId(), (CharSequence)each.getConversationId())) continue;
            this.innerAppendChatItemIntoConversationHistory((StudioAssistChatItem)new StudioAssistChatReferenceContext(new StudioAssistChatReferenceContextMessage[]{each}));
        }
    }

    public void cleanUpConversation(String conversationId) throws StudioAssistBaseException {
        if (StringUtils.equals((CharSequence)this.getCurrentConversationId(), (CharSequence)conversationId)) {
            this.cleanUpConversation();
            return;
        }
        throw new StudioAssistMismatchConversationIdException("Mismatch conversationId | system = %s | supplied = %s".formatted(this.getCurrentConversationId(), conversationId));
    }

    public void close() throws Exception {
        this.logger.trace("Close StudioAssistChatController");
        this.cleanUpConversation();
    }

    public String getCurrentConversationId() {
        return this.conversation.getConversationId();
    }

    private void cleanUpConversation() {
        this.conversation.reset();
        this.logger.trace("after cleanUpConversation -> " + JsonUtil.toJson((Object)this.conversation));
    }

    private void innerAppendChatItemIntoConversationHistory(StudioAssistChatItem chatItem) {
        ArrayBlockingQueue chatHistory = this.conversation.getMessages();
        if (chatHistory.remainingCapacity() == 0) {
            this.conversation.increaseQueueSize(20, true);
        }
        if (chatItem instanceof StudioAssistChatPair) {
            StudioAssistChatPair pair = (StudioAssistChatPair)chatItem;
            this.handleAttachments(pair);
        }
        if (!this.conversation.addChatItemIntoHistory(chatItem)) {
            this.logger.error("The chat history capacity reached");
        }
        this.logger.trace("after appendToConversation -> " + JsonUtil.toJson((Object)this.conversation));
    }

    private void handleAttachments(StudioAssistChatPair pair) {
        List<StudioAssistChatAttachment> uploadedAttachments;
        if (pair.getRequest() != null && pair.getRequest().getAttachments() != null && !pair.getRequest().getAttachments().isEmpty() && (uploadedAttachments = this.getUploadedAttachments()) != null && !uploadedAttachments.isEmpty()) {
            List currentAttachments = pair.getRequest().getAttachments();
            this.removeDuplicateAndBlankAttachments(currentAttachments, uploadedAttachments);
            pair.getRequest().setAttachments(currentAttachments);
        }
    }

    private void removeDuplicateAndBlankAttachments(List<StudioAssistChatAttachment> currentAttachments, List<StudioAssistChatAttachment> uploadedAttachments) {
        int i = 0;
        while (i < currentAttachments.size()) {
            StudioAssistChatAttachment each = currentAttachments.get(i);
            if (StringUtils.isBlank((CharSequence)each.getFileContent())) {
                currentAttachments.remove(i);
            } else {
                List foundAttachments = uploadedAttachments.stream().filter(e -> e.getFilePath().equals(each.getFilePath()) && DateUtils.isSameDay((Date)each.getDateModified(), (Date)e.getDateModified())).collect(Collectors.toList());
                if (!foundAttachments.isEmpty()) {
                    currentAttachments.remove(i);
                }
            }
            ++i;
        }
    }

    private boolean isLlmModelCompatible() {
        try {
            LlmConfigType llmConfigType = Optional.ofNullable(this.studioAssistService.getConfig()).map(StudioAssistConfig::getType).orElse(LlmConfigType.NONE);
            if (LlmConfigType.NONE != llmConfigType && LlmConfigType.GEN_AI != llmConfigType) {
                this.askQuestion(null, new ChatQuestionMessage("")).get(60L, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof StudioAssistLlmApiIncompatibleModelException) {
                return false;
            }
            this.logger.error("Exception while check isLlmModelCompatible", (Throwable)e);
            return true;
        }
    }

    private List<StudioAssistChatAttachment> getUploadedAttachments() {
        return this.conversation.getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> ((StudioAssistChatPair)item).getRequest()).map(item -> item.getAttachments()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    public StudioAssistChatAnswerMessageFuture getFollowUpQuestions(String conversationId, String questionId) throws StudioAssistBaseException {
        List validConversation = this.conversation.getValidChatItems();
        String followUpQuestionRequest = "Based on your last answer, list out 2 follow up questions relating to Katalon to deep dive into it. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
        if (validConversation.isEmpty()) {
            followUpQuestionRequest = "As an automation tester using Katalon Studio, suggest 2 questions. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
        }
        ChatQuestionMessage question = new ChatQuestionMessage(followUpQuestionRequest);
        return this.askQuestion(null, question);
    }

    public void trackOpenStudioAssistChat(String triggerMethod, String pageState, String chatMode) {
        this.studioAssistTrackingService.trackOpenStudioAssistChat(triggerMethod, pageState, chatMode);
    }

    public void trackCloseStudioAssistChat(StudioAssistConversation conversation, String chatMode) {
        this.studioAssistTrackingService.trackCloseStudioAssistChat(conversation, chatMode);
    }

    public void trackUsingAttachment(String conversationId, String questionId, List<StudioAssistChatAttachment> attachments, String chatMode) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        for (StudioAssistChatAttachment attachment : attachments) {
            ArrayList<String> trackingData = new ArrayList<String>();
            trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
            trackingData.add(conversationId);
            trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
            trackingData.add(questionId);
            trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
            trackingData.add(attachment.getFileClientId());
            if (StudioAssistAttachmentSource.FOCUSING_FILE.equals((Object)attachment.getFileSource())) {
                trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                trackingData.add(StudioAssistTrackingContextTypeEnum.CURRENT_FILE.getValue());
            } else if (StudioAssistTrackingContextTypeEnum.CUSTOM_KEYWORD.equals((Object)attachment.getFileType())) {
                trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                trackingData.add(StudioAssistTrackingContextTypeEnum.CUSTOM_KEYWORD.getValue());
            } else {
                ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                String projectLocation = currentProject == null ? null : currentProject.getFolderLocation();
                String attachmentPath = attachment.getFilePath();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{projectLocation}) && StringUtils.startsWith((CharSequence)attachmentPath, (CharSequence)projectLocation)) {
                    trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                    trackingData.add(StudioAssistTrackingContextTypeEnum.PROJECT_FILE_ATTACHMENT.getValue());
                } else {
                    trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
                    trackingData.add(StudioAssistTrackingContextTypeEnum.EXTERNAL_FILE_ATTACHMENT.getValue());
                }
            }
            trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
            trackingData.add(chatMode.toLowerCase());
            this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
        }
    }

    public List<StudioAssistChatPair> getConversationPairs() {
        ArrayBlockingQueue chatHistory = this.conversation.getMessages();
        ArrayList<StudioAssistChatPair> conversationPairs = new ArrayList<StudioAssistChatPair>();
        for (StudioAssistChatItem item : chatHistory) {
            if (!(item instanceof StudioAssistChatPair)) continue;
            StudioAssistChatPair pair = (StudioAssistChatPair)item;
            conversationPairs.add(pair);
        }
        return conversationPairs;
    }

    public void trackStudioAssistChat(List<Object> trackingData) {
        this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
    }

    public void trackStudioAssistAgentSetting(Map<String, Object> trackingData) {
        this.studioAssistTrackingService.trackStudioAssistAgentSetting(trackingData);
    }

    public StudioAssistConversation getCurrentConversation() {
        return this.conversation;
    }

    public void addAgentModeTrackingData(List<Object> trackingData, IAgentSessionContext sessionContext) {
        this.studioAssistTrackingService.addAgentModeTrackingData(trackingData, sessionContext);
    }

    public void trackRateConversation(StudioAssistChatRateConversationRequest request, StudioAssistConversation conversation, String chatMode) {
        List ratingTrackingData = this.studioAssistService.buildRatingTrackingData(request, conversation, chatMode);
        this.trackStudioAssistChat(ratingTrackingData);
    }
}

