/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.dto;

import com.kms.katalon.ai.core.dto.ChatML;
import com.kms.katalon.ai.core.dto.Configuration;
import com.kms.katalon.ai.core.dto.ResponseFormat;
import java.util.List;

public class ChatCompletionRequest {
    private Configuration config;
    private String modelName;
    private ResponseFormat responseFormat;
    private List<ChatML> messages;

    public ChatCompletionRequest(Configuration config) {
        this.config = config;
    }

    public ChatCompletionRequest(List<ChatML> messages) {
        this.responseFormat = new ResponseFormat();
        this.messages = messages;
    }

    private ChatCompletionRequest(Builder builder) {
        this.config = builder.config;
        this.modelName = builder.modelName;
        this.responseFormat = builder.responseFormat;
        this.messages = builder.messages;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public List<ChatML> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChatML> messages) {
        this.messages = messages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Configuration config;
        private String modelName;
        private ResponseFormat responseFormat;
        private List<ChatML> messages;

        private Builder() {
        }

        public Builder config(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder messages(List<ChatML> messages) {
            this.messages = messages;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this);
        }
    }
}

