/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.factory;

import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.NoneConfig;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.preferences.AwsBedrockPreferenceStore;
import com.kms.katalon.ai.preferences.AzureOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.GeminiPreferenceStore;
import com.kms.katalon.ai.preferences.GenAIPreferenceStore;
import com.kms.katalon.ai.preferences.NonePreferenceStore;
import com.kms.katalon.ai.preferences.OpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.OpenAiCompatiblePreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;

public class StudioAssistStoreFactory {
    public StudioAssistPreferenceStore get(LlmConfigType type) {
        switch (type) {
            case OPENAI: {
                return new OpenAIPreferenceStore();
            }
            case AZURE_OPENAI: {
                return new AzureOpenAIPreferenceStore();
            }
            case GEMINI: {
                return new GeminiPreferenceStore();
            }
            case OPENAI_COMPATIBLE: {
                return new OpenAiCompatiblePreferenceStore();
            }
            case AWS_BEDROCK: {
                return new AwsBedrockPreferenceStore();
            }
            case NONE: {
                return new NonePreferenceStore();
            }
        }
        return new GenAIPreferenceStore();
    }

    public StudioAssistPreferenceStore get(StudioAssistConfig credential) {
        if (credential instanceof OpenAIConfig) {
            return new OpenAIPreferenceStore();
        }
        if (credential instanceof AzureOpenAIConfig) {
            return new AzureOpenAIPreferenceStore();
        }
        if (credential instanceof GeminiConfig) {
            return new GeminiPreferenceStore();
        }
        if (credential instanceof OpenAiCompatibleConfig) {
            return new OpenAiCompatiblePreferenceStore();
        }
        if (credential instanceof AwsBedrockConfig) {
            return new AwsBedrockPreferenceStore();
        }
        if (credential instanceof NoneConfig) {
            return new NonePreferenceStore();
        }
        return new GenAIPreferenceStore();
    }
}

